/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.InvalidationHandler;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.preload.PreloadModule;
import org.apache.shindig.gadgets.render.RenderModule;
import org.apache.shindig.gadgets.rewrite.RewriteModule;
import org.apache.shindig.gadgets.servlet.HttpRequestHandler;
import org.apache.shindig.gadgets.templates.TemplateModule;

public class DefaultGuiceModule
extends AbstractModule {
    public static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    };

    protected void configure() {
        final ExecutorService service = Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY);
        this.bind(Executor.class).toInstance((Object)service);
        this.bind(ExecutorService.class).toInstance((Object)service);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                service.shutdownNow();
            }
        });
        this.install((Module)new ParseModule());
        this.install((Module)new PreloadModule());
        this.install((Module)new RenderModule());
        this.install((Module)new RewriteModule());
        this.install((Module)new TemplateModule());
        this.bind((TypeLiteral)new TypeLiteral<Set<Object>>(){}).annotatedWith((Annotation)Names.named((String)"org.apache.shindig.gadgets.handlers")).toInstance((Object)ImmutableSet.of(InvalidationHandler.class, HttpRequestHandler.class));
        this.requestStaticInjection(new Class[]{HttpResponse.class});
    }
}

