/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import net.oauth.OAuthAccessor;
import org.apache.shindig.gadgets.oauth.OAuthStore;

public class AccessorInfo {
    private final OAuthAccessor accessor;
    private final OAuthStore.ConsumerInfo consumer;
    private final HttpMethod httpMethod;
    private final OAuthParamLocation paramLocation;
    private String sessionHandle;
    private long tokenExpireMillis;

    public AccessorInfo(OAuthAccessor accessor, OAuthStore.ConsumerInfo consumer, HttpMethod httpMethod, OAuthParamLocation paramLocation, String sessionHandle, long tokenExpireMillis) {
        this.accessor = accessor;
        this.consumer = consumer;
        this.httpMethod = httpMethod;
        this.paramLocation = paramLocation;
        this.sessionHandle = sessionHandle;
        this.tokenExpireMillis = tokenExpireMillis;
    }

    public OAuthParamLocation getParamLocation() {
        return this.paramLocation;
    }

    public OAuthAccessor getAccessor() {
        return this.accessor;
    }

    public OAuthStore.ConsumerInfo getConsumer() {
        return this.consumer;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getSessionHandle() {
        return this.sessionHandle;
    }

    public void setSessionHandle(String sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public long getTokenExpireMillis() {
        return this.tokenExpireMillis;
    }

    public void setTokenExpireMillis(long tokenExpireMillis) {
        this.tokenExpireMillis = tokenExpireMillis;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OAuthParamLocation {
        AUTH_HEADER,
        POST_BODY,
        URI_QUERY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HttpMethod {
        GET,
        POST;

    }
}

