/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.TokenStream;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Criterion;
import com.google.inject.Inject;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.gadgets.GadgetException;

public class CajaCssParser {
    private static final URI FAKE_SOURCE = URI.create("http://a.dummy.url");
    private static final String PARSED_CSS = "parsedCssDom";
    private Cache<String, CssTree.StyleSheet> parsedCssCache;

    @Inject
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.parsedCssCache = cacheProvider.createCache(PARSED_CSS);
    }

    public CssTree.StyleSheet parseDom(String content) throws GadgetException {
        CssTree.StyleSheet parsedCss = null;
        boolean shouldCache = this.shouldCache();
        String key = null;
        if (shouldCache) {
            key = HashUtil.rawChecksum((byte[])content.getBytes());
            parsedCss = (CssTree.StyleSheet)this.parsedCssCache.getElement((Object)key);
        }
        if (parsedCss == null) {
            try {
                parsedCss = this.parseImpl(content);
                if (shouldCache) {
                    this.parsedCssCache.addElement((Object)key, (Object)parsedCss);
                }
            }
            catch (ParseException pe) {
                throw new GadgetException(GadgetException.Code.CSS_PARSE_ERROR, pe, 400);
            }
        }
        if (shouldCache) {
            return (CssTree.StyleSheet)parsedCss.clone();
        }
        return parsedCss;
    }

    private CssTree.StyleSheet parseImpl(String css) throws ParseException {
        InputSource inputSource = new InputSource(FAKE_SOURCE);
        CharProducer producer = CharProducer.Factory.create((StringReader)new StringReader(css), (InputSource)inputSource);
        CssLexer lexer = new CssLexer(producer);
        TokenQueue queue = new TokenQueue((TokenStream)lexer, inputSource, (Criterion)new Criterion<Token<CssTokenType>>(){

            public boolean accept(Token<CssTokenType> t) {
                return CssTokenType.SPACE != t.type && CssTokenType.COMMENT != t.type;
            }
        });
        if (queue.isEmpty()) {
            return new CssTree.StyleSheet(null, Collections.emptyList());
        }
        SimpleMessageQueue mq = new SimpleMessageQueue();
        CssParser parser = new CssParser(queue, (MessageQueue)mq, MessageLevel.WARNING);
        return parser.parseStyleSheet();
    }

    public String serialize(CssTree.StyleSheet styleSheet) {
        StringWriter writer = new StringWriter();
        this.serialize(styleSheet, writer);
        return writer.toString();
    }

    public void serialize(CssTree.StyleSheet styleSheet, Writer writer) {
        CssPrettyPrinter cssPrinter = new CssPrettyPrinter((TokenConsumer)new Concatenator((Appendable)writer, null));
        styleSheet.render(new RenderContext((TokenConsumer)cssPrinter));
        cssPrinter.noMoreTokens();
    }

    private boolean shouldCache() {
        return this.parsedCssCache != null && this.parsedCssCache.getCapacity() != 0L;
    }
}

