/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.preload.PipelineExecutor;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.View;

public class ProxyRenderer {
    public static final String PATH_PARAM = "path";
    private final RequestPipeline requestPipeline;
    private final HttpCache httpCache;
    private final PipelineExecutor pipelineExecutor;

    @Inject
    public ProxyRenderer(RequestPipeline requestPipeline, HttpCache httpCache, PipelineExecutor pipelineExecutor) {
        this.requestPipeline = requestPipeline;
        this.httpCache = httpCache;
        this.pipelineExecutor = pipelineExecutor;
    }

    public String render(Gadget gadget) throws RenderingException, GadgetException {
        View view = gadget.getCurrentView();
        Uri href = view.getHref();
        Preconditions.checkArgument((href != null ? 1 : 0) != 0, (Object)"Gadget does not have href for the current view");
        GadgetContext context = gadget.getContext();
        String path = context.getParameter(PATH_PARAM);
        if (path != null) {
            try {
                Uri relative = Uri.parse((String)path);
                if (!relative.isAbsolute()) {
                    href = href.resolve(relative);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        UriBuilder uri = new UriBuilder(href);
        uri.addQueryParameter("lang", context.getLocale().getLanguage());
        uri.addQueryParameter("country", context.getLocale().getCountry());
        OAuthArguments oauthArgs = new OAuthArguments(view);
        oauthArgs.setProxiedContentRequest(true);
        HttpRequest request = new HttpRequest(uri.toUri()).setIgnoreCache(context.getIgnoreCache()).setOAuthArguments(oauthArgs).setAuthType(view.getAuthType()).setSecurityToken(context.getToken()).setContainer(context.getContainer()).setGadget(gadget.getSpec().getUrl());
        HttpResponse response = this.httpCache.getResponse(request);
        if (response == null || response.isStale()) {
            HttpRequest proxyRequest = this.createPipelinedProxyRequest(gadget, request);
            response = this.requestPipeline.execute(proxyRequest);
            this.httpCache.addResponse(request, response);
        }
        if (response.isError()) {
            throw new RenderingException("Unable to reach remote host. HTTP status " + response.getHttpStatusCode(), 404);
        }
        return response.getResponseAsString();
    }

    private HttpRequest createPipelinedProxyRequest(Gadget gadget, HttpRequest original) {
        PipelineExecutor.Results results;
        HttpRequest request = new HttpRequest(original);
        request.setIgnoreCache(true);
        PipelinedData data = gadget.getCurrentView().getPipelinedData();
        if (data != null && (results = this.pipelineExecutor.execute(gadget.getContext(), (Collection<PipelinedData>)ImmutableList.of((Object)data))) != null && !results.results.isEmpty()) {
            String postContent = JsonSerializer.serialize(results.results);
            request.setMethod("POST").setPostBody(CharsetUtil.getUtf8Bytes((String)postContent)).setHeader("Content-Type", "application/json;charset=utf-8");
        }
        return request;
    }
}

