/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.render.HtmlRenderer;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.render.RenderingResults;
import org.apache.shindig.gadgets.spec.View;

public class Renderer {
    private static final Logger LOG = Logger.getLogger(Renderer.class.getName());
    private final Processor processor;
    private final HtmlRenderer renderer;
    private final ContainerConfig containerConfig;
    private final LockedDomainService lockedDomainService;

    @Inject
    public Renderer(Processor processor, HtmlRenderer renderer, ContainerConfig containerConfig, LockedDomainService lockedDomainService) {
        this.processor = processor;
        this.renderer = renderer;
        this.containerConfig = containerConfig;
        this.lockedDomainService = lockedDomainService;
    }

    public RenderingResults render(GadgetContext context) {
        if (!this.validateParent(context)) {
            return RenderingResults.error("Unsupported parent parameter. Check your container code.", 400);
        }
        try {
            Gadget gadget = this.processor.process(context);
            if (gadget.getCurrentView() == null) {
                return RenderingResults.error("Unable to locate an appropriate view in this gadget. Requested: '" + gadget.getContext().getView() + "' Available: " + gadget.getSpec().getViews().keySet(), 404);
            }
            if (gadget.getCurrentView().getType() == View.ContentType.URL) {
                return RenderingResults.mustRedirect(gadget.getCurrentView().getHref());
            }
            if (!this.lockedDomainService.gadgetCanRender(context.getHost(), gadget, context.getContainer())) {
                return RenderingResults.error("Invalid domain", 400);
            }
            return RenderingResults.ok(this.renderer.render(gadget));
        }
        catch (RenderingException e) {
            return this.logError(context.getUrl(), e.getHttpStatusCode(), e);
        }
        catch (ProcessingException e) {
            return this.logError(context.getUrl(), e.getHttpStatusCode(), e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof GadgetException) {
                return this.logError(context.getUrl(), ((GadgetException)e.getCause()).getHttpStatusCode(), e.getCause());
            }
            throw e;
        }
    }

    private RenderingResults logError(Uri gadgetUrl, int statusCode, Throwable t) {
        LOG.info("Failed to render gadget " + gadgetUrl + ": " + t.getMessage());
        return RenderingResults.error(t.getMessage(), statusCode);
    }

    private boolean validateParent(GadgetContext context) {
        String container = context.getContainer();
        String parent = context.getParameter("parent");
        if (parent == null) {
            return true;
        }
        List parents = this.containerConfig.getList(container, "gadgets.parent");
        if (parents.isEmpty()) {
            return true;
        }
        for (Object pattern : parents) {
            if (!Pattern.matches(pattern.toString(), parent)) continue;
            return true;
        }
        return false;
    }
}

