/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.servlet.ProxyHandler;

public class ConcatProxyServlet
extends InjectedServlet {
    public static final String JSON_PARAM = "json";
    private static final Logger logger = Logger.getLogger(ConcatProxyServlet.class.getName());
    private transient ProxyHandler proxyHandler;

    @Inject
    public void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url;
        boolean ignoreCache;
        if (request.getHeader("If-Modified-Since") != null) {
            response.setStatus(304);
            return;
        }
        String ct = request.getParameter("rewriteMime");
        if (ct != null && ct.indexOf(13) < 0 && ct.indexOf(10) < 0) {
            response.setHeader("Content-Type", request.getParameter("rewriteMime"));
        }
        if (!(ignoreCache = this.proxyHandler.getIgnoreCache(request)) && request.getParameter("refresh") != null) {
            try {
                HttpUtil.setCachingHeaders((HttpServletResponse)response, (int)Integer.parseInt(request.getParameter("refresh")));
            }
            catch (NumberFormatException e) {
                HttpUtil.setNoCache((HttpServletResponse)response);
            }
        } else {
            HttpUtil.setNoCache((HttpServletResponse)response);
        }
        response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        String jsonVar = request.getParameter(JSON_PARAM);
        if (jsonVar != null && !jsonVar.matches("^\\w*$")) {
            response.getOutputStream().println(ConcatProxyServlet.formatHttpError(400, "Bad json variable name " + jsonVar));
            response.setStatus(400);
            return;
        }
        ResponseWrapper wrapper = new ResponseWrapper(response, jsonVar);
        for (int i = 1; i < Integer.MAX_VALUE && (url = request.getParameter(Integer.toString(i))) != null; ++i) {
            try {
                wrapper.processUrl(url);
                this.proxyHandler.doFetch((HttpServletRequest)new RequestWrapper(request, url), (HttpServletResponse)wrapper);
                if (wrapper.getStatus() == 200) continue;
                response.getOutputStream().println(ConcatProxyServlet.formatHttpError(wrapper.getStatus(), wrapper.getErrorMessage()));
                continue;
            }
            catch (GadgetException ge) {
                if (ge.getCode() != GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT) {
                    wrapper.done();
                    ConcatProxyServlet.outputError(ge, url, response);
                    return;
                }
                response.getOutputStream().println("/* ---- End " + url + " 404 ---- */");
            }
        }
        wrapper.done();
        response.setStatus(200);
    }

    private static String formatHttpError(int status, String errorMessage) {
        StringBuilder err = new StringBuilder();
        err.append("/* ---- Error ");
        err.append(status);
        if (errorMessage != null) {
            err.append(", ");
            err.append(errorMessage);
        }
        err.append(" ---- */");
        return err.toString();
    }

    private static void outputError(GadgetException excep, String url, HttpServletResponse resp) throws IOException {
        StringBuilder err = new StringBuilder();
        err.append(excep.getCode().toString());
        err.append(" concat(");
        err.append(url);
        err.append(") ");
        err.append(excep.getMessage());
        logger.log(Level.INFO, "Concat proxy request failed", err);
        resp.sendError(400, err.toString());
    }

    private static class EscapedServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream tempStream = new ByteArrayOutputStream();

        protected EscapedServletOutputStream() {
        }

        public byte[] getBytes() throws IOException {
            try {
                return StringEscapeUtils.escapeJavaScript((String)this.tempStream.toString("UTF8")).getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("Unsuported encoding in data");
            }
        }

        public void write(int b) throws IOException {
            this.tempStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.tempStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.tempStream.write(b);
        }
    }

    private static class NullServletOutputStream
    extends ServletOutputStream {
        protected NullServletOutputStream() {
        }

        public void write(int b) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private ServletOutputStream outputStream;
        private EscapedServletOutputStream jsonStream;
        private int errorCode = 200;
        private String errorMessage;
        private String jsonVar = null;
        private String url = null;

        protected ResponseWrapper(HttpServletResponse httpServletResponse, String jsonVar) throws IOException {
            super(httpServletResponse);
            if (jsonVar != null && jsonVar.length() > 0) {
                this.jsonVar = jsonVar;
                super.getOutputStream().println(jsonVar + "={");
            }
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.errorCode != 200) {
                this.closeStream();
                this.outputStream = new NullServletOutputStream();
            }
            if (this.outputStream == null) {
                this.outputStream = super.getOutputStream();
            }
            return this.outputStream;
        }

        public void processUrl(String fileUrl) throws IOException {
            this.closeStream();
            this.errorCode = 200;
            this.url = fileUrl;
            if (this.jsonVar == null) {
                super.getOutputStream().println("/* ---- Start " + this.url + " ---- */");
            } else {
                this.jsonStream = new EscapedServletOutputStream();
                this.outputStream = this.jsonStream;
            }
        }

        public void done() throws IOException {
            this.closeStream();
            if (this.jsonVar != null) {
                super.getOutputStream().println("};");
            }
        }

        private void closeStream() throws IOException {
            if (this.jsonVar == null && this.outputStream != null) {
                this.outputStream.println("/* ---- End " + this.url + " ---- */");
            } else if (this.jsonStream != null) {
                byte[] data = this.jsonStream.getBytes();
                ServletOutputStream mainStream = super.getOutputStream();
                mainStream.print("\"" + this.url + "\":\"");
                mainStream.write(data);
                mainStream.println("\",");
            }
            this.outputStream = null;
            this.jsonStream = null;
        }

        public int getStatus() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void addCookie(Cookie cookie) {
        }

        public void setDateHeader(String s, long l) {
        }

        public void addDateHeader(String s, long l) {
        }

        public void setHeader(String s, String s1) {
        }

        public void addHeader(String s, String s1) {
        }

        public void setIntHeader(String s, int i) {
        }

        public void addIntHeader(String s, int i) {
        }

        public void sendError(int i, String s) throws IOException {
            this.errorCode = i;
            this.errorMessage = s;
        }

        public void sendError(int i) throws IOException {
            this.errorCode = i;
        }

        public void sendRedirect(String s) throws IOException {
        }

        public void setStatus(int i) {
        }

        public void setStatus(int i, String s) {
        }

        public void setContentLength(int i) {
        }

        public void setContentType(String s) {
        }

        public void flushBuffer() throws IOException {
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setLocale(Locale locale) {
        }

        public void setCharacterEncoding(String s) {
        }
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        private final String url;

        protected RequestWrapper(HttpServletRequest httpServletRequest, String url) {
            super(httpServletRequest);
            this.url = url;
        }

        public String getParameter(String paramName) {
            if ("url".equals(paramName)) {
                return this.url;
            }
            return super.getParameter(paramName);
        }
    }
}

