/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.UrlValidationStatus;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.OAuthUriManager;
import org.apache.shindig.gadgets.uri.UriStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlueUrlGenerator
implements UrlGenerator {
    private final IframeUriManager iframeManager;
    private final JsUriManager jsManager;
    private final OAuthUriManager oauthManager;

    @Inject
    public GlueUrlGenerator(IframeUriManager iframeManager, JsUriManager jsManager, OAuthUriManager oauthManager) {
        this.iframeManager = iframeManager;
        this.jsManager = jsManager;
        this.oauthManager = oauthManager;
    }

    @Override
    public String getIframeUrl(Gadget gadget) {
        Uri iframeUri = this.iframeManager.makeRenderingUri(gadget);
        return iframeUri.toString();
    }

    @Override
    public UrlValidationStatus validateIframeUrl(String url) {
        Uri iframeUri = Uri.parse((String)url);
        UriStatus uriStatus = this.iframeManager.validateRenderingUri(iframeUri);
        return this.translateStatus(uriStatus);
    }

    @Override
    public String getBundledJsUrl(Collection<String> features, GadgetContext context) {
        Gadget gadget = new Gadget().setContext(context);
        Uri jsUri = this.jsManager.makeExternJsUri(gadget, features);
        return jsUri.toString();
    }

    @Override
    public UrlValidationStatus validateJsUrl(String url) {
        Uri jsUri = Uri.parse((String)url);
        JsUriManager.JsUri uriStatus = this.jsManager.processExternJsUri(jsUri);
        return this.translateStatus(uriStatus.getStatus());
    }

    @Override
    public String getGadgetDomainOAuthCallback(String container, String gadgetHost) {
        Uri oauthUri = this.oauthManager.makeOAuthCallbackUri(container, gadgetHost);
        return oauthUri.toString();
    }

    private UrlValidationStatus translateStatus(UriStatus uriStatus) {
        switch (uriStatus) {
            case VALID_UNVERSIONED: {
                return UrlValidationStatus.VALID_UNVERSIONED;
            }
            case VALID_VERSIONED: {
                return UrlValidationStatus.VALID_VERSIONED;
            }
        }
        return UrlValidationStatus.INVALID;
    }
}

