/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.rewriter.Generator;
import org.apache.sling.rewriter.GeneratorFactory;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Processor;
import org.apache.sling.rewriter.ProcessorConfiguration;
import org.apache.sling.rewriter.ProcessorFactory;
import org.apache.sling.rewriter.Serializer;
import org.apache.sling.rewriter.SerializerFactory;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.apache.sling.rewriter.impl.ProcessorConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryCache {
    private static final String PROPERTY_TYPE = "pipeline.type";
    private static final String PROPERTY_MODE = "pipeline.mode";
    private static final String MODE_GLOBAL = "global";
    private static final String PROPERTY_PATHS = "pipeline.paths";
    private static final String PROPERTY_EXTENSIONS = "pipeline.extensions";
    private static final String PROPERTY_CONTENT_TYPES = "pipeline.contentTypes";
    private static final String PROPERTY_RESOURCE_TYPES = "pipeline.resourceTypes";
    private static final Logger LOGGER = LoggerFactory.getLogger(FactoryCache.class);
    private final HashingServiceTrackerCustomizer<GeneratorFactory> generatorTracker;
    private final HashingServiceTrackerCustomizer<SerializerFactory> serializerTracker;
    private final TransformerFactoryServiceTracker<TransformerFactory> transformerTracker;
    private final HashingServiceTrackerCustomizer<ProcessorFactory> processorTracker;
    private static final Transformer[] EMPTY_ARRAY = new Transformer[0];
    private static final Transformer[][] EMPTY_DOUBLE_ARRAY = new Transformer[][]{EMPTY_ARRAY, EMPTY_ARRAY};

    public FactoryCache(BundleContext context) throws InvalidSyntaxException {
        this.generatorTracker = new HashingServiceTrackerCustomizer(context, GeneratorFactory.class.getName());
        this.serializerTracker = new HashingServiceTrackerCustomizer(context, SerializerFactory.class.getName());
        this.transformerTracker = new TransformerFactoryServiceTracker(context, TransformerFactory.class.getName());
        this.processorTracker = new HashingServiceTrackerCustomizer(context, ProcessorFactory.class.getName());
    }

    public void start() {
        this.generatorTracker.open();
        this.serializerTracker.open();
        this.transformerTracker.open();
        this.processorTracker.open();
    }

    public void stop() {
        this.generatorTracker.close();
        this.serializerTracker.close();
        this.transformerTracker.close();
        this.processorTracker.close();
    }

    public Generator getGenerator(String type) {
        GeneratorFactory factory = this.generatorTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested generator factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createGenerator();
    }

    public Serializer getSerializer(String type) {
        SerializerFactory factory = this.serializerTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested serializer factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createSerializer();
    }

    public Transformer getTransformer(String type) {
        TransformerFactory factory = (TransformerFactory)this.transformerTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested transformer factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createTransformer();
    }

    public Processor getProcessor(String type) {
        ProcessorFactory factory = this.processorTracker.getFactory(type);
        if (factory == null) {
            LOGGER.debug("Requested processor factory for type '{}' not found.", (Object)type);
            return null;
        }
        return factory.createProcessor();
    }

    public Transformer[][] getGlobalTransformers(ProcessingContext context) {
        TransformerFactory[][] factories = this.transformerTracker.getGlobalTransformerFactories(context);
        return this.createTransformers(factories);
    }

    private Transformer[][] createTransformers(TransformerFactory[][] factories) {
        if (factories == EMPTY_DOUBLE_ARRAY) {
            return EMPTY_DOUBLE_ARRAY;
        }
        Transformer[][] transformers = new Transformer[2][];
        for (int arrayIndex = 0; arrayIndex < 2; ++arrayIndex) {
            int count = factories[arrayIndex].length;
            for (TransformerFactory factory : factories[arrayIndex]) {
                if (factory != null) continue;
                --count;
            }
            if (count == 0) {
                transformers[arrayIndex] = EMPTY_ARRAY;
                continue;
            }
            transformers[arrayIndex] = new Transformer[count];
            for (int i = 0; i < factories[arrayIndex].length; ++i) {
                TransformerFactory factory = factories[arrayIndex][i];
                if (factory == null) continue;
                transformers[arrayIndex][i] = factory.createTransformer();
            }
        }
        return transformers;
    }

    private static final class TransformerFactoryEntry {
        public final TransformerFactory factory;
        private final ProcessorConfiguration configuration;

        public TransformerFactoryEntry(TransformerFactory factory, ServiceReference ref) {
            this.factory = factory;
            String[] paths = OsgiUtil.toStringArray((Object)ref.getProperty(FactoryCache.PROPERTY_PATHS), null);
            String[] extensions = OsgiUtil.toStringArray((Object)ref.getProperty(FactoryCache.PROPERTY_EXTENSIONS), null);
            String[] contentTypes = OsgiUtil.toStringArray((Object)ref.getProperty(FactoryCache.PROPERTY_CONTENT_TYPES), null);
            String[] resourceTypes = OsgiUtil.toStringArray((Object)ref.getProperty(FactoryCache.PROPERTY_RESOURCE_TYPES), null);
            boolean noCheckRequired = !(paths != null && paths.length != 0 || extensions != null && extensions.length != 0 || contentTypes != null && contentTypes.length != 0 || resourceTypes != null && resourceTypes.length != 0);
            this.configuration = !noCheckRequired ? new ProcessorConfigurationImpl(contentTypes, paths, extensions, resourceTypes) : null;
        }

        public boolean match(ProcessingContext context) {
            if (this.configuration == null) {
                return true;
            }
            return this.configuration.match(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ServiceReferenceComparator
    implements Comparator<ServiceReference> {
        public static ServiceReferenceComparator INSTANCE = new ServiceReferenceComparator();

        private ServiceReferenceComparator() {
        }

        @Override
        public int compare(ServiceReference o1, ServiceReference o2) {
            return o1.compareTo((Object)o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TransformerFactoryServiceTracker<T>
    extends HashingServiceTrackerCustomizer<T> {
        public static final TransformerFactoryEntry[] EMPTY_ENTRY_ARRAY = new TransformerFactoryEntry[0];
        public static final TransformerFactoryEntry[][] EMPTY_DOUBLE_ENTRY_ARRAY = new TransformerFactoryEntry[][]{EMPTY_ENTRY_ARRAY, EMPTY_ENTRY_ARRAY};
        public static final TransformerFactory[] EMPTY_FACTORY_ARRAY = new TransformerFactory[0];
        public static final TransformerFactory[][] EMPTY_DOUBLE_FACTORY_ARRAY = new TransformerFactory[][]{EMPTY_FACTORY_ARRAY, EMPTY_FACTORY_ARRAY};
        private TransformerFactoryEntry[][] cached = EMPTY_DOUBLE_ENTRY_ARRAY;
        private boolean cacheIsValid = true;

        private String getMode(ServiceReference ref) {
            String mode = (String)ref.getProperty(FactoryCache.PROPERTY_MODE);
            return mode;
        }

        private boolean isGlobal(ServiceReference ref) {
            return FactoryCache.MODE_GLOBAL.equalsIgnoreCase(this.getMode(ref));
        }

        public TransformerFactoryServiceTracker(BundleContext bc, String serviceClassName) {
            super(bc, serviceClassName);
        }

        @Override
        public Object addingService(ServiceReference reference) {
            Object obj;
            boolean isGlobal = this.isGlobal(reference);
            if (isGlobal) {
                this.cacheIsValid = false;
            }
            if ((obj = super.addingService(reference)) == null && isGlobal) {
                obj = this.context.getService(reference);
            }
            return obj;
        }

        @Override
        public void removedService(ServiceReference reference, Object service) {
            if (this.isGlobal(reference)) {
                this.cacheIsValid = false;
            }
            super.removedService(reference, service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransformerFactoryEntry[][] getGlobalTransformerFactoryEntries() {
            if (!this.cacheIsValid) {
                TransformerFactoryServiceTracker transformerFactoryServiceTracker = this;
                synchronized (transformerFactoryServiceTracker) {
                    if (!this.cacheIsValid) {
                        ServiceReference[] refs = this.getServiceReferences();
                        if (refs == null || refs.length == 0) {
                            this.cached = EMPTY_DOUBLE_ENTRY_ARRAY;
                        } else {
                            Arrays.sort(refs, ServiceReferenceComparator.INSTANCE);
                            int preCount = 0;
                            int postCount = 0;
                            for (ServiceReference ref : refs) {
                                int ranking;
                                if (!this.isGlobal(ref)) continue;
                                Object r = ref.getProperty("service.ranking");
                                int n = ranking = r instanceof Integer ? (Integer)r : 0;
                                if (ranking < 0) {
                                    ++preCount;
                                    continue;
                                }
                                ++postCount;
                            }
                            TransformerFactoryEntry[][] globalFactories = new TransformerFactoryEntry[][]{preCount == 0 ? EMPTY_ENTRY_ARRAY : new TransformerFactoryEntry[preCount], postCount == 0 ? EMPTY_ENTRY_ARRAY : new TransformerFactoryEntry[postCount]};
                            int index = 0;
                            for (ServiceReference ref : refs) {
                                if (!this.isGlobal(ref)) continue;
                                if (index < preCount) {
                                    globalFactories[0][index] = new TransformerFactoryEntry((TransformerFactory)this.getService(ref), ref);
                                } else {
                                    globalFactories[1][index - preCount] = new TransformerFactoryEntry((TransformerFactory)this.getService(ref), ref);
                                }
                                ++index;
                            }
                            this.cached = globalFactories;
                        }
                    }
                    this.cacheIsValid = true;
                }
            }
            return this.cached;
        }

        public TransformerFactory[][] getGlobalTransformerFactories(ProcessingContext context) {
            TransformerFactoryEntry[][] globalFactoryEntries = this.getGlobalTransformerFactoryEntries();
            if (globalFactoryEntries == EMPTY_DOUBLE_ENTRY_ARRAY) {
                return EMPTY_DOUBLE_FACTORY_ARRAY;
            }
            TransformerFactory[][] factories = new TransformerFactory[2][];
            for (int i = 0; i < 2; ++i) {
                if (globalFactoryEntries[i] == EMPTY_ENTRY_ARRAY) {
                    factories[i] = EMPTY_FACTORY_ARRAY;
                    continue;
                }
                factories[i] = new TransformerFactory[globalFactoryEntries[i].length];
                for (int m = 0; m < globalFactoryEntries[i].length; ++m) {
                    TransformerFactoryEntry entry = globalFactoryEntries[i][m];
                    if (!entry.match(context)) continue;
                    factories[i][m] = entry.factory;
                }
            }
            return factories;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashingServiceTrackerCustomizer<T>
    extends ServiceTracker {
        private final Map<String, T> services = new ConcurrentHashMap<String, T>();
        protected final BundleContext context;

        public HashingServiceTrackerCustomizer(BundleContext bc, String serviceClassName) {
            super(bc, serviceClassName, null);
            this.context = bc;
        }

        public T getFactory(String type) {
            return this.services.get(type);
        }

        private String getType(ServiceReference ref) {
            String type = (String)ref.getProperty(FactoryCache.PROPERTY_TYPE);
            return type;
        }

        public Object addingService(ServiceReference reference) {
            Object factory;
            String type = this.getType(reference);
            Object object = factory = type == null ? null : this.context.getService(reference);
            if (factory != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found service {}, type={}.", factory, (Object)type);
                }
                this.services.put(type, factory);
            }
            return factory;
        }

        public void removedService(ServiceReference reference, Object service) {
            String type = this.getType(reference);
            if (type != null) {
                this.services.remove(type);
                this.context.ungetService(reference);
            }
        }
    }
}

