/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.rewriter.PipelineConfiguration;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.impl.ProcessingComponentConfigurationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorConfigurationImpl
implements PipelineConfiguration {
    private static final String PROPERTY_ORDER = "order";
    private static final String PROPERTY_PATHS = "paths";
    private static final String PROPERTY_EXTENSIONS = "extensions";
    private static final String PROPERTY_PROCESSOR_TYPE = "processorType";
    private static final String PROPERTY_CONTENT_TYPES = "contentTypes";
    private static final String PROPERTY_RESOURCE_TYPES = "resourceTypes";
    private static final String PROPERTY_TRANFORMERS = "transformerTypes";
    private static final String PROPERTY_GENERATOR = "generatorType";
    private static final String PROPERTY_SERIALIZER = "serializerType";
    private static final String PROPERTY_ACTIVE = "enabled";
    private static final String PROPERTY_PROCESS_ERROR = "processError";
    private final String[] contentTypes;
    private final String[] paths;
    private final String[] extensions;
    private final String[] resourceTypes;
    private final int order;
    private final ProcessingComponentConfiguration generatorConfiguration;
    private final ProcessingComponentConfiguration[] transformerConfigurations;
    private final ProcessingComponentConfiguration serializerConfiguration;
    private final ProcessingComponentConfiguration processorConfig;
    private final boolean isActive;
    private final boolean isValid;
    private final boolean isPipeline;
    private final boolean processErrorResponse;
    private final String descString;

    public ProcessorConfigurationImpl(String[] contentTypes, String[] paths, String[] extensions, String[] resourceTypes, int order, ProcessingComponentConfiguration generatorConfig, ProcessingComponentConfiguration[] transformerConfigs, ProcessingComponentConfiguration serializerConfig, boolean processErrorResponse) {
        this.contentTypes = contentTypes;
        this.resourceTypes = resourceTypes;
        this.paths = paths;
        this.extensions = extensions;
        this.order = order;
        this.generatorConfiguration = generatorConfig;
        this.transformerConfigurations = transformerConfigs;
        this.serializerConfiguration = serializerConfig;
        this.processorConfig = null;
        this.isActive = true;
        this.isValid = true;
        this.isPipeline = true;
        this.processErrorResponse = processErrorResponse;
        this.descString = this.buildDescString();
    }

    public ProcessorConfigurationImpl(String[] contentTypes, String[] paths, String[] extensions, String[] resourceTypes) {
        this(contentTypes, paths, extensions, resourceTypes, 0, null, null, null, false);
    }

    public ProcessorConfigurationImpl(Resource resource) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        this.contentTypes = (String[])properties.get(PROPERTY_CONTENT_TYPES, String[].class);
        this.resourceTypes = (String[])properties.get(PROPERTY_RESOURCE_TYPES, String[].class);
        this.paths = (String[])properties.get(PROPERTY_PATHS, String[].class);
        this.extensions = (String[])properties.get(PROPERTY_EXTENSIONS, String[].class);
        this.processorConfig = this.getComponentConfig(resource, PROPERTY_PROCESSOR_TYPE, "processor");
        this.generatorConfiguration = this.getComponentConfig(resource, PROPERTY_GENERATOR, "generator");
        this.transformerConfigurations = this.getComponentConfigs(resource, PROPERTY_TRANFORMERS, "transformer");
        this.serializerConfiguration = this.getComponentConfig(resource, PROPERTY_SERIALIZER, "serializer");
        this.order = (Integer)properties.get(PROPERTY_ORDER, (Object)0);
        this.isActive = (Boolean)properties.get(PROPERTY_ACTIVE, (Object)true);
        this.processErrorResponse = (Boolean)properties.get(PROPERTY_PROCESS_ERROR, (Object)true);
        boolean bl = this.isPipeline = this.processorConfig == null;
        this.isValid = this.isPipeline ? (this.generatorConfiguration == null || this.generatorConfiguration.getType() == null || this.generatorConfiguration.getType().length() == 0 ? false : this.serializerConfiguration != null && this.generatorConfiguration.getType() != null && this.generatorConfiguration.getType().length() != 0) : this.processorConfig != null;
        this.descString = this.buildDescString();
    }

    void printConfiguration(PrintWriter pw) {
        if (this.contentTypes != null) {
            pw.print("Content Types : ");
            pw.println(Arrays.toString(this.contentTypes));
        }
        if (this.resourceTypes != null) {
            pw.print("Resource Types : ");
            pw.println(Arrays.toString(this.resourceTypes));
        }
        if (this.paths != null) {
            pw.print("Paths : ");
            pw.println(Arrays.toString(this.paths));
        }
        if (this.extensions != null) {
            pw.print("Extensions : ");
            pw.println(Arrays.toString(this.extensions));
        }
        pw.print("Order : ");
        pw.println(this.order);
        pw.print("Active : ");
        pw.println(this.isActive);
        pw.print("Valid : ");
        pw.println(this.isValid);
        pw.print("Process Error Response : ");
        pw.println(this.processErrorResponse);
        if (this.isPipeline) {
            pw.println("Pipeline : ");
            pw.println("    Generator : ");
            pw.print("        ");
            this.printConfiguration(pw, this.generatorConfiguration);
            pw.println("    Transformers : ");
            for (int i = 0; i < this.transformerConfigurations.length; ++i) {
                pw.print("        ");
                this.printConfiguration(pw, this.transformerConfigurations[i]);
            }
            pw.println("    Serializer : ");
            pw.print("        ");
            this.printConfiguration(pw, this.serializerConfiguration);
        } else {
            pw.print("Configuration : ");
            this.printConfiguration(pw, this.processorConfig);
        }
    }

    private void printConfiguration(PrintWriter pw, ProcessingComponentConfiguration config) {
        if (config instanceof ProcessingComponentConfigurationImpl) {
            ((ProcessingComponentConfigurationImpl)config).printConfiguration(pw);
        } else {
            pw.println(config);
        }
    }

    private String buildDescString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProcessorConfiguration: {");
        if (this.contentTypes != null) {
            sb.append("contentTypes=");
            sb.append(Arrays.toString(this.contentTypes));
            sb.append(',');
        }
        if (this.resourceTypes != null) {
            sb.append("resourceTypes=");
            sb.append(Arrays.toString(this.resourceTypes));
            sb.append(", ");
        }
        if (this.paths != null) {
            sb.append("paths=");
            sb.append(Arrays.toString(this.paths));
            sb.append(", ");
        }
        if (this.extensions != null) {
            sb.append("extensions=");
            sb.append(Arrays.toString(this.extensions));
            sb.append(", ");
        }
        sb.append("order=");
        sb.append(this.order);
        sb.append(", active=");
        sb.append(this.isActive);
        sb.append(", valid=");
        sb.append(this.isValid);
        sb.append(", processErrorResponse=");
        sb.append(this.processErrorResponse);
        if (this.isPipeline) {
            sb.append(", pipeline=(generator=");
            sb.append(this.generatorConfiguration);
            sb.append(", transformers=(");
            if (this.transformerConfigurations != null) {
                for (int i = 0; i < this.transformerConfigurations.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.transformerConfigurations[i]);
                }
            }
            sb.append(", serializer=");
            sb.append(this.serializerConfiguration);
            sb.append(')');
        } else {
            sb.append(", config=");
            sb.append(this.processorConfig);
        }
        sb.append("}");
        return sb.toString();
    }

    protected ProcessingComponentConfiguration getComponentConfig(Resource configResource, String propertyName, String prefix) {
        ProcessingComponentConfiguration[] configs = this.getComponentConfigs(configResource, propertyName, prefix);
        if (configs != null && configs.length > 0) {
            return configs[0];
        }
        return null;
    }

    protected ProcessingComponentConfiguration[] getComponentConfigs(Resource configResource, String propertyName, String prefix) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)configResource);
        String[] types = (String[])properties.get(propertyName, String[].class);
        if (types != null && types.length > 0) {
            ProcessingComponentConfiguration[] configs = new ProcessingComponentConfiguration[types.length];
            for (int i = 0; i < types.length; ++i) {
                ValueMap childProps;
                String resourceName = prefix + '-' + types[i];
                Resource childResource = configResource.getResourceResolver().getResource(configResource, resourceName);
                if (childResource == null) {
                    String secondResourceName = prefix + '-' + (i + 1);
                    childResource = configResource.getResourceResolver().getResource(configResource, secondResourceName);
                }
                ValueMap config = childResource != null ? (childProps = ResourceUtil.getValueMap((Resource)childResource)) : null;
                configs[i] = new ProcessingComponentConfigurationImpl(types[i], config);
            }
            return configs;
        }
        return null;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean match(ProcessingContext processContext) {
        int index;
        boolean found;
        if (!this.processErrorResponse && processContext.getRequest().getAttribute("javax.servlet.error.status_code") != null) {
            return false;
        }
        String contentType = processContext.getContentType();
        if (contentType == null) {
            contentType = "text/html";
        } else {
            int idx = contentType.indexOf(59);
            if (idx != -1) {
                contentType = contentType.substring(0, idx);
            }
        }
        if (this.contentTypes != null && this.contentTypes.length > 0) {
            found = false;
            for (int index2 = 0; !found && index2 < this.contentTypes.length; ++index2) {
                if (this.contentTypes[index2].equals("*")) {
                    found = true;
                    continue;
                }
                if (!this.contentTypes[index2].equals(contentType)) continue;
                found = true;
            }
            if (!found) {
                return false;
            }
        }
        if (this.extensions != null && this.extensions.length > 0) {
            boolean found2 = false;
            for (index = 0; !found2 && index < this.extensions.length; ++index) {
                if (!this.extensions[index].equals(processContext.getRequest().getRequestPathInfo().getExtension())) continue;
                found2 = true;
            }
            if (!found2) {
                return false;
            }
        }
        if (this.resourceTypes != null && this.resourceTypes.length > 0) {
            Resource resource = processContext.getRequest().getResource();
            found = false;
            for (int index3 = 0; !found && index3 < this.resourceTypes.length; ++index3) {
                if (!ResourceUtil.isA((Resource)resource, (String)this.resourceTypes[index3])) continue;
                found = true;
            }
            if (!found) {
                return false;
            }
        }
        if (this.paths != null && this.paths.length > 0) {
            String path = processContext.getRequest().getRequestPathInfo().getResourcePath();
            boolean found3 = false;
            for (index = 0; !found3 && index < this.paths.length; ++index) {
                if (this.paths[index].equals("*")) {
                    found3 = true;
                    continue;
                }
                if (!path.startsWith(this.paths[index])) continue;
                found3 = true;
            }
            if (!found3) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ProcessingComponentConfiguration getGeneratorConfiguration() {
        return this.generatorConfiguration;
    }

    @Override
    public ProcessingComponentConfiguration getSerializerConfiguration() {
        return this.serializerConfiguration;
    }

    @Override
    public ProcessingComponentConfiguration[] getTransformerConfigurations() {
        return this.transformerConfigurations;
    }

    public boolean isPipeline() {
        return this.isPipeline;
    }

    public boolean isActive() {
        return this.isValid & this.isActive;
    }

    @Override
    public Map<String, Object> getConfiguration() {
        if (this.isPipeline) {
            return ProcessingComponentConfigurationImpl.EMPTY_CONFIG;
        }
        return this.processorConfig.getConfiguration();
    }

    @Override
    public String getType() {
        if (this.isPipeline) {
            return "{pipeline}";
        }
        return this.processorConfig.getType();
    }

    public String toString() {
        return this.descString;
    }
}

