/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.rewriter.Processor;
import org.apache.sling.rewriter.ProcessorConfiguration;
import org.apache.sling.rewriter.ProcessorManager;
import org.apache.sling.rewriter.impl.ServletProcessingContext;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Adaptable(adaptableClass=SlingHttpServletResponse.class, adapters={@Adapter(value={ContentHandler.class}, condition="When the response is being processed through the Sling Rewriter filter.")})
class RewriterResponse
extends SlingHttpServletResponseWrapper {
    private final SlingHttpServletRequest request;
    private Processor processor;
    private PrintWriter writer;
    private String contentType;
    private final ProcessorManager processorManager;

    public RewriterResponse(SlingHttpServletRequest request, SlingHttpServletResponse delegatee, ProcessorManager processorManager) {
        super(delegatee);
        this.processorManager = processorManager;
        this.request = request;
    }

    public void setContentType(String type) {
        this.contentType = type;
        super.setContentType(type);
    }

    public PrintWriter getWriter() throws IOException {
        if (this.processor != null && this.writer == null) {
            return new PrintWriter(new Writer(){

                public void close() throws IOException {
                }

                public void flush() throws IOException {
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                }
            });
        }
        if (this.writer == null) {
            this.processor = this.getProcessor();
            if (this.processor != null) {
                this.writer = this.processor.getWriter();
            }
            if (this.writer == null) {
                this.writer = super.getWriter();
            }
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else {
            super.flushBuffer();
        }
    }

    public void finished(boolean errorOccured) throws IOException {
        if (this.processor != null) {
            this.processor.finished(errorOccured);
            this.processor = null;
        }
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ContentHandler.class) {
            this.processor = this.getProcessor();
            if (this.processor != null) {
                ContentHandler object = this.processor.getContentHandler();
                return (AdapterType)object;
            }
        }
        return (AdapterType)super.adaptTo(type);
    }

    private Processor getProcessor() {
        ServletProcessingContext processorContext = new ServletProcessingContext(this.request, (SlingHttpServletResponse)this, this.getSlingResponse(), this.contentType);
        Processor found = null;
        List<ProcessorConfiguration> processorConfigs = this.processorManager.getProcessorConfigurations();
        Iterator<ProcessorConfiguration> i = processorConfigs.iterator();
        while (found == null && i.hasNext()) {
            ProcessorConfiguration config = i.next();
            if (!config.match(processorContext)) continue;
            try {
                found = this.processorManager.getProcessor(config, processorContext);
                this.request.getRequestProgressTracker().log("Found processor for post processing {0}", new Object[]{config});
            }
            catch (SlingException se) {
                if (processorContext.getRequest().getAttribute("javax.servlet.error.status_code") != null) {
                    this.request.getRequestProgressTracker().log("Ignoring found processor for post processing {0} as an error occured ({1}) during setup while processing another error.", new Object[]{config, se});
                    continue;
                }
                throw se;
            }
        }
        return found;
    }
}

