/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl.components;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.sling.commons.html.HtmlParser;
import org.apache.sling.rewriter.Generator;
import org.apache.sling.rewriter.GeneratorFactory;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HtmlGeneratorFactory
implements GeneratorFactory {
    private HtmlParser htmlParser;

    public Generator createGenerator() {
        return new HtmlGenerator(this.htmlParser);
    }

    protected void bindHtmlParser(HtmlParser htmlParser) {
        this.htmlParser = htmlParser;
    }

    protected void unbindHtmlParser(HtmlParser htmlParser) {
        if (this.htmlParser == htmlParser) {
            this.htmlParser = null;
        }
    }

    public static final class HtmlGenerator
    implements Generator {
        private final StringWriter writer;
        private final HtmlParser htmlParser;
        private ContentHandler contentHandler;

        public HtmlGenerator(HtmlParser parser) {
            this.htmlParser = parser;
            this.writer = new StringWriter();
        }

        public void finished() throws IOException, SAXException {
            this.htmlParser.parse((InputStream)new ByteArrayInputStream(this.writer.toString().getBytes("UTF-8")), "UTF-8", this.contentHandler);
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.writer);
        }

        public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        }

        public void setContentHandler(ContentHandler handler) {
            this.contentHandler = handler;
        }

        public void dispose() {
        }
    }
}

