/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl.components;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Serializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TraxSerializer
implements Serializer,
LexicalHandler {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private final Properties format = new Properties();
    private final TransformerHandler transformerHandler;
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;

    public TraxSerializer(TransformerHandler transformerHandler, ContentHandler handler, String outputFormat, String doctypePublic, String doctypeSystem) {
        this.contentHandler = handler;
        this.lexicalHandler = (LexicalHandler)((Object)handler);
        this.transformerHandler = transformerHandler;
        this.format.put("method", outputFormat);
        this.format.put("doctype-public", doctypePublic);
        this.format.put("doctype-system", doctypeSystem);
    }

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        if (this.transformerHandler == null) {
            throw new IOException("Transformer handler could not be instantiated.");
        }
        if (context.getResponse().getCharacterEncoding() != null) {
            this.format.put("encoding", context.getResponse().getCharacterEncoding());
        } else {
            this.format.put("encoding", DEFAULT_ENCODING);
        }
        String cdataSectionElements = (String)config.getConfiguration().get("cdata-section-elements", String.class);
        String dtPublic = (String)config.getConfiguration().get("doctype-public", String.class);
        String dtSystem = (String)config.getConfiguration().get("doctype-system", String.class);
        String encoding = (String)config.getConfiguration().get("encoding", String.class);
        String indent = (String)config.getConfiguration().get("indent", String.class);
        String mediaType = (String)config.getConfiguration().get("media-type", String.class);
        String method = (String)config.getConfiguration().get("method", String.class);
        String omitXMLDeclaration = (String)config.getConfiguration().get("omit-xml-declaration", String.class);
        String standAlone = (String)config.getConfiguration().get("standalone", String.class);
        String version = (String)config.getConfiguration().get("version", String.class);
        if (cdataSectionElements != null) {
            this.format.put("cdata-section-elements", cdataSectionElements);
        }
        if (dtPublic != null) {
            this.format.put("doctype-public", dtPublic);
        }
        if (dtSystem != null) {
            this.format.put("doctype-system", dtSystem);
        }
        if (encoding != null) {
            this.format.put("encoding", encoding);
        }
        if (indent != null) {
            this.format.put("indent", indent);
        }
        if (mediaType != null) {
            this.format.put("media-type", mediaType);
        }
        if (method != null) {
            this.format.put("method", method);
        }
        if (omitXMLDeclaration != null) {
            this.format.put("omit-xml-declaration", omitXMLDeclaration);
        }
        if (standAlone != null) {
            this.format.put("standalone", standAlone);
        }
        if (version != null) {
            this.format.put("version", version);
        }
        this.setOutputStream(context.getOutputStream());
    }

    private void setOutputStream(OutputStream out) throws IOException {
        try {
            this.transformerHandler.getTransformer().setOutputProperties(this.format);
            this.transformerHandler.setResult(new StreamResult(out));
        }
        catch (Exception e) {
            String message = "Cannot set XMLSerializer outputstream";
            throw (IOException)new IOException("Cannot set XMLSerializer outputstream").initCause(e);
        }
    }

    public void dispose() {
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.contentHandler.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.contentHandler.endElement(uri, loc, raw);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.contentHandler.characters(c, start, len);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.contentHandler.ignorableWhitespace(c, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.lexicalHandler.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.lexicalHandler.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.lexicalHandler.comment(ch, start, len);
    }
}

