/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.request;

import java.util.Arrays;
import org.apache.sshd.sftp.Handle;
import org.apache.sshd.sftp.request.BaseRequest;
import org.apache.sshd.sftp.subsystem.SftpConstants;

public class SshFxpWriteRequest
extends BaseRequest {
    private final String handleId;
    private final long offset;
    private final Handle handle;
    private final byte[] data;

    public SshFxpWriteRequest(int id, String handleId, long offset, byte[] data, Handle handle) {
        super(id);
        this.handleId = handleId;
        this.offset = offset;
        this.data = Arrays.copyOf(data, data.length);
        this.handle = handle;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public SftpConstants.Type getMessage() {
        return SftpConstants.Type.SSH_FXP_WRITE;
    }

    public String toString() {
        String ps = this.handle != null && this.handle.getFile() != null ? this.handle.getFile().getAbsolutePath() : "";
        return this.getName() + "[handle=" + this.handleId + ", file=" + ps + ", offset=" + this.offset + ", length=" + this.data.length + "]";
    }

    public Handle getHandle() {
        return this.handle;
    }

    public String getHandleId() {
        return this.handleId;
    }

    public long getOffset() {
        return this.offset;
    }
}

