/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.openstack.nova.v2_0.domain.SecurityGroupRule;

@Singleton
public class NovaSecurityGroupToSecurityGroup
implements Function<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup, SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected Function<SecurityGroupRule, IpPermission> ruleToPermission;

    @Inject
    public NovaSecurityGroupToSecurityGroup(Function<SecurityGroupRule, IpPermission> ruleToPermission) {
        this.ruleToPermission = ruleToPermission;
    }

    public SecurityGroup apply(org.jclouds.openstack.nova.v2_0.domain.SecurityGroup group) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        builder.id(group.getId());
        builder.providerId(group.getId());
        builder.ownerId(group.getTenantId());
        builder.name(group.getName());
        if (group.getRules() != null) {
            builder.ipPermissions(Iterables.transform(group.getRules(), this.ruleToPermission));
        }
        return builder.build();
    }
}

