/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class ServerCreated
extends Resource {
    private final Optional<String> adminPass;
    private final Optional<String> diskConfig;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ServerCreated.builder().fromServerCreated(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "adminPass", "OS-DCF:diskConfig"})
    protected ServerCreated(String id, @Nullable String name, Set<Link> links, @Nullable String adminPass, @Nullable String diskConfig) {
        super(id, name, links);
        this.adminPass = Optional.fromNullable((Object)adminPass);
        this.diskConfig = Optional.fromNullable((Object)diskConfig);
    }

    public Optional<String> getAdminPass() {
        return this.adminPass;
    }

    public Optional<String> getDiskConfig() {
        return this.diskConfig;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.adminPass, this.diskConfig});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServerCreated that = (ServerCreated)((Object)ServerCreated.class.cast(obj));
        return super.equals((Object)that) && Objects.equal(this.adminPass, that.adminPass) && Objects.equal(this.diskConfig, that.diskConfig);
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("adminPass", this.adminPass.orNull()).add("diskConfig", this.diskConfig.orNull());
    }

    public static final class Builder
    extends Resource.Builder<Builder> {
        protected String adminPass;
        protected String diskConfig;

        public Builder adminPass(String adminPass) {
            this.adminPass = adminPass;
            return this.self();
        }

        public Builder diskConfig(String diskConfig) {
            this.diskConfig = diskConfig;
            return this.self();
        }

        public ServerCreated build() {
            return new ServerCreated(this.id, this.name, this.links, this.adminPass, this.diskConfig);
        }

        public Builder fromServerCreated(ServerCreated in) {
            return ((Builder)super.fromResource((Resource)in)).adminPass((String)in.getAdminPass().orNull()).diskConfig((String)in.getDiskConfig().orNull());
        }

        protected Builder self() {
            return this;
        }
    }
}

