/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.FloatingIP;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/floating_ips/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface FloatingIPAsyncApi {
    @Named(value="floatingip:list")
    @GET
    @Path(value="/os-floating-ips")
    @SelectJson(value={"floating_ips"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends FloatingIP>> list();

    @Named(value="floatingip:get")
    @GET
    @Path(value="/os-floating-ips/{id}")
    @SelectJson(value={"floating_ip"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends FloatingIP> get(@PathParam(value="id") String var1);

    @Named(value="floatingip:create")
    @POST
    @Path(value="/os-floating-ips")
    @SelectJson(value={"floating_ip"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Payload(value="{}")
    public ListenableFuture<? extends FloatingIP> create();

    @Named(value="floatingip:create")
    @POST
    @Path(value="/os-floating-ips")
    @SelectJson(value={"floating_ip"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Payload(value="%7B\"pool\":\"{pool}\"%7D")
    public ListenableFuture<? extends FloatingIP> allocateFromPool(@PayloadParam(value="pool") String var1);

    @Named(value="floatingip:delete")
    @DELETE
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/os-floating-ips/{id}")
    public ListenableFuture<Void> delete(@PathParam(value="id") String var1);

    @Named(value="floatingip:add")
    @POST
    @Path(value="/servers/{server}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"addFloatingIp\":%7B\"address\":\"{address}\"%7D%7D")
    public ListenableFuture<Void> addToServer(@PayloadParam(value="address") String var1, @PathParam(value="server") String var2);

    @Named(value="floatingip:remove")
    @POST
    @Path(value="/servers/{server}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"removeFloatingIp\":%7B\"address\":\"{address}\"%7D%7D")
    public ListenableFuture<Void> removeFromServer(@PayloadParam(value="address") String var1, @PathParam(value="server") String var2);
}

