/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.BackupType;
import org.jclouds.openstack.nova.v2_0.functions.ParseImageIdFromLocationHeader;
import org.jclouds.openstack.nova.v2_0.options.CreateBackupOfServerOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/admin-actions/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Path(value="/servers/{id}/action")
@Beta
public interface ServerAdminAsyncApi {
    @Named(value="serveradmin:suspend")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"suspend\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> suspend(@PathParam(value="id") String var1);

    @Named(value="serveradmin:resume")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"resume\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> resume(@PathParam(value="id") String var1);

    @Named(value="serveradmin:migrate")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"migrate\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> migrate(@PathParam(value="id") String var1);

    @Named(value="serveradmin:lock")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"lock\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> lock(@PathParam(value="id") String var1);

    @Named(value="serveradmin:unlock")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"unlock\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> unlock(@PathParam(value="id") String var1);

    @Named(value="serveradmin:resetnetwork")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"resetNetwork\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> resetNetwork(@PathParam(value="id") String var1);

    @Named(value="serveradmin:createbackup")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WrapWith(value="createBackup")
    @Fallback(value=MapHttp4xxCodesToExceptions.class)
    @ResponseParser(value=ParseImageIdFromLocationHeader.class)
    public ListenableFuture<String> createBackup(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2, @PayloadParam(value="backup_type") BackupType var3, @PayloadParam(value="rotation") int var4, CreateBackupOfServerOptions ... var5);

    @Named(value="serveradmin:pause")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"pause\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> pause(@PathParam(value="id") String var1);

    @Named(value="serveradmin:unpause")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"unpause\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> unpause(@PathParam(value="id") String var1);

    @Named(value="serveradmin:injectnetwork")
    @POST
    @Produces(value={"application/json"})
    @Payload(value="{\"injectNetworkInfo\":null}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> injectNetworkInfo(@PathParam(value="id") String var1);

    @Named(value="serveradmin:livemigrate")
    @POST
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @WrapWith(value="os-migrateLive")
    public ListenableFuture<Boolean> liveMigrate(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2, @PayloadParam(value="block_migration") boolean var3, @PayloadParam(value="disk_over_commit") boolean var4);
}

