/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.VolumeAttachment;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/volumes/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Beta
public interface VolumeAttachmentAsyncApi {
    @Named(value="volumeattachment:list")
    @GET
    @Path(value="/servers/{server_id}/os-volume_attachments")
    @SelectJson(value={"volumeAttachments"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends VolumeAttachment>> listAttachmentsOnServer(@PathParam(value="server_id") String var1);

    @Named(value="volumeattachment:get")
    @GET
    @Path(value="/servers/{server_id}/os-volume_attachments/{id}")
    @SelectJson(value={"volumeAttachment"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends VolumeAttachment> getAttachmentForVolumeOnServer(@PathParam(value="id") String var1, @PathParam(value="server_id") String var2);

    @Named(value="volumeattachment:attach")
    @POST
    @Path(value="/servers/{server_id}/os-volume_attachments")
    @SelectJson(value={"volumeAttachment"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @WrapWith(value="volumeAttachment")
    public ListenableFuture<? extends VolumeAttachment> attachVolumeToServerAsDevice(@PayloadParam(value="volumeId") String var1, @PathParam(value="server_id") String var2, @PayloadParam(value="device") String var3);

    @Named(value="volumeattachment:detach")
    @DELETE
    @Path(value="/servers/{server_id}/os-volume_attachments/{id}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> detachVolumeFromServer(@PathParam(value="id") String var1, @PathParam(value="server_id") String var2);
}

