/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.features;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.binders.BindMetadataToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.RebootType;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.functions.ParseImageIdFromLocationHeader;
import org.jclouds.openstack.nova.v2_0.functions.internal.OnlyMetadataValueOrNull;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseDiagnostics;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseServerDetails;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseServers;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.options.RebuildServerOptions;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Resource;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={AuthenticateRequest.class})
public interface ServerAsyncApi {
    @Named(value="server:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/servers")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseServers.class)
    @Transform(value=ParseServers.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Resource>> list();

    @Named(value="server:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/servers")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseServers.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Resource>> list(PaginationOptions var1);

    @Named(value="server:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/servers/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseServerDetails.class)
    @Transform(value=ParseServerDetails.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Server>> listInDetail();

    @Named(value="server:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/servers/detail")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseServerDetails.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Server>> listInDetail(PaginationOptions var1);

    @Named(value="server:get")
    @GET
    @SelectJson(value={"server"})
    @Consumes(value={"application/json"})
    @Path(value="/servers/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Server> get(@PathParam(value="id") String var1);

    @Named(value="server:delete")
    @DELETE
    @Consumes
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @Path(value="/servers/{id}")
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);

    @Named(value="server:start")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"os-start\":null}")
    public ListenableFuture<Void> start(@PathParam(value="id") String var1);

    @Named(value="server:stop")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"os-stop\":null}")
    public ListenableFuture<Void> stop(@PathParam(value="id") String var1);

    @Named(value="server:reboot")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"reboot\":%7B\"type\":\"{type}\"%7D%7D")
    public ListenableFuture<Void> reboot(@PathParam(value="id") String var1, @PayloadParam(value="type") RebootType var2);

    @Named(value="server:resize")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"resize\":%7B\"flavorRef\":{flavorId}%7D%7D")
    public ListenableFuture<Void> resize(@PathParam(value="id") String var1, @PayloadParam(value="flavorId") String var2);

    @Named(value="server:resize")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"confirmResize\":null}")
    public ListenableFuture<Void> confirmResize(@PathParam(value="id") String var1);

    @Named(value="server:resize")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"revertResize\":null}")
    public ListenableFuture<Void> revertResize(@PathParam(value="id") String var1);

    @Named(value="server:create")
    @POST
    @Unwrap
    @Consumes(value={"application/json"})
    @Path(value="/servers")
    @MapBinder(value=CreateServerOptions.class)
    public ListenableFuture<ServerCreated> create(@PayloadParam(value="name") String var1, @PayloadParam(value="imageRef") String var2, @PayloadParam(value="flavorRef") String var3, CreateServerOptions ... var4);

    @Named(value="server:rebuild")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @MapBinder(value=RebuildServerOptions.class)
    public ListenableFuture<Void> rebuild(@PathParam(value="id") String var1, RebuildServerOptions ... var2);

    @Named(value="server:changeadminpass")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"changePassword\":%7B\"adminPass\":\"{adminPass}\"%7D%7D")
    public ListenableFuture<Void> changeAdminPass(@PathParam(value="id") String var1, @PayloadParam(value="adminPass") String var2);

    @Named(value="server:rename")
    @PUT
    @Path(value="/servers/{id}")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"server\":%7B\"name\":\"{name}\"%7D%7D")
    public ListenableFuture<Void> rename(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2);

    @Named(value="server:create")
    @POST
    @Path(value="/servers/{id}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"createImage\":%7B\"name\":\"{name}\", \"metadata\": %7B%7D%7D%7D")
    @Fallback(value=MapHttp4xxCodesToExceptions.class)
    @ResponseParser(value=ParseImageIdFromLocationHeader.class)
    public ListenableFuture<String> createImageFromServer(@PayloadParam(value="name") String var1, @PathParam(value="id") String var2);

    @Named(value="server:getmetadata")
    @GET
    @SelectJson(value={"metadata"})
    @Path(value="/servers/{id}/metadata")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    public ListenableFuture<? extends Map<String, String>> getMetadata(@PathParam(value="id") String var1);

    @Named(value="server:setmetadata")
    @PUT
    @SelectJson(value={"metadata"})
    @Path(value="/servers/{id}/metadata")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<? extends Map<String, String>> setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="server:updatemetadata")
    @POST
    @SelectJson(value={"metadata"})
    @Path(value="/servers/{id}/metadata")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    @MapBinder(value=BindToJsonPayload.class)
    public ListenableFuture<? extends Map<String, String>> updateMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);

    @Named(value="server:getmetadata")
    @GET
    @Path(value="/servers/{id}/metadata/{key}")
    @Consumes(value={"application/json"})
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<String> getMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="server:updatemetadata")
    @PUT
    @Path(value="/servers/{id}/metadata/{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResponseParser(value=OnlyMetadataValueOrNull.class)
    @MapBinder(value=BindMetadataToJsonPayload.class)
    public ListenableFuture<String> updateMetadata(@PathParam(value="id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PathParam(value="value") @PayloadParam(value="value") String var3);

    @Named(value="server:deletemetadata")
    @DELETE
    @Consumes
    @Path(value="/servers/{id}/metadata/{key}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteMetadata(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="server:getdiagnostics")
    @GET
    @Path(value="/servers/{id}/diagnostics")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.AbsentOn403Or404Or500.class)
    @ResponseParser(value=ParseDiagnostics.class)
    public ListenableFuture<Optional<Map<String, String>>> getDiagnostics(@PathParam(value="id") String var1);
}

