/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.gxp;

import com.google.common.annotations.VisibleForTesting;
import com.google.gxp.base.GxpContext;
import com.google.gxp.base.MarkupClosure;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.struts2.views.gxp.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGxp<T extends MarkupClosure> {
    ValueStackFactory valueStackFactory;
    Map defaultValues = new HashMap();
    List<Param> params;
    Class gxpClass;
    Method writeMethod;
    Method getGxpClosureMethod;
    boolean hasBodyParam;

    protected AbstractGxp(Class gxpClass) {
        this(gxpClass, AbstractGxp.lookupMethodByName(gxpClass, "write"), AbstractGxp.lookupMethodByName(gxpClass, "getGxpClosure"));
    }

    protected AbstractGxp(Class gxpClass, Method writeMethod, Method getGxpClosureMethod) {
        this.gxpClass = gxpClass;
        this.writeMethod = writeMethod;
        this.getGxpClosureMethod = getGxpClosureMethod;
        this.params = this.lookupParams();
    }

    public void write(Appendable out, GxpContext gxpContext) {
        this.write(out, gxpContext, null);
    }

    protected void write(Appendable out, GxpContext gxpContext, Map overrides) {
        Object[] args = this.getArgs(out, gxpContext, overrides);
        try {
            this.writeMethod.invoke(this.getGxpInstance(), args);
        }
        catch (Exception e) {
            throw new RuntimeException(this.createDebugString(args, e), e);
        }
    }

    protected Object[] getArgs(Appendable out, GxpContext gxpContext, Map overrides) {
        List argList = this.getArgListFromValueStack(overrides);
        Object[] args = new Object[argList.size() + 2];
        args[0] = out;
        args[1] = gxpContext;
        int index = 2;
        Iterator i = argList.iterator();
        while (i.hasNext()) {
            args[index] = i.next();
            ++index;
        }
        return args;
    }

    protected Object getGxpInstance() {
        return null;
    }

    public T getGxpClosure() {
        return this.getGxpClosure(null, null);
    }

    protected T getGxpClosure(T body, Map params) {
        Map overrides = this.getOverrides(body, params);
        Object[] args = this.getArgListFromValueStack(overrides).toArray();
        try {
            return (T)((MarkupClosure)this.getGxpClosureMethod.invoke(this.getGxpInstance(), args));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(this.createDebugString(args, e), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.createDebugString(args, e), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(this.createDebugString(args, e), e);
        }
    }

    protected Map getOverrides(T body, Map params) {
        HashMap<String, T> overrides = new HashMap<String, T>();
        if (this.hasBodyParam && body != null) {
            overrides.put("body", body);
        }
        if (params != null) {
            overrides.putAll(params);
        }
        return overrides;
    }

    List getArgListFromValueStack(Map overrides) {
        ValueStack valueStack = this.valueStackFactory.createValueStack(ActionContext.getContext().getValueStack());
        valueStack.getRoot().add((Object)this.defaultValues);
        if (overrides != null && !overrides.isEmpty()) {
            valueStack.push((Object)overrides);
        }
        ArrayList<Object> args = new ArrayList<Object>(this.params.size());
        for (Param param : this.getParams()) {
            try {
                args.add(valueStack.findValue(param.getName(), param.getType()));
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while finding '" + param.getName() + "'.", e);
            }
        }
        return args;
    }

    List<Param> lookupParams() {
        ArrayList<Param> params = new ArrayList<Param>();
        List<String> parameterNames = this.lookupParameterNames();
        List<Class<?>> parameterTypes = this.lookupParameterTypes();
        Iterator<Class<?>> parameterTypeIterator = parameterTypes.iterator();
        if (parameterNames.size() > parameterTypes.size()) {
            parameterNames = parameterNames.subList(parameterNames.size() - parameterTypes.size(), parameterNames.size());
        }
        for (String name : parameterNames) {
            Class<?> paramType = parameterTypeIterator.next();
            Param param = new Param(this.gxpClass, name, paramType);
            params.add(param);
            if (param.isBody()) {
                this.hasBodyParam = true;
            }
            if (!param.isOptional()) continue;
            this.defaultValues.put(param.getName(), param.getDefaultValue());
        }
        this.defaultValues = Collections.unmodifiableMap(this.defaultValues);
        return Collections.unmodifiableList(params);
    }

    List<Class<?>> lookupParameterTypes() {
        List<Class<?>> parameterTypes = Arrays.asList(this.writeMethod.getParameterTypes());
        return parameterTypes.subList(2, parameterTypes.size());
    }

    List<String> lookupParameterNames() {
        try {
            return (List)this.gxpClass.getMethod("getArgList", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Method lookupMethodByName(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        throw new RuntimeException("No " + name + "(...) method found for " + clazz.getName() + ".");
    }

    public Class getGxpClass() {
        return this.gxpClass;
    }

    public List<Param> getParams() {
        return this.params;
    }

    @VisibleForTesting
    public static Class getGxpClassForPath(String gxpPath) {
        int offset = gxpPath.charAt(0) == '/' ? 1 : 0;
        String className = gxpPath.substring(offset, gxpPath.length() - 4).replace('/', '.');
        try {
            return AbstractGxp.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader == null ? ClassLoader.getSystemClassLoader() : loader;
    }

    String createDebugString(Object[] args, Exception exception) {
        StringBuffer buffer = new StringBuffer();
        this.printExceptionTraceToBuffer(exception, buffer);
        buffer.append("\nException in GXP: ").append(this.gxpClass.getName()).append(". Params:");
        int index = 2;
        for (Param param : this.getParams()) {
            try {
                Object arg = args[index++];
                String typesMatch = "n/a (null)";
                if (arg != null) {
                    typesMatch = this.doesArgumentTypeMatchParamType(param, arg) ? "YES" : "NO";
                }
                buffer.append("\n  ").append(param.toString()).append(" = ").append(arg).append("; ").append("[types match? ").append(typesMatch).append("]");
            }
            catch (Exception e) {
                buffer.append(" >Error getting information for param # ").append(index).append("< ");
            }
        }
        buffer.append("\nStack trace: ");
        return buffer.toString();
    }

    private void printExceptionTraceToBuffer(Exception e, StringBuffer buffer) {
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        buffer.append(out.getBuffer().toString());
    }

    private boolean doesArgumentTypeMatchParamType(Param param, Object arg) {
        Class paramType = param.getType();
        Class<?> argClass = arg.getClass();
        if (Boolean.TYPE.equals(paramType) && Boolean.class.equals(argClass)) {
            return true;
        }
        if (Character.TYPE.equals(paramType) && Character.class.equals(argClass)) {
            return true;
        }
        return paramType.isAssignableFrom(argClass);
    }

    @Inject
    public void setValueStackFactory(ValueStackFactory valueStackFactory) {
        this.valueStackFactory = valueStackFactory;
    }
}

