/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.gxp;

import com.google.gxp.html.HtmlClosure;
import java.lang.reflect.Method;

public class Param {
    public static final String BODY_PARAM_NAME = "body";
    String name;
    Class type;
    Class gxpClass;
    boolean optional;
    Object defaultValue;

    Param(Class gxpClass, String name, Class type) {
        this.gxpClass = gxpClass;
        this.name = name;
        this.type = type;
        try {
            Method defaultGetter = gxpClass.getMethod("getDefault" + Param.capitalize(name), new Class[0]);
            this.defaultValue = defaultGetter.invoke(null, new Object[0]);
            this.optional = true;
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String capitalize(String s) {
        char capitalized;
        if (s.isEmpty()) {
            return s;
        }
        char first = s.charAt(0);
        return first == (capitalized = Character.toUpperCase(first)) ? s : capitalized + s.substring(1);
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    boolean isBody() {
        return this.name.equals(BODY_PARAM_NAME) && this.type.equals(HtmlClosure.class);
    }

    public String toString() {
        return "Param[name: " + this.name + ", type: " + this.type.getName() + ", optional: " + this.optional + (this.optional ? ", defaultValue: " + this.defaultValue : "") + "]";
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object getDefaultValue() {
        if (!this.optional) {
            throw new RuntimeException("Parameter '" + this.name + "' in " + this.gxpClass.getName() + " is not optional.");
        }
        return this.defaultValue;
    }
}

