/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.rest.HttpHeaders;

public class DefaultHttpHeaders
implements HttpHeaders {
    String resultCode;
    int status = 200;
    Object etag;
    Object locationId;
    String location;
    boolean disableCaching;
    boolean noETag = false;
    Date lastModified;

    public DefaultHttpHeaders() {
    }

    public DefaultHttpHeaders(String result) {
        this.resultCode = result;
    }

    public DefaultHttpHeaders renderResult(String code) {
        this.resultCode = code;
        return this;
    }

    public DefaultHttpHeaders withStatus(int code) {
        this.status = code;
        return this;
    }

    public DefaultHttpHeaders withETag(Object etag) {
        this.etag = etag;
        return this;
    }

    public DefaultHttpHeaders withNoETag() {
        this.noETag = true;
        return this;
    }

    public DefaultHttpHeaders setLocationId(Object id) {
        this.locationId = id;
        return this;
    }

    public DefaultHttpHeaders setLocation(String loc) {
        this.location = loc;
        return this;
    }

    public DefaultHttpHeaders lastModified(Date date) {
        this.lastModified = date;
        return this;
    }

    public DefaultHttpHeaders disableCaching() {
        this.disableCaching = true;
        return this;
    }

    public String apply(HttpServletRequest request, HttpServletResponse response, Object target) {
        if (this.disableCaching) {
            response.setHeader("Cache-Control", "no-cache");
        }
        if (this.lastModified != null) {
            response.setDateHeader("Last-Modified", this.lastModified.getTime());
        }
        if (this.etag == null && !this.noETag && target != null) {
            this.etag = String.valueOf(target.hashCode());
        }
        if (this.etag != null) {
            response.setHeader("ETag", this.etag.toString());
        }
        if (this.locationId != null) {
            String url = request.getRequestURL().toString();
            int lastSlash = url.lastIndexOf("/");
            int lastDot = url.lastIndexOf(".");
            url = lastDot > lastSlash && lastDot > -1 ? url.substring(0, lastDot) + "/" + this.locationId + url.substring(lastDot) : url + "/" + this.locationId;
            response.setHeader("Location", url);
            this.status = 201;
        } else if (this.location != null) {
            response.setHeader("Location", this.location);
            this.status = 201;
        }
        if (this.status == 200 && !this.disableCaching) {
            boolean etagNotChanged = false;
            boolean lastModifiedNotChanged = false;
            String reqETag = request.getHeader("If-None-Match");
            if (this.etag != null && this.etag.equals(reqETag)) {
                etagNotChanged = true;
            }
            String reqLastModified = request.getHeader("If-Modified-Since");
            if (this.lastModified != null && String.valueOf(this.lastModified.getTime()).equals(reqLastModified)) {
                lastModifiedNotChanged = true;
            }
            if (etagNotChanged && lastModifiedNotChanged || etagNotChanged && reqLastModified == null || lastModifiedNotChanged && reqETag == null) {
                this.status = 304;
            }
        }
        response.setStatus(this.status);
        return this.resultCode;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public String getResultCode() {
        return this.resultCode;
    }
}

