/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.mapper.DefaultActionMapper;

public class RestActionMapper
extends DefaultActionMapper {
    protected static final Logger LOG = LogManager.getLogger(RestActionMapper.class);
    public static final String HTTP_METHOD_PARAM = "_method";
    private static final String GET = "get";
    private static final String POST = "post";
    private static final String PUT = "put";
    private static final String DELETE = "delete";
    private static final String OPTIONS = "options";
    private String idParameterName = "id";
    private String indexMethodName = "index";
    private String getMethodName = "show";
    private String postMethodName = "create";
    private String editMethodName = "edit";
    private String newMethodName = "editNew";
    private String deleteMethodName = "destroy";
    private String putMethodName = "update";
    private String optionsMethodName = "options";
    private String postContinueMethodName = "createContinue";
    private String putContinueMethodName = "updateContinue";
    private boolean allowDynamicMethodCalls = false;

    public String getIdParameterName() {
        return this.idParameterName;
    }

    @Inject(required=false, value="struts.mapper.idParameterName")
    public void setIdParameterName(String idParameterName) {
        this.idParameterName = idParameterName;
    }

    @Inject(required=false, value="struts.mapper.indexMethodName")
    public void setIndexMethodName(String indexMethodName) {
        this.indexMethodName = indexMethodName;
    }

    @Inject(required=false, value="struts.mapper.getMethodName")
    public void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    @Inject(required=false, value="struts.mapper.postMethodName")
    public void setPostMethodName(String postMethodName) {
        this.postMethodName = postMethodName;
    }

    @Inject(required=false, value="struts.mapper.editMethodName")
    public void setEditMethodName(String editMethodName) {
        this.editMethodName = editMethodName;
    }

    @Inject(required=false, value="struts.mapper.newMethodName")
    public void setNewMethodName(String newMethodName) {
        this.newMethodName = newMethodName;
    }

    @Inject(required=false, value="struts.mapper.deleteMethodName")
    public void setDeleteMethodName(String deleteMethodName) {
        this.deleteMethodName = deleteMethodName;
    }

    @Inject(required=false, value="struts.mapper.putMethodName")
    public void setPutMethodName(String putMethodName) {
        this.putMethodName = putMethodName;
    }

    @Inject(required=false, value="struts.mapper.optionsMethodName")
    public void setOptionsMethodName(String optionsMethodName) {
        this.optionsMethodName = optionsMethodName;
    }

    @Inject(required=false, value="struts.mapper.postContinueMethodName")
    public void setPostContinueMethodName(String postContinueMethodName) {
        this.postContinueMethodName = postContinueMethodName;
    }

    @Inject(required=false, value="struts.mapper.putContinueMethodName")
    public void setPutContinueMethodName(String putContinueMethodName) {
        this.putContinueMethodName = putContinueMethodName;
    }

    @Inject(required=false, value="struts.enable.DynamicMethodInvocation")
    public void setAllowDynamicMethodCalls(String allowDynamicMethodCalls) {
        this.allowDynamicMethodCalls = "true".equalsIgnoreCase(allowDynamicMethodCalls);
    }

    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        ActionMapping mapping = new ActionMapping();
        String uri = RequestUtils.getUri((HttpServletRequest)request);
        if ((uri = this.dropExtension(uri, mapping)) == null) {
            return null;
        }
        this.parseNameAndNamespace(uri, mapping, configManager);
        this.handleSpecialParameters(request, mapping);
        if (mapping.getName() == null) {
            return null;
        }
        this.handleDynamicMethodInvocation(mapping, mapping.getName());
        String fullName = mapping.getName();
        if (StringUtils.isNotEmpty((CharSequence)fullName)) {
            int scPos = fullName.indexOf(59);
            if (scPos > -1 && !"edit".equals(fullName.substring(scPos + 1))) {
                fullName = fullName.substring(0, scPos);
            }
            int lastSlashPos = fullName.lastIndexOf(47);
            String id = null;
            if (lastSlashPos > -1) {
                int prevSlashPos = fullName.lastIndexOf(47, lastSlashPos - 1);
                if (prevSlashPos > -1 && mapping.getMethod() == null) {
                    mapping.setMethod(fullName.substring(lastSlashPos + 1));
                    fullName = fullName.substring(0, lastSlashPos);
                    lastSlashPos = prevSlashPos;
                }
                id = fullName.substring(lastSlashPos + 1);
            }
            if (mapping.getMethod() == null) {
                if (this.isOptions(request)) {
                    mapping.setMethod(this.optionsMethodName);
                } else if (lastSlashPos == -1 || lastSlashPos == fullName.length() - 1) {
                    if (this.isGet(request)) {
                        mapping.setMethod(this.indexMethodName);
                    } else if (this.isPost(request)) {
                        if (this.isExpectContinue(request)) {
                            mapping.setMethod(this.postContinueMethodName);
                        } else {
                            mapping.setMethod(this.postMethodName);
                        }
                    }
                } else if (id != null) {
                    if (this.isGet(request) && id.endsWith(";edit")) {
                        id = id.substring(0, id.length() - ";edit".length());
                        mapping.setMethod(this.editMethodName);
                    } else if (this.isGet(request) && "new".equals(id)) {
                        mapping.setMethod(this.newMethodName);
                    } else if (this.isDelete(request)) {
                        mapping.setMethod(this.deleteMethodName);
                    } else if (this.isGet(request)) {
                        mapping.setMethod(this.getMethodName);
                    } else if (this.isPut(request)) {
                        if (this.isExpectContinue(request)) {
                            mapping.setMethod(this.putContinueMethodName);
                        } else {
                            mapping.setMethod(this.putMethodName);
                        }
                    }
                }
            }
            if (id != null) {
                if (!"new".equals(id)) {
                    if (mapping.getParams() == null) {
                        mapping.setParams(new HashMap());
                    }
                    mapping.getParams().put(this.idParameterName, new String[]{id});
                }
                fullName = fullName.substring(0, lastSlashPos);
            }
            mapping.setName(fullName);
        }
        return mapping;
    }

    private void handleDynamicMethodInvocation(ActionMapping mapping, String name) {
        int exclamation = name.lastIndexOf("!");
        if (exclamation != -1) {
            String actionName = name.substring(0, exclamation);
            String actionMethod = name.substring(exclamation + 1);
            int scPos = actionMethod.indexOf(59);
            if (scPos != -1) {
                actionName = actionName + actionMethod.substring(scPos);
                actionMethod = actionMethod.substring(0, scPos);
            }
            mapping.setName(actionName);
            if (this.allowDynamicMethodCalls) {
                mapping.setMethod(this.cleanupActionName(actionMethod));
            } else {
                mapping.setMethod(null);
            }
        }
    }

    protected void parseNameAndNamespace(String uri, ActionMapping mapping, ConfigurationManager configManager) {
        String name;
        String namespace;
        int lastSlash = uri.lastIndexOf("/");
        if (lastSlash == -1) {
            namespace = "";
            name = uri;
        } else if (lastSlash == 0) {
            namespace = "/";
            name = uri.substring(lastSlash + 1);
        } else {
            Configuration config = configManager.getConfiguration();
            String prefix = uri.substring(0, lastSlash);
            namespace = "";
            for (Object o : config.getPackageConfigs().values()) {
                String ns = ((PackageConfig)o).getNamespace();
                if (ns == null || !prefix.startsWith(ns) || prefix.length() != ns.length() && prefix.charAt(ns.length()) != '/' || ns.length() <= namespace.length()) continue;
                namespace = ns;
            }
            name = uri.substring(namespace.length() + 1);
        }
        mapping.setNamespace(namespace);
        mapping.setName(name);
    }

    protected boolean isGet(HttpServletRequest request) {
        return GET.equalsIgnoreCase(request.getMethod());
    }

    protected boolean isPost(HttpServletRequest request) {
        return POST.equalsIgnoreCase(request.getMethod());
    }

    protected boolean isPut(HttpServletRequest request) {
        return PUT.equalsIgnoreCase(request.getMethod()) || this.isPost(request) && PUT.equalsIgnoreCase(request.getParameter(HTTP_METHOD_PARAM));
    }

    protected boolean isDelete(HttpServletRequest request) {
        return DELETE.equalsIgnoreCase(request.getMethod()) || DELETE.equalsIgnoreCase(request.getParameter(HTTP_METHOD_PARAM));
    }

    protected boolean isOptions(HttpServletRequest request) {
        return OPTIONS.equalsIgnoreCase(request.getMethod());
    }

    protected boolean isExpectContinue(HttpServletRequest request) {
        String expect = request.getHeader("Expect");
        return expect != null && expect.toLowerCase().contains("100-continue");
    }
}

