/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerConfigurationInformationFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerManager;
import org.apache.synapse.ServerState;
import org.apache.synapse.core.SynapseEnvironment;

public class SynapseModule
implements Module {
    private static final Log log = LogFactory.getLog(SynapseModule.class);

    public void init(ConfigurationContext configurationContext, AxisModule axisModule) throws AxisFault {
        Object synEnvParameter = configurationContext.getAxisConfiguration().getParameterValue("synapse.env");
        if (synEnvParameter != null && ((SynapseEnvironment)synEnvParameter).getServerContextInformation().getServerState() != ServerState.STARTED) {
            log.info((Object)"Initializing the Synapse as a handler");
            ServerConfigurationInformation configurationInformation = ServerConfigurationInformationFactory.createServerConfigurationInformation((AxisConfiguration)configurationContext.getAxisConfiguration());
            ServerContextInformation contextInfo = new ServerContextInformation((Object)configurationContext, configurationInformation);
            ServerManager serverManager = new ServerManager();
            serverManager.init(configurationInformation, contextInfo);
            serverManager.start();
        } else {
            log.info((Object)"Detected an already started synapse instance using that for the mediation");
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
    }
}

