/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.handler.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;

public class HandlerUtil {
    public static void doHandlerLogging(Log log, org.apache.axis2.context.MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Synapse handler received a new message for message mediation...");
            log.debug((Object)("Received To: " + (messageContext.getTo() != null ? messageContext.getTo().getAddress() : "null")));
            log.debug((Object)("SOAPAction: " + (messageContext.getSoapAction() != null ? messageContext.getSoapAction() : "null")));
            log.debug((Object)("WSA-Action: " + (messageContext.getWSAAction() != null ? messageContext.getWSAAction() : "null")));
            String[] cids = messageContext.getAttachmentMap().getAllContentIDs();
            if (cids != null && cids.length > 0) {
                for (int i = 0; i < cids.length; ++i) {
                    log.debug((Object)("Attachment : " + cids[i]));
                }
            }
            log.debug((Object)("Body : \n" + messageContext.getEnvelope()));
        }
    }

    public static boolean mediateInMessage(Log log, org.apache.axis2.context.MessageContext messageContext, MessageContext synCtx) throws AxisFault {
        AxisService service = messageContext.getAxisService();
        if (service != null) {
            Parameter inMediationParam = service.getParameter("mediation-in-sequence");
            if (inMediationParam != null && inMediationParam.getValue() != null) {
                if (inMediationParam.getValue() instanceof Mediator) {
                    Mediator inMessageSequence = (Mediator)inMediationParam.getValue();
                    return inMessageSequence.mediate(synCtx);
                }
                if (inMediationParam.getValue() instanceof String) {
                    Mediator inMessageSequence = synCtx.getConfiguration().getSequence((String)inMediationParam.getValue());
                    return inMessageSequence.mediate(synCtx);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The provided in message mediation sequence is not a proper mediator");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Couldn't find the incoming mediation for the service " + service.getName()));
            }
        } else {
            String message = "Couldn't find the Service for the associated message with id " + messageContext.getMessageID();
            log.error((Object)message);
            throw new AxisFault(message);
        }
        return true;
    }

    public static boolean mediateOutMessage(Log log, org.apache.axis2.context.MessageContext messageContext, MessageContext synCtx) throws AxisFault {
        AxisService service = messageContext.getAxisService();
        if (service != null) {
            Parameter inMediationParam = service.getParameter("mediation-out-sequence");
            if (inMediationParam != null && inMediationParam.getValue() != null) {
                if (inMediationParam.getValue() instanceof Mediator) {
                    Mediator inMessageSequence = (Mediator)inMediationParam.getValue();
                    return inMessageSequence.mediate(synCtx);
                }
                if (inMediationParam.getValue() instanceof String) {
                    Mediator inMessageSequence = synCtx.getConfiguration().getSequence((String)inMediationParam.getValue());
                    return inMessageSequence.mediate(synCtx);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The provided out message mediation sequence is not a proper mediator");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Couldn't find the outgoing mediation for the service " + service.getName()));
            }
        } else {
            String message = "Couldn't find the Service for the associated message with id " + messageContext.getMessageID();
            log.error((Object)message);
            throw new AxisFault(message);
        }
        return true;
    }
}

