/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescription;

public class TaskDescriptionFactory {
    private static final Log log = LogFactory.getLog(TaskDescriptionFactory.class);
    private static final String NULL_NAMESPACE = "";
    private static final String TASK = "task";
    private static final String TRIGGER = "trigger";
    private static final String PROPERTY = "property";
    private static final String DESCRIPTION = "description";

    public static TaskDescription createTaskDescription(OMElement el, OMNamespace tagetNamespace) {
        QName task;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating SimpleQuartz Task");
        }
        if ((task = TaskDescriptionFactory.createQName(TASK, tagetNamespace)).equals(el.getQName())) {
            String pinnedServersValue;
            OMAttribute pinnedServers;
            OMAttribute classAttr;
            TaskDescription taskDescription = new TaskDescription();
            String name = el.getAttributeValue(new QName(NULL_NAMESPACE, "name"));
            if (name != null) {
                taskDescription.setName(name);
            } else {
                TaskDescriptionFactory.handleException("Name for a task is required, missing name in the task");
            }
            String group = el.getAttributeValue(new QName(NULL_NAMESPACE, "group"));
            if (group != null) {
                taskDescription.setTaskGroup(group);
            }
            if ((classAttr = el.getAttribute(new QName("class"))) != null && classAttr.getAttributeValue() != null) {
                String classname = classAttr.getAttributeValue();
                try {
                    Class.forName(classname).newInstance();
                }
                catch (Exception e) {
                    TaskDescriptionFactory.handleException("Failed to load task class " + classname, e);
                }
                taskDescription.setTaskImplClassName(classname);
            } else {
                log.warn((Object)"TaskClass cannot be found.Task implementation may need a task class if there is no default one");
            }
            OMElement descElem = el.getFirstChildWithName(TaskDescriptionFactory.createQName(DESCRIPTION, tagetNamespace));
            if (descElem != null) {
                taskDescription.setTaskDescription(descElem.getText());
            }
            if ((pinnedServers = el.getAttribute(new QName(NULL_NAMESPACE, "pinnedServers"))) != null && (pinnedServersValue = pinnedServers.getAttributeValue()) != null) {
                StringTokenizer st = new StringTokenizer(pinnedServersValue, " ,");
                ArrayList<String> pinnedServersList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.length() == 0) continue;
                    pinnedServersList.add(token);
                }
                taskDescription.setPinnedServers(pinnedServersList);
            }
            Iterator it = el.getChildrenWithName(TaskDescriptionFactory.createQName(PROPERTY, tagetNamespace));
            while (it.hasNext()) {
                OMElement prop = (OMElement)it.next();
                if (PropertyHelper.isStaticProperty((OMElement)prop)) {
                    taskDescription.setXmlProperty(prop);
                    continue;
                }
                TaskDescriptionFactory.handleException("Tasks does not support dynamic properties");
            }
            OMElement trigger = el.getFirstChildWithName(TaskDescriptionFactory.createQName(TRIGGER, tagetNamespace));
            if (trigger != null) {
                OMAttribute repeatInterval;
                OMAttribute once;
                OMAttribute count = trigger.getAttribute(new QName("count"));
                if (count != null) {
                    try {
                        taskDescription.setCount(Integer.parseInt(count.getAttributeValue()));
                    }
                    catch (Exception e) {
                        TaskDescriptionFactory.handleException("Failed to parse trigger count as an integer", e);
                    }
                }
                if ((once = trigger.getAttribute(new QName("once"))) != null && Boolean.TRUE.toString().equals(once.getAttributeValue())) {
                    taskDescription.setCount(1);
                    taskDescription.setInterval(1L);
                    taskDescription.setIntervalInMs(false);
                }
                if ((repeatInterval = trigger.getAttribute(new QName("interval"))) == null && taskDescription.getCount() > 1) {
                    TaskDescriptionFactory.handleException("Trigger seems to be a simple trigger, but no interval specified");
                } else if (repeatInterval != null && repeatInterval.getAttributeValue() != null) {
                    try {
                        long repeatIntervalInSeconds = Long.parseLong(repeatInterval.getAttributeValue());
                        long repeatIntervalInMillis = repeatIntervalInSeconds * 1000L;
                        taskDescription.setInterval(repeatIntervalInMillis);
                        taskDescription.setIntervalInMs(true);
                    }
                    catch (Exception e) {
                        TaskDescriptionFactory.handleException("Failed to parse trigger interval as a long value", e);
                    }
                }
                OMAttribute expr = trigger.getAttribute(new QName("cron"));
                if (expr == null && taskDescription.getInterval() == 0L) {
                    taskDescription.setCount(1);
                    taskDescription.setInterval(1L);
                    taskDescription.setIntervalInMs(false);
                } else if (expr != null && taskDescription.getInterval() > 0L) {
                    TaskDescriptionFactory.handleException("Trigger syntax error : both cron and simple trigger attributes are present");
                } else if (expr != null && expr.getAttributeValue() != null) {
                    taskDescription.setCronExpression(expr.getAttributeValue());
                }
            } else {
                taskDescription.setCount(1);
                taskDescription.setInterval(1L);
                taskDescription.setIntervalInMs(false);
            }
            return taskDescription;
        }
        TaskDescriptionFactory.handleException("Syntax error in the task : wrong QName for the task");
        return null;
    }

    private static QName createQName(String localName, OMNamespace omNamespace) {
        return new QName(omNamespace.getNamespaceURI(), localName, omNamespace.getPrefix());
    }

    private static void handleException(String message, Exception e) {
        log.error((Object)message);
        throw new SynapseTaskException(message, e);
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseTaskException(message);
    }
}

