/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescription;

public class TaskDescriptionSerializer {
    private static final Log log = LogFactory.getLog(TaskDescriptionSerializer.class);
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private static final String NULL_NAMESPACE = "";
    private static final OMNamespace NULL_OMNS = omFactory.createOMNamespace("", "");

    public static OMElement serializeTaskDescription(OMNamespace targetNamespace, TaskDescription taskDescription) {
        List<String> pinnedServers;
        String group;
        if (taskDescription == null) {
            throw new SynapseTaskException("TaskDescription can not be null", log);
        }
        OMElement task = omFactory.createOMElement("task", targetNamespace);
        task.addAttribute("name", taskDescription.getName(), NULL_OMNS);
        String taskClass = taskDescription.getTaskImplClassName();
        if (taskClass != null && !NULL_NAMESPACE.equals(taskClass)) {
            task.addAttribute("class", taskDescription.getTaskImplClassName(), NULL_OMNS);
        }
        if ((group = taskDescription.getTaskGroup()) != null && !NULL_NAMESPACE.equals(group)) {
            task.addAttribute("group", group, NULL_OMNS);
        }
        if ((pinnedServers = taskDescription.getPinnedServers()) != null && !pinnedServers.isEmpty()) {
            StringBuffer pinnedServersStr = new StringBuffer(pinnedServers.get(0));
            for (int i = 1; i < pinnedServers.size(); ++i) {
                pinnedServersStr.append(" ").append(pinnedServers.get(i));
            }
            task.addAttribute(omFactory.createOMAttribute("pinnedServers", NULL_OMNS, pinnedServersStr.toString()));
        }
        if (taskDescription.getTaskDescription() != null) {
            OMElement descElem = omFactory.createOMElement("description", targetNamespace, (OMContainer)task);
            descElem.setText(taskDescription.getTaskDescription());
        }
        OMElement el = omFactory.createOMElement("trigger", targetNamespace, (OMContainer)task);
        if (taskDescription.getCount() == 1) {
            el.addAttribute("once", "true", NULL_OMNS);
        } else if (taskDescription.getCronExpression() != null) {
            el.addAttribute("cron", taskDescription.getCronExpression(), NULL_OMNS);
        } else {
            if (taskDescription.getCount() != -1) {
                el.addAttribute("count", Integer.toString(taskDescription.getCount()), NULL_OMNS);
            }
            if (taskDescription.getInterval() != 0L) {
                long interval = taskDescription.getInterval();
                if (taskDescription.getIntervalInMs()) {
                    interval /= 1000L;
                }
                el.addAttribute("interval", Long.toString(interval), NULL_OMNS);
            }
        }
        for (OMElement o : taskDescription.getXmlProperties()) {
            OMElement prop = o;
            if (prop == null) continue;
            prop.setNamespace(targetNamespace);
            task.addChild((OMNode)prop.cloneOMElement());
        }
        return task;
    }
}

