/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;

public final class TaskDescription {
    public static final String CLASSNAME = "ClassName";
    public static final String PROPERTIES = "Properties";
    public static final String INSTANCE = "Instance";
    public static final String DEFAULT_GROUP = "synapse.simple.quartz";
    private String taskName;
    private String taskGroup;
    private String taskMgrClassName;
    private int triggerCount = -1;
    private long triggerInterval = 0L;
    private boolean isIntervalInMs = false;
    private String cronExpression;
    private Calendar startTime;
    private Calendar endTime;
    private List<String> pinnedServersList;
    private Map<String, String> properties;
    private Map<String, Object> resources;
    private final Set<OMElement> xmlProperties = new HashSet<OMElement>();
    private String taskDescription;

    public String getName() {
        return this.taskName;
    }

    public void setName(String name) {
        this.taskName = name;
    }

    public void setProperties(Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = properties;
            return;
        }
        this.properties = new HashMap<String, String>();
        for (String key : properties.keySet()) {
            this.properties.put(key, properties.get(key));
        }
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        if (name == null) {
            return;
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties == null || name == null ? null : this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    public String getTaskGroup() {
        return this.taskGroup;
    }

    public void setTaskGroup(String taskGroup) {
        this.taskGroup = taskGroup;
    }

    public String getTaskImplClassName() {
        if (this.getProperty(CLASSNAME) != null) {
            return (String)this.getProperty(CLASSNAME);
        }
        return this.taskMgrClassName;
    }

    public void setTaskImplClassName(String taskMgrClassName) {
        this.taskMgrClassName = taskMgrClassName;
    }

    public int getCount() {
        return this.triggerCount;
    }

    public void setCount(int count) {
        this.triggerCount = count;
    }

    public long getInterval() {
        return this.triggerInterval;
    }

    public boolean getIntervalInMs() {
        return this.isIntervalInMs;
    }

    public void setInterval(long interval) {
        this.triggerInterval = interval;
    }

    public List<String> getPinnedServers() {
        return this.pinnedServersList == null ? Collections.emptyList() : Collections.unmodifiableList(this.pinnedServersList);
    }

    public void setPinnedServers(List<String> pinnedServersList) {
        if (pinnedServersList == null) {
            return;
        }
        this.pinnedServersList = pinnedServersList;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public void setIntervalInMs(boolean isIntervalInMs) {
        this.isIntervalInMs = isIntervalInMs;
    }

    public Map<String, Object> getResources() {
        return this.resources == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.resources);
    }

    public void setResources(Map<String, Object> resources) {
        if (resources == null) {
            return;
        }
        this.resources = resources;
    }

    public void addResource(String key, Object value) {
        if (this.resources == null) {
            this.resources = new HashMap<String, Object>();
        }
        if (key != null) {
            this.resources.put(key, value);
        }
    }

    public Object getResource(String key) {
        if (this.resources != null && key != null) {
            return this.resources.get(key);
        }
        return null;
    }

    public Set<OMElement> getXmlProperties() {
        return this.xmlProperties == null ? Collections.emptySet() : Collections.unmodifiableSet(this.xmlProperties);
    }

    public void setXmlProperty(OMElement property) {
        if (property == null) {
            return;
        }
        this.xmlProperties.add(property);
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        if (taskDescription == null) {
            return;
        }
        this.taskDescription = taskDescription;
    }
}

