/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskJobDetailFactory;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

public class DefaultTaskJobDetailFactory
implements TaskJobDetailFactory {
    private static final Log log = LogFactory.getLog(DefaultTaskJobDetailFactory.class);

    @Override
    public JobDetail createJobDetail(TaskDescription taskDescription, Map<String, Object> resources, Class<? extends Job> jobClass) {
        String name;
        if (taskDescription == null) {
            throw new SynapseTaskException("Task Description cannot be found.", log);
        }
        if (jobClass == null) {
            throw new SynapseTaskException("Job Class cannot be found.", log);
        }
        if (resources == null) {
            resources = new HashMap<String, Object>();
        }
        JobDataMap jobDataMap = new JobDataMap(resources);
        Set<OMElement> xmlProperties = taskDescription.getXmlProperties();
        if (xmlProperties != null) {
            jobDataMap.put("Properties", xmlProperties);
        }
        if ((name = taskDescription.getName()) == null || "".equals(name)) {
            throw new SynapseTaskException("Name cannot be found.", log);
        }
        String group = taskDescription.getTaskGroup();
        if (group == null || "".equals(group)) {
            group = "synapse.simple.quartz";
        }
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(name, group).usingJobData(jobDataMap).build();
        return jobDetail;
    }
}

