/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.Date;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskTriggerFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class DefaultTaskTriggerFactory
implements TaskTriggerFactory {
    private static final Log log = LogFactory.getLog(DefaultTaskTriggerFactory.class);
    private static final Random RANDOM = new Random();

    @Override
    public Trigger createTrigger(TaskDescription taskDescription) {
        String group;
        String name = taskDescription.getName();
        if (name == null || "".equals(name)) {
            throw new SynapseTaskException("Name of the Task cannot be null", log);
        }
        String cron = taskDescription.getCronExpression();
        int repeatCount = taskDescription.getCount();
        long repeatInterval = taskDescription.getInterval();
        if (!taskDescription.getIntervalInMs()) {
            repeatInterval *= 1000L;
        }
        Date startTime = null;
        if (taskDescription.getStartTime() != null) {
            startTime = taskDescription.getStartTime().getTime();
        }
        Date endTime = null;
        if (taskDescription.getEndTime() != null) {
            endTime = taskDescription.getEndTime().getTime();
        }
        if ((group = taskDescription.getTaskGroup()) == null || "".equals(group)) {
            group = "synapse.simple.quartz";
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(name + "-trigger-" + String.valueOf(RANDOM.nextLong()), group);
        if (startTime != null) {
            triggerBuilder.startAt(startTime);
        } else {
            triggerBuilder.startNow();
        }
        if (endTime != null) {
            triggerBuilder.endAt(endTime);
        }
        Trigger trigger = cron == null || "".equals(cron) ? (repeatCount >= 0 ? triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(repeatInterval).withRepeatCount(repeatCount - 1)).build() : triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(repeatInterval).repeatForever()).build()) : triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
        if (trigger == null) {
            throw new SynapseTaskException("Trigger is null for the Task description : " + taskDescription, log);
        }
        return trigger;
    }
}

