/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.task;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.task.Task;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskManager;

public class TaskScheduler {
    private static final Log logger = LogFactory.getLog((String)TaskScheduler.class.getName());
    private static final Object lock = new Object();
    private String name;
    private TaskManager taskManager;
    private boolean initialized = false;

    public TaskScheduler(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties properties, TaskManager taskManager) {
        Object object = lock;
        synchronized (object) {
            if (this.initialized) {
                logger.debug((Object)"TaskScheduler already initialized.");
                return;
            }
            this.initialized = false;
        }
        this.setTaskManager(taskManager, properties);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setTaskManager(TaskManager taskManager, Properties properties) {
        Object object = lock;
        synchronized (object) {
            if (taskManager == null) {
                logger.error((Object)"Task scheduler initialization failed. Task manager is invalid.");
                return false;
            }
            this.taskManager = taskManager;
            this.taskManager.setName(this.name);
            if (!this.taskManager.isInitialized()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Synapse Task Scheduler initializing task manager[" + taskManager.getClass().getName() + "]: Properties" + properties));
                }
                this.taskManager.init(properties);
            }
            this.initialized = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)"Could not start task scheduler. Task scheduler not properly initialized.");
                return;
            }
            this.taskManager.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll() {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)"Could not pause tasks. Task scheduler not properly initialized.");
                return;
            }
            this.taskManager.pauseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll() {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)"Could not resume tasks. Task scheduler not properly initialized.");
                return;
            }
            this.taskManager.resumeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleTask(TaskDescription taskDescription, Map<String, Object> resources, Class taskClass) {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)("Could not schedule task [" + taskDescription.getName() + "]. Task scheduler not properly initialized."));
                return false;
            }
            return this.taskManager.schedule(taskDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleTask(TaskDescription taskDescription, Map<String, Object> resources, Class jobClass, Task task) {
        if (taskDescription == null) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)("Could not schedule task [" + taskDescription.getName() + "]. Task scheduler not properly initialized."));
                return false;
            }
            return this.taskManager.schedule(taskDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleTask(TaskDescription taskDescription) {
        if (taskDescription == null) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)("Could not schedule task [" + taskDescription.getName() + "]. Task scheduler not properly initialized."));
                return false;
            }
            return this.taskManager.schedule(taskDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                return;
            }
            this.taskManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                return false;
            }
            return this.taskManager.isInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTask(String name, String group) {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)("Could not delete task[" + name + "," + group + "]. Task scheduler not properly initialized."));
                return;
            }
            this.taskManager.delete(name + "::" + group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningTaskCount() {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)"Could not determine running task count. Task scheduler not properly initialized.");
                return -1;
            }
            return this.taskManager.getRunningTaskCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskAlreadyRunning(Object taskKey) {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)"Could not determine task status. Task scheduler not properly initialized.");
                return false;
            }
            return this.taskManager.isTaskRunning(taskKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTriggerFactory(Object triggerFactory) {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)"Could not modify task manager. Task scheduler not properly initialized.");
                return;
            }
            this.taskManager.setProperty("Q_TASK_TRIGGER_FACTORY", triggerFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobDetailFactory(Object jobDetailFactory) {
        Object object = lock;
        synchronized (object) {
            if (!this.initialized) {
                logger.error((Object)"Could not modify task manager. Task scheduler not properly initialized.");
                return;
            }
            this.taskManager.setProperty("Q_TASK_JOB_DETAIL_FACTORY", jobDetailFactory);
        }
    }
}

