/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.syncope.client.SyncopeClient;
import org.apache.syncope.client.rest.RestClientExceptionMapper;
import org.apache.syncope.client.rest.RestClientFactoryBean;
import org.apache.syncope.common.to.AbstractPolicyTO;

public class SyncopeClientFactoryBean {
    private JacksonJaxbJsonProvider jsonProvider;
    private JAXBElementProvider jaxbProvider;
    private RestClientExceptionMapper exceptionMapper;
    private String address;
    private ContentType contentType;
    private RestClientFactoryBean restClientFactoryBean;

    protected JacksonJaxbJsonProvider defaultJsonProvider() {
        return new JacksonJaxbJsonProvider();
    }

    protected JAXBElementProvider defaultJAXBProvider() {
        JAXBElementProvider defaultJAXBProvider = new JAXBElementProvider();
        DocumentDepthProperties depthProperties = new DocumentDepthProperties();
        depthProperties.setInnerElementCountThreshold(500);
        defaultJAXBProvider.setDepthProperties(depthProperties);
        HashMap<String, Boolean> marshallerProperties = new HashMap<String, Boolean>();
        marshallerProperties.put("jaxb.formatted.output", Boolean.TRUE);
        defaultJAXBProvider.setMarshallerProperties(marshallerProperties);
        HashMap<String, String> collectionWrapperMap = new HashMap<String, String>();
        collectionWrapperMap.put(AbstractPolicyTO.class.getName(), "policies");
        defaultJAXBProvider.setCollectionWrapperMap(collectionWrapperMap);
        return defaultJAXBProvider;
    }

    protected RestClientExceptionMapper defaultExceptionMapper() {
        return new RestClientExceptionMapper();
    }

    protected RestClientFactoryBean defaultRestClientFactoryBean() {
        RestClientFactoryBean defaultRestClientFactoryBean = new RestClientFactoryBean();
        if (StringUtils.isBlank((CharSequence)this.address)) {
            throw new IllegalArgumentException("Property 'address' is missing");
        }
        defaultRestClientFactoryBean.setAddress(this.address);
        defaultRestClientFactoryBean.setThreadSafe(true);
        defaultRestClientFactoryBean.setInheritHeaders(true);
        ArrayList<LoggingFeature> features = new ArrayList<LoggingFeature>();
        features.add(new LoggingFeature());
        defaultRestClientFactoryBean.setFeatures(features);
        ArrayList<Object> providers = new ArrayList<Object>(3);
        providers.add(this.getJaxbProvider());
        providers.add(this.getJsonProvider());
        providers.add(this.getExceptionMapper());
        defaultRestClientFactoryBean.setProviders(providers);
        return defaultRestClientFactoryBean;
    }

    public JacksonJaxbJsonProvider getJsonProvider() {
        return this.jsonProvider == null ? this.defaultJsonProvider() : this.jsonProvider;
    }

    public void setJsonProvider(JacksonJaxbJsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    public JAXBElementProvider getJaxbProvider() {
        return this.jaxbProvider == null ? this.defaultJAXBProvider() : this.jaxbProvider;
    }

    public SyncopeClientFactoryBean setJaxbProvider(JAXBElementProvider jaxbProvider) {
        this.jaxbProvider = jaxbProvider;
        return this;
    }

    public RestClientExceptionMapper getExceptionMapper() {
        return this.exceptionMapper == null ? this.defaultExceptionMapper() : this.exceptionMapper;
    }

    public SyncopeClientFactoryBean setExceptionMapper(RestClientExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public SyncopeClientFactoryBean setAddress(String address) {
        this.address = address;
        return this;
    }

    public ContentType getContentType() {
        return this.contentType == null ? ContentType.JSON : this.contentType;
    }

    public SyncopeClientFactoryBean setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public SyncopeClientFactoryBean setContentType(String contentType) {
        this.contentType = ContentType.fromString(contentType);
        return this;
    }

    public RestClientFactoryBean getRestClientFactoryBean() {
        return this.restClientFactoryBean == null ? this.defaultRestClientFactoryBean() : this.restClientFactoryBean;
    }

    public SyncopeClientFactoryBean setRestClientFactoryBean(RestClientFactoryBean restClientFactoryBean) {
        this.restClientFactoryBean = restClientFactoryBean;
        return this;
    }

    public SyncopeClient createAnonymous() {
        return this.create(null, null);
    }

    public SyncopeClient create(String username, String password) {
        return new SyncopeClient(this.getContentType().getMediaType(), this.getRestClientFactoryBean(), username, password);
    }

    public static enum ContentType {
        JSON(MediaType.APPLICATION_JSON_TYPE),
        XML(MediaType.APPLICATION_XML_TYPE);

        private final MediaType mediaType;

        private ContentType(MediaType mediaType) {
            this.mediaType = mediaType;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public static ContentType fromString(String value) {
            return StringUtils.isNotBlank((CharSequence)value) && value.equalsIgnoreCase(XML.getMediaType().toString()) ? XML : JSON;
        }
    }
}

