/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.rest;

import java.security.AccessControlException;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.syncope.common.SyncopeClientCompositeException;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.types.ClientExceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestClientExceptionMapper
implements ExceptionMapper<Exception>,
ResponseExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientExceptionMapper.class);

    public Response toResponse(Exception exception) {
        throw new UnsupportedOperationException("Call of toResponse() method is not expected in RestClientExceptionnMapper");
    }

    public Exception fromResponse(Response response) {
        int statusCode = response.getStatus();
        SyncopeClientCompositeException scce = this.checkSyncopeClientCompositeException(response);
        Object ex = scce != null ? (scce.getExceptions().size() == 1 ? (Exception)scce.getExceptions().iterator().next() : scce) : (statusCode == Response.Status.UNAUTHORIZED.getStatusCode() ? new AccessControlException("Remote unauthorized exception") : (statusCode == Response.Status.BAD_REQUEST.getStatusCode() ? new BadRequestException() : new WebServiceException(String.format("Remote exception with status code: %s", Response.Status.fromStatusCode((int)statusCode).name()))));
        LOG.error("Exception thrown by REST methods: " + ((Throwable)ex).getMessage(), (Throwable)ex);
        return ex;
    }

    private SyncopeClientCompositeException checkSyncopeClientCompositeException(Response response) {
        List exTypesInHeaders = (List)response.getHeaders().get((Object)"X-Application-Error-Code");
        if (exTypesInHeaders == null) {
            LOG.debug("No X-Application-Error-Code provided");
            return null;
        }
        SyncopeClientCompositeException compException = SyncopeClientException.buildComposite();
        HashSet<String> handledExceptions = new HashSet<String>();
        for (Object exceptionTypeValue : exTypesInHeaders) {
            String exTypeAsString = (String)exceptionTypeValue;
            ClientExceptionType exceptionType = null;
            try {
                exceptionType = ClientExceptionType.fromHeaderValue((String)exTypeAsString);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected value of X-Application-Error-Code: " + exTypeAsString, (Throwable)e);
            }
            if (exceptionType == null) continue;
            handledExceptions.add(exTypeAsString);
            SyncopeClientException clientException = SyncopeClientException.build((ClientExceptionType)exceptionType);
            if (response.getHeaders().get((Object)"X-Application-Error-Info") != null && !((List)response.getHeaders().get((Object)"X-Application-Error-Info")).isEmpty()) {
                for (Object value : (List)response.getHeaders().get((Object)"X-Application-Error-Info")) {
                    String element = value.toString();
                    if (!element.startsWith(exceptionType.getHeaderValue())) continue;
                    clientException.getElements().add(StringUtils.substringAfter((String)value.toString(), (String)":"));
                }
            }
            compException.addException(clientException);
        }
        exTypesInHeaders.removeAll(handledExceptions);
        if (!exTypesInHeaders.isEmpty()) {
            LOG.error("Unmanaged exceptions: " + exTypesInHeaders);
        }
        if (compException.hasExceptions()) {
            return compException;
        }
        return null;
    }
}

