/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.Tree;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.PropertyConduit2;
import org.apache.tapestry5.internal.InternalPropertyConduit;
import org.apache.tapestry5.internal.antlr.PropertyExpressionLexer;
import org.apache.tapestry5.internal.antlr.PropertyExpressionParser;
import org.apache.tapestry5.internal.services.Invariant;
import org.apache.tapestry5.internal.services.LiteralPropertyConduit;
import org.apache.tapestry5.internal.services.PropertyConduitDelegate;
import org.apache.tapestry5.internal.services.PropertyExpressionException;
import org.apache.tapestry5.internal.services.StringInterner;
import org.apache.tapestry5.internal.util.IntegerRange;
import org.apache.tapestry5.internal.util.MultiKey;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.NullAnnotationProvider;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.GenericsUtils;
import org.apache.tapestry5.ioc.internal.util.InternalCommonsUtils;
import org.apache.tapestry5.ioc.services.ClassPropertyAdapter;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.ComponentClasses;
import org.apache.tapestry5.services.ComponentLayer;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.PropertyConduitSource;

public class PropertyConduitSourceImpl
implements PropertyConduitSource {
    private static InstructionBuilderCallback RETURN_NULL = new InstructionBuilderCallback(){

        public void doBuild(InstructionBuilder builder) {
            builder.loadNull().returnResult();
        }
    };
    private static final String[] SINGLE_OBJECT_ARGUMENT = new String[]{Object.class.getName()};
    private final AnnotationProvider nullAnnotationProvider = new NullAnnotationProvider();
    private final PropertyAccess access;
    private final PlasticProxyFactory proxyFactory;
    private final TypeCoercer typeCoercer;
    private final StringInterner interner;
    private final Map<MultiKey, PropertyConduit> cache = CollectionFactory.newConcurrentMap();
    private final Invariant invariantAnnotation = new Invariant(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Invariant.class;
        }
    };
    private final AnnotationProvider invariantAnnotationProvider = new AnnotationProvider(){

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            if (annotationClass == Invariant.class) {
                return (T)((Annotation)annotationClass.cast(PropertyConduitSourceImpl.this.invariantAnnotation));
            }
            return null;
        }
    };
    private final PropertyConduit literalTrue;
    private final PropertyConduit literalFalse;
    private final PropertyConduit literalNull;
    private final PropertyConduitDelegate sharedDelegate;

    private static Method getMethod(Class containingClass, String name, Class ... parameterTypes) {
        try {
            return containingClass.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static MethodDescription getMethodDescription(Class containingClass, String name, Class ... parameterTypes) {
        return new MethodDescription(PropertyConduitSourceImpl.getMethod(containingClass, name, parameterTypes));
    }

    public PropertyConduitSourceImpl(PropertyAccess access, @ComponentLayer PlasticProxyFactory proxyFactory, TypeCoercer typeCoercer, StringInterner interner) {
        this.access = access;
        this.proxyFactory = proxyFactory;
        this.typeCoercer = typeCoercer;
        this.interner = interner;
        this.literalTrue = this.createLiteralConduit(Boolean.class, true);
        this.literalFalse = this.createLiteralConduit(Boolean.class, false);
        this.literalNull = this.createLiteralConduit(Void.class, null);
        this.sharedDelegate = new PropertyConduitDelegate(typeCoercer);
    }

    @PostInjection
    public void listenForInvalidations(@ComponentClasses InvalidationEventHub hub) {
        hub.clearOnInvalidation(this.cache);
    }

    @Override
    public PropertyConduit create(Class rootClass, String expression) {
        assert (rootClass != null);
        assert (InternalCommonsUtils.isNonBlank((String)expression));
        MultiKey key = new MultiKey(new Object[]{rootClass, expression});
        PropertyConduit result = this.cache.get(key);
        if (result == null) {
            result = this.build(rootClass, expression);
            this.cache.put(key, result);
        }
        return result;
    }

    private PropertyConduit build(Class rootClass, String expression) {
        Tree tree = this.parse(expression);
        try {
            switch (tree.getType()) {
                case 40: {
                    return this.literalTrue;
                }
                case 13: {
                    return this.literalFalse;
                }
                case 26: {
                    return this.literalNull;
                }
                case 17: {
                    return this.createLiteralConduit(Long.class, new Long(tree.getText()));
                }
                case 8: {
                    return this.createLiteralConduit(Double.class, new Double(tree.getText()));
                }
                case 37: {
                    return this.createLiteralConduit(String.class, tree.getText());
                }
                case 30: {
                    Tree fromNode = tree.getChild(0);
                    Tree toNode = tree.getChild(1);
                    if (fromNode.getType() != 17 || toNode.getType() != 17) break;
                    int from = Integer.parseInt(fromNode.getText());
                    int to = Integer.parseInt(toNode.getText());
                    IntegerRange ir = new IntegerRange(from, to);
                    return this.createLiteralConduit(IntegerRange.class, ir);
                }
                case 39: {
                    return this.createLiteralThisPropertyConduit(rootClass);
                }
            }
            return (PropertyConduit)this.proxyFactory.createProxy(InternalPropertyConduit.class, (PlasticClassTransformer)new PropertyConduitBuilder(rootClass, expression, tree)).newInstance();
        }
        catch (Exception ex) {
            throw new PropertyExpressionException(String.format("Exception generating conduit for expression '%s': %s", expression, ExceptionUtils.toMessage((Throwable)ex)), expression, ex);
        }
    }

    private PropertyConduit createLiteralThisPropertyConduit(final Class rootClass) {
        return new PropertyConduit(){

            @Override
            public Object get(Object instance) {
                return instance;
            }

            @Override
            public void set(Object instance, Object value) {
                throw new RuntimeException("Literal values are not updateable.");
            }

            @Override
            public Class getPropertyType() {
                return rootClass;
            }

            public Type getPropertyGenericType() {
                return rootClass;
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)PropertyConduitSourceImpl.this.invariantAnnotationProvider.getAnnotation(annotationClass);
            }
        };
    }

    private <T> PropertyConduit createLiteralConduit(Class<T> type, T value) {
        return new LiteralPropertyConduit(this.typeCoercer, type, this.invariantAnnotationProvider, this.interner.format("LiteralPropertyConduit[%s]", new Object[]{value}), value);
    }

    private Tree parse(String expression) {
        ANTLRInputStream ais;
        ByteArrayInputStream is = new ByteArrayInputStream(expression.getBytes());
        try {
            ais = new ANTLRInputStream((InputStream)is);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        PropertyExpressionLexer lexer = new PropertyExpressionLexer((CharStream)ais);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PropertyExpressionParser parser = new PropertyExpressionParser((TokenStream)tokens);
        try {
            return parser.start().getTree();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error parsing property expression '%s': %s.", expression, ex.getMessage()), ex);
        }
    }

    public static NullPointerException nullTerm(String term, String expression, Object root) {
        String message = String.format("Property '%s' (within property expression '%s', of %s) is null.", term, expression, root);
        return new NullPointerException(message);
    }

    private static String toUniqueId(Method method) {
        StringBuilder builder = new StringBuilder(method.getName()).append('(');
        String sep = "";
        for (Class<?> parameterType : method.getParameterTypes()) {
            builder.append(sep);
            builder.append(PlasticUtils.toTypeName(parameterType));
            sep = ",";
        }
        return builder.append(')').toString();
    }

    static /* synthetic */ MethodDescription access$000(Class x0, String x1, Class[] x2) {
        return PropertyConduitSourceImpl.getMethodDescription(x0, x1, x2);
    }

    static /* synthetic */ Method access$100(Class x0, String x1, Class[] x2) {
        return PropertyConduitSourceImpl.getMethod(x0, x1, x2);
    }

    class PropertyConduitBuilder
    implements PlasticClassTransformer {
        private final Class rootType;
        private final String expression;
        private final Tree tree;
        private Class conduitPropertyType;
        private Type conduitPropertyGenericType;
        private String conduitPropertyName;
        private AnnotationProvider annotationProvider;
        private PlasticField delegateField;
        private PlasticClass plasticClass;
        private PlasticMethod getRootMethod;
        private PlasticMethod navMethod;

        PropertyConduitBuilder(Class rootType, String expression, Tree tree) {
            this.annotationProvider = PropertyConduitSourceImpl.this.nullAnnotationProvider;
            this.rootType = rootType;
            this.expression = expression;
            this.tree = tree;
        }

        public void transform(PlasticClass plasticClass) {
            this.plasticClass = plasticClass;
            this.implementNavMethodAndAccessors();
            this.implementOtherMethods();
            plasticClass.addToString(String.format("PropertyConduit[%s %s]", this.rootType.getName(), this.expression));
        }

        private void implementOtherMethods() {
            PlasticField annotationProviderField = this.plasticClass.introduceField(AnnotationProvider.class, "annotationProvider").inject((Object)this.annotationProvider);
            this.plasticClass.introduceMethod(ConduitMethods.GET_ANNOTATION).delegateTo(annotationProviderField);
            this.plasticClass.introduceMethod(ConduitMethods.GET_PROPERTY_NAME, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadConstant((Object)PropertyConduitBuilder.this.conduitPropertyName).returnResult();
                }
            });
            final PlasticField propertyTypeField = this.plasticClass.introduceField(Class.class, "propertyType").inject((Object)this.conduitPropertyType);
            this.plasticClass.introduceMethod(ConduitMethods.GET_PROPERTY_TYPE, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadThis().getField(propertyTypeField).returnResult();
                }
            });
            final PlasticField propertyGenericTypeField = this.plasticClass.introduceField(Type.class, "propertyGenericType").inject((Object)this.conduitPropertyGenericType);
            this.plasticClass.introduceMethod(ConduitMethods.GET_PROPERTY_GENERIC_TYPE, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadThis().getField(propertyGenericTypeField).returnResult();
                }
            });
        }

        private void implementGetRoot() {
            this.getRootMethod = this.plasticClass.introducePrivateMethod(PlasticUtils.toTypeName((Class)this.rootType), "getRoot", SINGLE_OBJECT_ARGUMENT, null);
            this.getRootMethod.changeImplementation(new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadArgument(0).dupe().when(Condition.NULL, new InstructionBuilderCallback(){

                        public void doBuild(InstructionBuilder builder) {
                            builder.throwException(NullPointerException.class, String.format("Root object of property expression '%s' is null.", PropertyConduitBuilder.this.expression));
                        }
                    });
                    builder.checkcast(PropertyConduitBuilder.this.rootType).returnResult();
                }
            });
        }

        private boolean isLeaf(Tree node) {
            int type = node.getType();
            return type != 9 && type != 35;
        }

        private void implementNavMethodAndAccessors() {
            this.implementGetRoot();
            final List callbacks = CollectionFactory.newList();
            Type activeType = this.rootType;
            Tree node = this.tree;
            while (!this.isLeaf(node)) {
                Term term = this.analyzeDerefNode(activeType, node);
                callbacks.add(term.callback);
                activeType = term.type;
                node = node.getChild(1);
            }
            Class activeClass = GenericsUtils.asClass((Type)activeType);
            if (callbacks.isEmpty()) {
                this.navMethod = this.getRootMethod;
            } else {
                this.navMethod = this.plasticClass.introducePrivateMethod(PlasticUtils.toTypeName((Class)activeClass), "navigate", SINGLE_OBJECT_ARGUMENT, null);
                this.navMethod.changeImplementation(new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().loadArgument(0).invokeVirtual(PropertyConduitBuilder.this.getRootMethod);
                        for (InstructionBuilderCallback callback : callbacks) {
                            callback.doBuild(builder);
                        }
                        builder.returnResult();
                    }
                });
            }
            this.implementAccessors(activeType, node);
        }

        private void implementAccessors(Type activeType, Tree node) {
            switch (node.getType()) {
                case 16: {
                    this.implementPropertyAccessors(activeType, node);
                    return;
                }
                case 43: {
                    this.implementMethodAccessors(activeType, node);
                    return;
                }
                case 30: {
                    this.implementRangeOpGetter(node);
                    this.implementNoOpSetter();
                    this.conduitPropertyType = IntegerRange.class;
                    this.conduitPropertyGenericType = IntegerRange.class;
                    return;
                }
                case 44: {
                    this.implementListGetter(node);
                    this.implementNoOpSetter();
                    this.conduitPropertyType = List.class;
                    this.conduitPropertyGenericType = List.class;
                    return;
                }
                case 45: {
                    this.implementMapGetter(node);
                    this.implementNoOpSetter();
                    this.conduitPropertyType = Map.class;
                    this.conduitPropertyGenericType = Map.class;
                    return;
                }
                case 46: {
                    this.implementNotOpGetter(node);
                    this.implementNoOpSetter();
                    this.conduitPropertyType = Boolean.TYPE;
                    this.conduitPropertyGenericType = Boolean.TYPE;
                    return;
                }
            }
            throw this.unexpectedNodeType(node, 16, 43, 30, 44, 46);
        }

        public void implementMethodAccessors(Type activeType, Tree invokeNode) {
            final Term term = this.buildInvokeTerm(activeType, invokeNode);
            this.implementNoOpSetter();
            this.conduitPropertyName = term.description;
            this.conduitPropertyType = term.genericType;
            this.conduitPropertyGenericType = term.genericType;
            this.annotationProvider = term.annotationProvider;
            this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.invokeNavigateMethod(builder);
                    term.callback.doBuild(builder);
                    PropertyConduitBuilder.this.boxIfPrimitive(builder, PropertyConduitBuilder.this.conduitPropertyType);
                    builder.returnResult();
                }
            });
            this.implementNoOpSetter();
        }

        public void implementPropertyAccessors(Type activeType, Tree identifierNode) {
            String propertyName = identifierNode.getText();
            PropertyAdapter adapter = this.findPropertyAdapter(activeType, propertyName);
            this.conduitPropertyName = propertyName;
            this.conduitPropertyType = adapter.getType();
            this.conduitPropertyGenericType = this.getGenericType(adapter);
            this.annotationProvider = adapter;
            this.implementGetter(adapter);
            this.implementSetter(adapter);
        }

        private Type getGenericType(PropertyAdapter adapter) {
            Type genericType = null;
            if (adapter.getField() != null) {
                genericType = adapter.getField().getGenericType();
            } else if (adapter.getReadMethod() != null) {
                genericType = adapter.getReadMethod().getGenericReturnType();
            } else if (adapter.getWriteMethod() != null) {
                genericType = adapter.getWriteMethod().getGenericParameterTypes()[0];
            } else {
                throw new RuntimeException("Could not find accessor for property " + adapter.getName());
            }
            return genericType == null ? adapter.getType() : genericType;
        }

        private void implementSetter(PropertyAdapter adapter) {
            if (adapter.getWriteMethod() != null) {
                this.implementSetter(adapter.getWriteMethod());
                return;
            }
            if (adapter.getField() != null && adapter.isUpdate()) {
                this.implementSetter(adapter.getField());
                return;
            }
            this.implementNoOpMethod(ConduitMethods.SET, "Expression '%s' for class %s is read-only.", this.expression, this.rootType.getName());
        }

        private boolean isStatic(Member member) {
            return Modifier.isStatic(member.getModifiers());
        }

        private void implementSetter(final Field field) {
            if (this.isStatic(field)) {
                this.plasticClass.introduceMethod(ConduitMethods.SET, new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadArgument(1).castOrUnbox(PlasticUtils.toTypeName(field.getType()));
                        builder.putStaticField(field.getDeclaringClass().getName(), field.getName(), field.getType());
                        builder.returnResult();
                    }
                });
                return;
            }
            this.plasticClass.introduceMethod(ConduitMethods.SET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.invokeNavigateMethod(builder);
                    builder.loadArgument(1).castOrUnbox(PlasticUtils.toTypeName(field.getType()));
                    builder.putField(field.getDeclaringClass().getName(), field.getName(), field.getType());
                    builder.returnResult();
                }
            });
        }

        private void implementSetter(final Method writeMethod) {
            this.plasticClass.introduceMethod(ConduitMethods.SET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.invokeNavigateMethod(builder);
                    Class<?> propertyType = writeMethod.getParameterTypes()[0];
                    String propertyTypeName = PlasticUtils.toTypeName(propertyType);
                    builder.loadArgument(1).castOrUnbox(propertyTypeName);
                    builder.invoke(writeMethod);
                    builder.returnResult();
                }
            });
        }

        private void implementGetter(PropertyAdapter adapter) {
            if (adapter.getReadMethod() != null) {
                this.implementGetter(adapter.getReadMethod());
                return;
            }
            if (adapter.getField() != null) {
                this.implementGetter(adapter.getField());
                return;
            }
            this.implementNoOpMethod(ConduitMethods.GET, "Expression '%s' for class %s is write-only.", this.expression, this.rootType.getName());
        }

        private void implementGetter(final Field field) {
            if (this.isStatic(field)) {
                this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.getStaticField(field.getDeclaringClass().getName(), field.getName(), field.getType());
                        PropertyConduitBuilder.this.boxIfPrimitive(builder, field.getType());
                        builder.returnResult();
                    }
                });
                return;
            }
            this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.invokeNavigateMethod(builder);
                    builder.getField(field.getDeclaringClass().getName(), field.getName(), field.getType());
                    PropertyConduitBuilder.this.boxIfPrimitive(builder, field.getType());
                    builder.returnResult();
                }
            });
        }

        private void implementGetter(final Method readMethod) {
            this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.invokeNavigateMethod(builder);
                    PropertyConduitBuilder.this.invokeMethod(builder, readMethod, null, 0);
                    PropertyConduitBuilder.this.boxIfPrimitive(builder, PropertyConduitBuilder.this.conduitPropertyType);
                    builder.returnResult();
                }
            });
        }

        private void implementRangeOpGetter(final Tree rangeNode) {
            this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.loadThis().getField(PropertyConduitBuilder.this.getDelegateField());
                    PropertyConduitBuilder.this.invokeMethod(builder, DelegateMethods.RANGE, rangeNode, 0);
                    builder.returnResult();
                }
            });
        }

        private void implementNotOpGetter(final Tree node) {
            this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    Class expressionType = PropertyConduitBuilder.this.implementNotExpression(builder, node);
                    PropertyConduitBuilder.this.boxIfPrimitive(builder, (Type)expressionType);
                    builder.returnResult();
                }
            });
        }

        private void invokeNavigateMethod(InstructionBuilder builder) {
            builder.loadThis().loadArgument(0).invokeVirtual(this.navMethod);
            builder.dupe().when(Condition.NULL, RETURN_NULL);
        }

        private Type implementSubexpression(InstructionBuilder builder, Type activeType, Tree node) {
            block13: while (true) {
                switch (node.getType()) {
                    case 16: 
                    case 43: {
                        if (activeType == null) {
                            this.invokeGetRootMethod(builder);
                            activeType = this.rootType;
                        }
                        Term term = this.buildTerm(activeType, node);
                        term.callback.doBuild(builder);
                        return term.type;
                    }
                    case 17: {
                        builder.loadConstant((Object)new Long(node.getText()));
                        return Long.TYPE;
                    }
                    case 8: {
                        builder.loadConstant((Object)new Double(node.getText()));
                        return Double.TYPE;
                    }
                    case 37: {
                        builder.loadConstant((Object)node.getText());
                        return String.class;
                    }
                    case 9: 
                    case 35: {
                        if (activeType == null) {
                            this.invokeGetRootMethod(builder);
                            activeType = this.rootType;
                        }
                        Term term = this.analyzeDerefNode(activeType, node);
                        term.callback.doBuild(builder);
                        activeType = GenericsUtils.asClass((Type)term.type);
                        node = node.getChild(1);
                        continue block13;
                    }
                    case 13: 
                    case 40: {
                        builder.loadConstant((Object)(node.getType() == 40 ? 1 : 0));
                        return Boolean.TYPE;
                    }
                    case 44: {
                        return this.implementListConstructor(builder, node);
                    }
                    case 45: {
                        return this.implementMapConstructor(builder, node);
                    }
                    case 46: {
                        return this.implementNotExpression(builder, node);
                    }
                    case 39: {
                        this.invokeGetRootMethod(builder);
                        return this.rootType;
                    }
                    case 26: {
                        builder.loadNull();
                        return Void.class;
                    }
                }
                break;
            }
            throw this.unexpectedNodeType(node, 40, 13, 17, 8, 37, 9, 35, 16, 43, 44, 46, 39, 26);
        }

        public void invokeGetRootMethod(InstructionBuilder builder) {
            builder.loadThis().loadArgument(0).invokeVirtual(this.getRootMethod);
        }

        private void implementListGetter(final Tree listNode) {
            this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.implementListConstructor(builder, listNode);
                    builder.returnResult();
                }
            });
        }

        private Type implementListConstructor(InstructionBuilder builder, Tree listNode) {
            int count = listNode.getChildCount();
            builder.newInstance(ArrayList.class);
            builder.dupe().loadConstant((Object)count).invokeConstructor(ArrayList.class, new Class[]{Integer.TYPE});
            for (int i = 0; i < count; ++i) {
                builder.dupe();
                Type expressionType = this.implementSubexpression(builder, null, listNode.getChild(i));
                this.boxIfPrimitive(builder, GenericsUtils.asClass((Type)expressionType));
                builder.invoke(ArrayListMethods.ADD).pop();
            }
            return ArrayList.class;
        }

        private void implementMapGetter(final Tree mapNode) {
            this.plasticClass.introduceMethod(ConduitMethods.GET, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.implementMapConstructor(builder, mapNode);
                    builder.returnResult();
                }
            });
        }

        private Type implementMapConstructor(InstructionBuilder builder, Tree mapNode) {
            int count = mapNode.getChildCount();
            builder.newInstance(HashMap.class);
            builder.dupe().loadConstant((Object)count).invokeConstructor(HashMap.class, new Class[]{Integer.TYPE});
            for (int i = 0; i < count; i += 2) {
                builder.dupe();
                Type keyType = this.implementSubexpression(builder, null, mapNode.getChild(i));
                this.boxIfPrimitive(builder, GenericsUtils.asClass((Type)keyType));
                Type valueType = this.implementSubexpression(builder, null, mapNode.getChild(i + 1));
                this.boxIfPrimitive(builder, GenericsUtils.asClass((Type)valueType));
                builder.invoke(HashMapMethods.PUT).pop();
            }
            return HashMap.class;
        }

        private void implementNoOpSetter() {
            this.implementNoOpMethod(ConduitMethods.SET, "Expression '%s' for class %s is read-only.", this.expression, this.rootType.getName());
        }

        public void implementNoOpMethod(MethodDescription method, String format, Object ... arguments) {
            final String message = String.format(format, arguments);
            this.plasticClass.introduceMethod(method).changeImplementation(new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    builder.throwException(RuntimeException.class, message);
                }
            });
        }

        private void invokeMethod(InstructionBuilder builder, Method method, Tree node, int childOffset) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                Type expressionType = this.implementSubexpression(builder, null, node.getChild(i + childOffset));
                if (parameterType.isAssignableFrom(GenericsUtils.asClass((Type)expressionType))) continue;
                this.boxIfPrimitive(builder, expressionType);
                builder.loadThis().getField(this.getDelegateField());
                builder.swap().loadTypeConstant(PlasticUtils.toWrapperType(parameterType));
                builder.invoke(DelegateMethods.COERCE);
                if (parameterType.isPrimitive()) {
                    builder.castOrUnbox(parameterType.getName());
                    continue;
                }
                builder.checkcast(parameterType);
            }
            builder.invoke(method.getDeclaringClass(), method.getReturnType(), method.getName(), (Class[])method.getParameterTypes());
        }

        private Term analyzeDerefNode(Type activeType, Tree node) {
            Tree term = node.getChild(0);
            boolean allowNull = node.getType() == 35;
            return this.buildTerm(activeType, term, allowNull ? NullHandling.ALLOW : NullHandling.FORBID);
        }

        private Term buildTerm(Type activeType, Tree term, final NullHandling nullHandling) {
            this.assertNodeType(term, 16, 43);
            final Term simpleTerm = this.buildTerm(activeType, term);
            if (simpleTerm.genericType.isPrimitive()) {
                return simpleTerm;
            }
            return simpleTerm.withCallback(new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    simpleTerm.callback.doBuild(builder);
                    builder.dupe().when(Condition.NULL, new InstructionBuilderCallback(){

                        public void doBuild(InstructionBuilder builder) {
                            switch (nullHandling) {
                                case ALLOW: {
                                    builder.loadNull().returnResult();
                                }
                                case FORBID: {
                                    builder.loadConstant((Object)simpleTerm.description);
                                    builder.loadConstant((Object)PropertyConduitBuilder.this.expression);
                                    builder.loadArgument(0);
                                    builder.invokeStatic(PropertyConduitSourceImpl.class, NullPointerException.class, "nullTerm", new Class[]{String.class, String.class, Object.class});
                                    builder.throwException();
                                }
                            }
                        }
                    });
                }
            });
        }

        private void assertNodeType(Tree node, int ... expected) {
            int type = node.getType();
            for (int e : expected) {
                if (type != e) continue;
                return;
            }
            throw this.unexpectedNodeType(node, expected);
        }

        private RuntimeException unexpectedNodeType(Tree node, int ... expected) {
            List tokenNames = CollectionFactory.newList();
            for (int i = 0; i < expected.length; ++i) {
                tokenNames.add(PropertyExpressionParser.tokenNames[expected[i]]);
            }
            String message = String.format("Node %s was type %s, but was expected to be (one of) %s.", node.toStringTree(), PropertyExpressionParser.tokenNames[node.getType()], InternalCommonsUtils.joinSorted((Collection)tokenNames));
            return new RuntimeException(message);
        }

        private Term buildTerm(Type activeType, Tree termNode) {
            switch (termNode.getType()) {
                case 43: {
                    return this.buildInvokeTerm(activeType, termNode);
                }
                case 16: {
                    return this.buildPropertyAccessTerm(activeType, termNode);
                }
            }
            throw this.unexpectedNodeType(termNode, 43, 16);
        }

        private Term buildPropertyAccessTerm(Type activeType, Tree termNode) {
            String propertyName = termNode.getText();
            PropertyAdapter adapter = this.findPropertyAdapter(activeType, propertyName);
            if (adapter.getReadMethod() != null) {
                return this.buildGetterMethodAccessTerm(activeType, propertyName, adapter.getReadMethod());
            }
            if (adapter.getField() != null) {
                return this.buildPublicFieldAccessTerm(activeType, propertyName, adapter.getField());
            }
            throw new RuntimeException(String.format("Property '%s' of class %s is not readable (it has no read accessor method).", adapter.getName(), adapter.getBeanType().getName()));
        }

        public PropertyAdapter findPropertyAdapter(Type activeType, String propertyName) {
            Class activeClass = GenericsUtils.asClass((Type)activeType);
            ClassPropertyAdapter classAdapter = PropertyConduitSourceImpl.this.access.getAdapter(activeClass);
            PropertyAdapter adapter = classAdapter.getPropertyAdapter(propertyName);
            if (adapter == null) {
                List names = classAdapter.getPropertyNames();
                String className = activeClass.getName();
                throw new UnknownValueException(String.format("Class %s does not contain a property (or public field) named '%s'.", className, propertyName), new AvailableValues("Properties (and public fields)", (Collection)names));
            }
            return adapter;
        }

        private Term buildGetterMethodAccessTerm(final Type activeType, String propertyName, final Method readMethod) {
            Type returnType = GenericsUtils.extractActualType((Type)activeType, (Method)readMethod);
            return new Term(returnType, propertyName, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.invokeMethod(builder, readMethod, null, 0);
                    Type genericType = GenericsUtils.extractActualType((Type)activeType, (Method)readMethod);
                    PropertyConduitBuilder.this.castToGenericType(builder, readMethod.getReturnType(), genericType);
                }
            });
        }

        private Term buildPublicFieldAccessTerm(Type activeType, String propertyName, final Field field) {
            final Type fieldType = GenericsUtils.extractActualType((Type)activeType, (Field)field);
            return new Term(fieldType, propertyName, new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    Class<?> rawFieldType = field.getType();
                    String rawTypeName = PlasticUtils.toTypeName(rawFieldType);
                    String containingClassName = field.getDeclaringClass().getName();
                    String fieldName = field.getName();
                    if (PropertyConduitBuilder.this.isStatic(field)) {
                        builder.pop();
                        builder.getStaticField(containingClassName, fieldName, rawTypeName);
                    } else {
                        builder.getField(containingClassName, fieldName, rawTypeName);
                    }
                    PropertyConduitBuilder.this.castToGenericType(builder, rawFieldType, fieldType);
                }
            });
        }

        private void castToGenericType(InstructionBuilder builder, Class rawType, Type genericType) {
            if (!genericType.equals(rawType)) {
                Class castType = GenericsUtils.asClass((Type)genericType);
                builder.checkcast(castType);
            }
        }

        private Term buildInvokeTerm(final Type activeType, final Tree invokeNode) {
            String methodName = invokeNode.getChild(0).getText();
            int parameterCount = invokeNode.getChildCount() - 1;
            Class activeClass = GenericsUtils.asClass((Type)activeType);
            final Method method = this.findMethod(activeClass, methodName, parameterCount);
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new RuntimeException(String.format("Method %s.%s() returns void.", activeClass.getName(), methodName));
            }
            Type returnType = GenericsUtils.extractActualType((Type)activeType, (Method)method);
            return new Term(returnType, PropertyConduitSourceImpl.toUniqueId(method), InternalCommonsUtils.toAnnotationProvider((Method)method), new InstructionBuilderCallback(){

                public void doBuild(InstructionBuilder builder) {
                    PropertyConduitBuilder.this.invokeMethod(builder, method, invokeNode, 1);
                    Type genericType = GenericsUtils.extractActualType((Type)activeType, (Method)method);
                    PropertyConduitBuilder.this.castToGenericType(builder, method.getReturnType(), genericType);
                }
            });
        }

        private Method findMethod(Class activeType, String methodName, int parameterCount) {
            Class<Object> searchType = activeType;
            while (true) {
                for (Method method : searchType.getMethods()) {
                    if (method.getParameterTypes().length != parameterCount || !method.getName().equalsIgnoreCase(methodName)) continue;
                    return method;
                }
                if (searchType == Object.class) break;
                searchType = Object.class;
            }
            throw new RuntimeException(String.format("Class %s does not contain a public method named '%s()'.", activeType.getName(), methodName));
        }

        public void boxIfPrimitive(InstructionBuilder builder, Type termType) {
            this.boxIfPrimitive(builder, GenericsUtils.asClass((Type)termType));
        }

        public void boxIfPrimitive(InstructionBuilder builder, Class termType) {
            if (termType.isPrimitive()) {
                builder.boxPrimitive(termType.getName());
            }
        }

        public Class implementNotExpression(InstructionBuilder builder, Tree notNode) {
            Type expressionType = this.implementSubexpression(builder, null, notNode.getChild(0));
            this.boxIfPrimitive(builder, expressionType);
            builder.loadThis().getField(this.getDelegateField());
            builder.swap().invoke(DelegateMethods.INVERT);
            return Boolean.TYPE;
        }

        private PlasticField getDelegateField() {
            if (this.delegateField == null) {
                this.delegateField = this.plasticClass.introduceField(PropertyConduitDelegate.class, "delegate").inject((Object)PropertyConduitSourceImpl.this.sharedDelegate);
            }
            return this.delegateField;
        }
    }

    private class Term {
        final Type type;
        final Class genericType;
        final String description;
        final AnnotationProvider annotationProvider;
        final InstructionBuilderCallback callback;

        Term(Type type, Class genericType, String description, AnnotationProvider annotationProvider, InstructionBuilderCallback callback) {
            this.type = type;
            this.genericType = genericType;
            this.description = description;
            this.annotationProvider = annotationProvider;
            this.callback = callback;
        }

        Term(Type type, String description, AnnotationProvider annotationProvider, InstructionBuilderCallback callback) {
            this(type, GenericsUtils.asClass((Type)type), description, annotationProvider, callback);
        }

        Term(Type type, String description, InstructionBuilderCallback callback) {
            this(type, description, null, callback);
        }

        Term withCallback(InstructionBuilderCallback newCallback) {
            return new Term(this.type, this.genericType, this.description, this.annotationProvider, newCallback);
        }
    }

    private static enum NullHandling {
        FORBID,
        ALLOW;

    }

    static class HashMapMethods {
        static final Method PUT = PropertyConduitSourceImpl.access$100(HashMap.class, "put", new Class[]{Object.class, Object.class});

        HashMapMethods() {
        }
    }

    static class ArrayListMethods {
        static final Method ADD = PropertyConduitSourceImpl.access$100(ArrayList.class, "add", new Class[]{Object.class});

        ArrayListMethods() {
        }
    }

    static class DelegateMethods {
        static final Method INVERT = PropertyConduitSourceImpl.access$100(PropertyConduitDelegate.class, "invert", new Class[]{Object.class});
        static final Method RANGE = PropertyConduitSourceImpl.access$100(PropertyConduitDelegate.class, "range", new Class[]{Integer.TYPE, Integer.TYPE});
        static final Method COERCE = PropertyConduitSourceImpl.access$100(PropertyConduitDelegate.class, "coerce", new Class[]{Object.class, Class.class});

        DelegateMethods() {
        }
    }

    static class ConduitMethods {
        private static final MethodDescription GET = PropertyConduitSourceImpl.access$000(PropertyConduit.class, "get", new Class[]{Object.class});
        private static final MethodDescription SET = PropertyConduitSourceImpl.access$000(PropertyConduit.class, "set", new Class[]{Object.class, Object.class});
        private static final MethodDescription GET_PROPERTY_TYPE = PropertyConduitSourceImpl.access$000(PropertyConduit.class, "getPropertyType", new Class[0]);
        private static final MethodDescription GET_PROPERTY_GENERIC_TYPE = PropertyConduitSourceImpl.access$000(PropertyConduit2.class, "getPropertyGenericType", new Class[0]);
        private static final MethodDescription GET_PROPERTY_NAME = PropertyConduitSourceImpl.access$000(InternalPropertyConduit.class, "getPropertyName", new Class[0]);
        private static final MethodDescription GET_ANNOTATION = PropertyConduitSourceImpl.access$000(AnnotationProvider.class, "getAnnotation", new Class[]{Class.class});

        ConduitMethods() {
        }
    }
}

