/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.upload.components;

import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.corelib.mixins.RenderDisabled;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Upload
extends AbstractField {
    public static final String MULTIPART_ENCTYPE = "multipart/form-data";
    @Parameter(required=true, principal=true, autoconnect=true)
    private UploadedFile value;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private MultipartDecoder decoder;
    @Environmental
    private FormSupport formSupport;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private ComponentResources resources;
    @Inject
    private Locale locale;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    @Mixin
    private RenderDisabled renderDisabled;
    @Inject
    @Path(value="upload.js")
    private Asset uploadScript;
    @Inject
    private Request request;
    @Environmental
    private JavaScriptSupport javaScriptSupport;

    final Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("value", this.resources);
    }

    public Upload() {
    }

    Upload(UploadedFile value, FieldValidator<Object> validate, MultipartDecoder decoder, ValidationTracker tracker, ComponentResources resources, FieldValidationSupport fieldValidationSupport) {
        this.value = value;
        if (validate != null) {
            this.validate = validate;
        }
        this.decoder = decoder;
        this.tracker = tracker;
        this.resources = resources;
        this.fieldValidationSupport = fieldValidationSupport;
    }

    protected void processSubmission(String controlName) {
        UploadedFile uploaded = this.decoder.getFileUpload(controlName);
        if (uploaded != null && (uploaded.getFileName() == null || uploaded.getFileName().length() == 0)) {
            uploaded = null;
        }
        try {
            this.fieldValidationSupport.validate((Object)uploaded, this.resources, this.validate);
        }
        catch (ValidationException ex) {
            this.tracker.recordError((Field)this, ex.getMessage());
        }
        this.value = uploaded;
    }

    protected void beginRender(MarkupWriter writer) {
        this.formSupport.setEncodingType(MULTIPART_ENCTYPE);
        writer.element("input", new Object[]{"type", "file", "name", this.getControlName(), "id", this.getClientId()});
        this.validate.render(writer);
        this.resources.renderInformalParameters(writer);
        this.decorateInsideField();
        if (this.request.isXHR()) {
            this.javaScriptSupport.importJavaScriptLibrary(this.uploadScript);
            this.javaScriptSupport.addInitializerCall("injectedUpload", this.getClientId());
        }
    }

    public void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public UploadedFile getValue() {
        return this.value;
    }

    Upload injectDecorator(ValidationDecorator decorator) {
        this.setDecorator(decorator);
        return this;
    }

    Upload injectRequest(Request request) {
        this.request = request;
        return this;
    }

    Upload injectFormSupport(FormSupport formSupport) {
        this.formSupport = formSupport;
        this.setFormSupport(formSupport);
        return this;
    }

    Upload injectFieldValidator(FieldValidator<Object> validator) {
        this.validate = validator;
        return this;
    }
}

