/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.buf.Asn1Parser;
import org.apache.tomcat.util.buf.Asn1Writer;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.res.StringManager;

public class PEMFile {
    private static final StringManager sm = StringManager.getManager(PEMFile.class);
    private static final byte[] OID_EC_PUBLIC_KEY = new byte[]{6, 7, 42, -122, 72, -50, 61, 2, 1};
    private static final String PBES2 = "PBES2";
    private List<X509Certificate> certificates = new ArrayList<X509Certificate>();
    private PrivateKey privateKey;

    public static String toPEM(X509Certificate certificate) throws CertificateEncodingException {
        StringBuilder result = new StringBuilder();
        result.append("-----BEGIN CERTIFICATE-----");
        result.append(System.lineSeparator());
        Base64 b64 = new Base64(64);
        result.append(b64.encodeAsString(certificate.getEncoded()));
        result.append("-----END CERTIFICATE-----");
        return result.toString();
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PEMFile(String filename) throws IOException, GeneralSecurityException {
        this(filename, null);
    }

    public PEMFile(String filename, String password) throws IOException, GeneralSecurityException {
        this(filename, password, null);
    }

    public PEMFile(String filename, String password, String keyAlgorithm) throws IOException, GeneralSecurityException {
        this(filename, ConfigFileLoader.getSource().getResource(filename).getInputStream(), password, keyAlgorithm);
    }

    public PEMFile(String filename, InputStream fileStream, String password, String keyAlgorithm) throws IOException, GeneralSecurityException {
        ArrayList<Part> parts = new ArrayList<Part>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.US_ASCII));){
            String line;
            Part part = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("-----BEGIN ")) {
                    part = new Part(this);
                    part.type = line.substring("-----BEGIN ".length(), line.length() - "-----".length()).trim();
                    continue;
                }
                if (line.startsWith("-----END ")) {
                    parts.add(part);
                    part = null;
                    continue;
                }
                if (part != null && !line.contains(":") && !line.startsWith(" ")) {
                    part.content = part.content + line;
                    continue;
                }
                if (part == null || !line.contains(":") || line.startsWith(" ") || !line.startsWith("DEK-Info: ")) continue;
                String[] pieces = line.split(" ");
                if ((pieces = pieces[1].split(",")).length != 2) continue;
                part.algorithm = pieces[0];
                part.ivHex = pieces[1];
            }
        }
        for (Part part : parts) {
            switch (part.type) {
                case "PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(null, keyAlgorithm, Format.PKCS8, filename);
                    break;
                }
                case "EC PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(null, "EC", Format.RFC5915, filename);
                    break;
                }
                case "ENCRYPTED PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(password, keyAlgorithm, Format.PKCS8, filename);
                    break;
                }
                case "RSA PRIVATE KEY": {
                    if (part.algorithm == null) {
                        this.privateKey = part.toPrivateKey(null, keyAlgorithm, Format.PKCS1, filename);
                        break;
                    }
                    this.privateKey = part.toPrivateKey(password, keyAlgorithm, Format.PKCS1, filename);
                    break;
                }
                case "CERTIFICATE": 
                case "X509 CERTIFICATE": {
                    this.certificates.add(part.toCertificate());
                }
            }
        }
    }

    private class Part {
        public static final String BEGIN_BOUNDARY = "-----BEGIN ";
        public static final String END_BOUNDARY = "-----END ";
        public static final String FINISH_BOUNDARY = "-----";
        public static final String PRIVATE_KEY = "PRIVATE KEY";
        public static final String EC_PRIVATE_KEY = "EC PRIVATE KEY";
        public static final String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
        public static final String RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
        public static final String CERTIFICATE = "CERTIFICATE";
        public static final String X509_CERTIFICATE = "X509 CERTIFICATE";
        public String type;
        public String content = "";
        public String algorithm = null;
        public String ivHex = null;

        private Part(PEMFile pEMFile) {
        }

        private byte[] decode() {
            return Base64.decodeBase64((String)this.content);
        }

        public X509Certificate toCertificate() throws CertificateException {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(this.decode()));
        }

        public PrivateKey toPrivateKey(String password, String keyAlgorithm, Format format, String filename) throws GeneralSecurityException, IOException {
            KeySpec keySpec = null;
            if (password == null) {
                switch (format.ordinal()) {
                    case 0: {
                        keySpec = this.parsePKCS1(this.decode());
                        break;
                    }
                    case 1: {
                        keySpec = new PKCS8EncodedKeySpec(this.decode());
                        break;
                    }
                    case 2: {
                        keySpec = new PKCS8EncodedKeySpec(this.rfc5915ToPkcs8(this.decode()));
                    }
                }
            } else if (this.algorithm == null) {
                EncryptedPrivateKeyInfo privateKeyInfo = new EncryptedPrivateKeyInfo(this.decode());
                String pbeAlgorithm = this.getPBEAlgorithm(privateKeyInfo);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(pbeAlgorithm);
                Object secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(password.toCharArray()));
                Cipher cipher = Cipher.getInstance(pbeAlgorithm);
                cipher.init(2, (Key)secretKey, privateKeyInfo.getAlgParameters());
                keySpec = privateKeyInfo.getKeySpec(cipher);
            } else {
                String[] cipherTransformation;
                String secretKeyAlgorithm;
                int keyLength = switch (this.algorithm) {
                    case "DES-CBC" -> {
                        secretKeyAlgorithm = "DES";
                        cipherTransformation = "DES/CBC/PKCS5Padding";
                        yield 8;
                    }
                    case "DES-EDE3-CBC" -> {
                        secretKeyAlgorithm = "DESede";
                        cipherTransformation = "DESede/CBC/PKCS5Padding";
                        yield 24;
                    }
                    case "AES-256-CBC" -> {
                        secretKeyAlgorithm = "AES";
                        cipherTransformation = "AES/CBC/PKCS5Padding";
                        yield 32;
                    }
                    default -> {
                        secretKeyAlgorithm = this.algorithm;
                        cipherTransformation = this.algorithm;
                        yield 8;
                    }
                };
                byte[] iv = this.fromHex(this.ivHex);
                byte[] key = this.deriveKey(keyLength, password, iv);
                SecretKeySpec secretKey = new SecretKeySpec(key, secretKeyAlgorithm);
                Cipher cipher = Cipher.getInstance((String)cipherTransformation);
                cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
                byte[] pkcs1 = cipher.doFinal(this.decode());
                keySpec = this.parsePKCS1(pkcs1);
            }
            InvalidKeyException exception = new InvalidKeyException(sm.getString("pemFile.parseError", new Object[]{filename}));
            if (keyAlgorithm == null) {
                for (String algorithm : new String[]{"RSA", "DSA", "EC"}) {
                    try {
                        return KeyFactory.getInstance(algorithm).generatePrivate(keySpec);
                    }
                    catch (InvalidKeySpecException e) {
                        exception.addSuppressed(e);
                    }
                }
            } else {
                try {
                    return KeyFactory.getInstance(keyAlgorithm).generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    exception.addSuppressed(e);
                }
            }
            throw exception;
        }

        private String getPBEAlgorithm(EncryptedPrivateKeyInfo privateKeyInfo) {
            AlgorithmParameters parameters = privateKeyInfo.getAlgParameters();
            String algName = privateKeyInfo.getAlgName();
            if (parameters != null && PEMFile.PBES2.equals(algName)) {
                return parameters.toString();
            }
            return privateKeyInfo.getAlgName();
        }

        private byte[] deriveKey(int keyLength, String password, byte[] iv) throws NoSuchAlgorithmException {
            byte[] round;
            byte[] key = new byte[keyLength];
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] pw = password.getBytes(StandardCharsets.UTF_8);
            for (int insertPosition = 0; insertPosition < keyLength; insertPosition += round.length) {
                digest.update(pw);
                digest.update(iv, 0, 8);
                round = digest.digest();
                digest.update(round);
                System.arraycopy(round, 0, key, insertPosition, Math.min(keyLength - insertPosition, round.length));
            }
            return key;
        }

        private byte[] rfc5915ToPkcs8(byte[] source) {
            Asn1Parser p = new Asn1Parser(source);
            p.parseTag(48);
            p.parseFullLength();
            BigInteger version = p.parseInt();
            if (version.intValue() != 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            p.parseTag(4);
            int privateKeyLen = p.parseLength();
            byte[] privateKey = new byte[privateKeyLen];
            p.parseBytes(privateKey);
            p.parseTag(160);
            int oidLen = p.parseLength();
            byte[] oid = new byte[oidLen];
            p.parseBytes(oid);
            if (oid[0] != 6) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            p.parseTag(161);
            int publicKeyLen = p.parseLength();
            byte[] publicKey = new byte[publicKeyLen];
            p.parseBytes(publicKey);
            if (publicKey[0] != 3) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            return Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)0), Asn1Writer.writeSequence((byte[][])new byte[][]{OID_EC_PUBLIC_KEY, oid}), Asn1Writer.writeOctetString((byte[])Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)1), Asn1Writer.writeOctetString((byte[])privateKey), Asn1Writer.writeTag((byte)-95, (byte[])publicKey)}))});
        }

        private RSAPrivateCrtKeySpec parsePKCS1(byte[] source) {
            Asn1Parser p = new Asn1Parser(source);
            p.parseTag(48);
            p.parseFullLength();
            BigInteger version = p.parseInt();
            if (version.intValue() == 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.noMultiPrimes"));
            }
            return new RSAPrivateCrtKeySpec(p.parseInt(), p.parseInt(), p.parseInt(), p.parseInt(), p.parseInt(), p.parseInt(), p.parseInt(), p.parseInt());
        }

        private byte[] fromHex(String hexString) {
            byte[] bytes = new byte[hexString.length() / 2];
            for (int i = 0; i < hexString.length(); i += 2) {
                bytes[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
            }
            return bytes;
        }
    }

    private static enum Format {
        PKCS1,
        PKCS8,
        RFC5915;

    }
}

