/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalAprInputBuffer;
import org.apache.coyote.http11.InternalAprOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProcessor
extends AbstractHttp11Processor<Long> {
    private static final Log log = LogFactory.getLog(Http11AprProcessor.class);
    protected AprEndpoint.SendfileData sendfileData = null;
    protected SocketWrapper<Long> socket = null;
    protected String clientCertProvider = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11AprProcessor(int headerBufferSize, AprEndpoint endpoint, int maxTrailerSize) {
        super(endpoint);
        this.inputBuffer = new InternalAprInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalAprOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize);
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.error = !this.getAdapter().event(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.getAdapter().log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error || status == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (!this.endpoint.isPaused()) {
            return true;
        }
        this.response.setStatus(503);
        this.getAdapter().log(this.request, this.response, 0L);
        this.error = true;
        return false;
    }

    @Override
    protected void setSocketTimeout(int timeout) {
        Socket.timeoutSet((long)this.socket.getSocket(), (long)(timeout * 1000));
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Long> socketWrapper) {
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Long> socketWrapper) {
        this.openSocket = this.keepAlive;
        if (this.sendfileData != null && !this.error) {
            this.sendfileData.socket = socketWrapper.getSocket();
            this.sendfileData.keepAlive = this.keepAlive;
            if (!((AprEndpoint)this.endpoint).getSendfile().add(this.sendfileData)) {
                if (this.sendfileData.socket == 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.sendfile.error"));
                    }
                    this.error = true;
                } else {
                    this.sendfileInProgress = true;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
        ((AprEndpoint)this.endpoint).getPoller().add(this.socket.getSocket(), -1, read, write);
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    public void recycleInternal() {
        this.socket = null;
        this.sendfileData = null;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        block78: {
            long socketRef = this.socket.getSocket();
            if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
                if (socketRef == 0L) {
                    this.request.remoteAddr().recycle();
                } else {
                    if (this.socket.getRemoteAddr() == null) {
                        try {
                            long sa = Address.get((int)1, (long)socketRef);
                            this.socket.setRemoteAddr(Address.getip((long)sa));
                        }
                        catch (Exception e) {
                            log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                        }
                    }
                    this.request.remoteAddr().setString(this.socket.getRemoteAddr());
                }
            } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
                if (socketRef == 0L) {
                    this.request.localName().recycle();
                } else {
                    if (this.socket.getLocalName() == null) {
                        try {
                            long sa = Address.get((int)0, (long)socketRef);
                            this.socket.setLocalName(Address.getnameinfo((long)sa, (int)0));
                        }
                        catch (Exception e) {
                            log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                        }
                    }
                    this.request.localName().setString(this.socket.getLocalName());
                }
            } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
                if (socketRef == 0L) {
                    this.request.remoteHost().recycle();
                } else if (this.socket.getRemoteHost() == null) {
                    try {
                        long sa = Address.get((int)1, (long)socketRef);
                        this.socket.setRemoteHost(Address.getnameinfo((long)sa, (int)0));
                        if (this.socket.getRemoteHost() != null) break block78;
                        if (this.socket.getRemoteAddr() == null) {
                            this.socket.setRemoteAddr(Address.getip((long)sa));
                        }
                        if (this.socket.getRemoteAddr() != null) {
                            this.socket.setRemoteHost(this.socket.getRemoteAddr());
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                    }
                } else {
                    this.request.remoteHost().setString(this.socket.getRemoteHost());
                }
            } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
                if (socketRef == 0L) {
                    this.request.localAddr().recycle();
                } else {
                    if (this.socket.getLocalAddr() == null) {
                        try {
                            long sa = Address.get((int)0, (long)socketRef);
                            this.socket.setLocalAddr(Address.getip((long)sa));
                        }
                        catch (Exception e) {
                            log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                        }
                    }
                    this.request.localAddr().setString(this.socket.getLocalAddr());
                }
            } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
                if (socketRef == 0L) {
                    this.request.setRemotePort(0);
                } else {
                    if (this.socket.getRemotePort() == -1) {
                        try {
                            long sa = Address.get((int)1, (long)socketRef);
                            Sockaddr addr = Address.getInfo((long)sa);
                            this.socket.setRemotePort(addr.port);
                        }
                        catch (Exception e) {
                            log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                        }
                    }
                    this.request.setRemotePort(this.socket.getRemotePort());
                }
            } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
                if (socketRef == 0L) {
                    this.request.setLocalPort(0);
                } else {
                    if (this.socket.getLocalPort() == -1) {
                        try {
                            long sa = Address.get((int)0, (long)socketRef);
                            Sockaddr addr = Address.getInfo((long)sa);
                            this.socket.setLocalPort(addr.port);
                        }
                        catch (Exception e) {
                            log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                        }
                    }
                    this.request.setLocalPort(this.socket.getLocalPort());
                }
            } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
                if (this.endpoint.isSSLEnabled() && socketRef != 0L) {
                    try {
                        Object sslO = SSLSocket.getInfoS((long)socketRef, (int)2);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        int certLength = SSLSocket.getInfoI((long)socketRef, (int)1024);
                        byte[] clientCert = SSLSocket.getInfoB((long)socketRef, (int)263);
                        X509Certificate[] certs = null;
                        if (clientCert != null && certLength > -1) {
                            certs = new X509Certificate[certLength + 1];
                            CertificateFactory cf = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                            certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                            for (int i = 0; i < certLength; ++i) {
                                byte[] data = SSLSocket.getInfoB((long)socketRef, (int)(1024 + i));
                                certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                            }
                        }
                        if (certs != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                        }
                        sslO = SSLSocket.getInfoI((long)socketRef, (int)3);
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        sslO = SSLSocket.getInfoS((long)socketRef, (int)1);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                    }
                }
            } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
                if (this.endpoint.isSSLEnabled() && socketRef != 0L) {
                    InputFilter[] inputFilters = this.inputBuffer.getFilters();
                    ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                    this.inputBuffer.addActiveFilter(inputFilters[3]);
                    try {
                        SSLSocket.setVerify((long)socketRef, (int)2, (int)((AprEndpoint)this.endpoint).getSSLVerifyDepth());
                        if (SSLSocket.renegotiate((long)socketRef) == 0) {
                            int certLength = SSLSocket.getInfoI((long)socketRef, (int)1024);
                            byte[] clientCert = SSLSocket.getInfoB((long)socketRef, (int)263);
                            X509Certificate[] certs = null;
                            if (clientCert != null && certLength > -1) {
                                certs = new X509Certificate[certLength + 1];
                                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                                for (int i = 0; i < certLength; ++i) {
                                    byte[] data = SSLSocket.getInfoB((long)socketRef, (int)(1024 + i));
                                    certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                                }
                            }
                            if (certs != null) {
                                this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                    }
                }
            } else if (actionCode == ActionCode.COMET_BEGIN) {
                this.comet = true;
            } else if (actionCode == ActionCode.COMET_END) {
                this.comet = false;
            } else if (actionCode == ActionCode.COMET_CLOSE) {
                ((AprEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN_READ);
            } else if (actionCode != ActionCode.COMET_SETTIMEOUT) {
                if (actionCode == ActionCode.ASYNC_COMPLETE) {
                    if (this.asyncStateMachine.asyncComplete()) {
                        ((AprEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN_READ);
                    }
                } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
                    if (param == null) {
                        return;
                    }
                    long timeout = (Long)param;
                    this.socket.setTimeout(timeout);
                } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
                    ((AprEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN_READ);
                }
            }
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new AprEndpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.start = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.end = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            return true;
        }
        return false;
    }

    @Override
    protected void setSocketWrapper(SocketWrapper<Long> socketWrapper) {
        this.socket = socketWrapper;
    }

    @Override
    protected AbstractInputBuffer<Long> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Long> getOutputBuffer() {
        return this.outputBuffer;
    }
}

