/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.net.SocketWrapper;

public class AprServletInputStream
extends AbstractServletInputStream {
    private final SocketWrapper<Long> wrapper;
    private final long socket;
    private volatile boolean eagain = false;
    private volatile boolean closed = false;

    public AprServletInputStream(SocketWrapper<Long> wrapper) {
        this.wrapper = wrapper;
        this.socket = wrapper.getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRead(boolean block, byte[] b, int off, int len) throws IOException {
        Lock readLock = this.wrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.wrapper.getBlockingStatusWriteLock();
        boolean readDone = false;
        int result = 0;
        try {
            readLock.lock();
            if (this.wrapper.getBlockingStatus() == block) {
                if (this.closed) {
                    throw new IOException(sm.getString("apr.closed"));
                }
                result = Socket.recv((long)this.socket, (byte[])b, (int)off, (int)len);
                readDone = true;
            }
        }
        finally {
            readLock.unlock();
        }
        if (!readDone) {
            try {
                writeLock.lock();
                this.wrapper.setBlockingStatus(block);
                Socket.optSet((long)this.socket, (int)8, (int)(block ? 0 : 1));
                try {
                    readLock.lock();
                    writeLock.unlock();
                    if (this.closed) {
                        throw new IOException(sm.getString("apr.closed"));
                    }
                    result = Socket.recv((long)this.socket, (byte[])b, (int)off, (int)len);
                }
                finally {
                    readLock.unlock();
                }
            }
            finally {
                if (writeLock.isHeldByCurrentThread()) {
                    writeLock.unlock();
                }
            }
        }
        if (result > 0) {
            this.eagain = false;
            return result;
        }
        if (-result == 120002) {
            this.eagain = true;
            return 0;
        }
        throw new IOException(sm.getString("apr.read.error", new Object[]{-result}));
    }

    @Override
    protected boolean doIsReady() {
        return !this.eagain;
    }

    @Override
    protected void doClose() throws IOException {
        this.closed = true;
    }
}

