/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import org.apache.tomcat.util.res.StringManager;

public class HttpMessages {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.http.res");
    private static String st_200 = null;
    private static String st_302 = null;
    private static String st_400 = null;
    private static String st_404 = null;

    public static String getMessage(int status) {
        switch (status) {
            case 200: {
                if (st_200 == null) {
                    st_200 = sm.getString("sc.200");
                }
                return st_200;
            }
            case 302: {
                if (st_302 == null) {
                    st_302 = sm.getString("sc.302");
                }
                return st_302;
            }
            case 400: {
                if (st_400 == null) {
                    st_400 = sm.getString("sc.400");
                }
                return st_400;
            }
            case 404: {
                if (st_404 == null) {
                    st_404 = sm.getString("sc.404");
                }
                return st_404;
            }
        }
        return sm.getString("sc." + status);
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static boolean isSafeInHttpHeader(String msg) {
        if (msg == null) {
            return true;
        }
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            char c = msg.charAt(i);
            if (' ' <= c && c <= '~' || '\u0080' <= c && c <= '\u00ff' || c == '\t') continue;
            return false;
        }
        return true;
    }
}

