/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import org.apache.coyote.ActionCode;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalNio2InputBuffer;
import org.apache.coyote.http11.InternalNio2OutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Nio2Processor
extends AbstractHttp11Processor<Nio2Channel> {
    private static final Log log = LogFactory.getLog(Http11Nio2Processor.class);
    protected SSLSupport sslSupport;
    protected Nio2Endpoint.SendfileData sendfileData = null;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11Nio2Processor(int maxHttpHeaderSize, Nio2Endpoint endpoint, int maxTrailerSize, int maxExtensionSize) {
        super(endpoint);
        this.inputBuffer = new InternalNio2InputBuffer(this.request, maxHttpHeaderSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalNio2OutputBuffer(this.response, maxHttpHeaderSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize, maxExtensionSize);
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        long soTimeout = this.endpoint.getSoTimeout();
        RequestInfo rp = this.request.getRequestProcessor();
        SocketWrapper attach = this.socketWrapper;
        try {
            rp.setStage(3);
            boolean bl = this.error = !this.getAdapter().event(this.request, this.response, status);
            if (!this.error && attach != null) {
                attach.setComet(this.comet);
                if (this.comet) {
                    Integer comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout");
                    if (comettimeout != null) {
                        attach.setTimeout(comettimeout.longValue());
                    }
                } else if (this.keepAlive) {
                    attach.setTimeout(this.keepAliveTimeout);
                } else {
                    attach.setTimeout(soTimeout);
                }
            }
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.getAdapter().log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error || status == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            if (this.keepAlive) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
        Nio2Endpoint.Nio2SocketWrapper attach = (Nio2Endpoint.Nio2SocketWrapper)this.socketWrapper;
        if (attach == null) {
            return;
        }
        if (read) {
            attach.interestOps(attach.interestOps() | 0x400);
        }
        if (write) {
            attach.interestOps(attach.interestOps() | 0x800);
        }
    }

    @Override
    protected void resetTimeouts() {
        if (!this.error && this.socketWrapper != null && this.asyncStateMachine.isAsyncDispatching()) {
            long soTimeout = this.endpoint.getSoTimeout();
            if (this.keepAlive) {
                this.socketWrapper.setTimeout(this.keepAliveTimeout);
            } else {
                this.socketWrapper.setTimeout(soTimeout);
            }
        }
    }

    @Override
    protected boolean disableKeepAlive() {
        return false;
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (((InternalNio2InputBuffer)this.inputBuffer).getParsingRequestLinePhase() < 1) {
            if (this.socketWrapper.getLastAccess() > -1L || this.keptAlive) {
                this.socketWrapper.setTimeout(this.endpoint.getKeepAliveTimeout());
            }
        } else {
            this.readComplete = false;
            this.socketWrapper.setTimeout(this.endpoint.getSoTimeout());
        }
        if (!this.endpoint.isPaused()) {
            return true;
        }
        this.response.setStatus(503);
        this.getAdapter().log(this.request, this.response, 0L);
        this.error = true;
        return false;
    }

    @Override
    protected void setSocketTimeout(int timeout) throws IOException {
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Nio2Channel> socketWrapper) {
        Nio2Endpoint.Nio2SocketWrapper attach = (Nio2Endpoint.Nio2SocketWrapper)socketWrapper;
        if (attach != null) {
            Integer comettimeout;
            attach.setComet(this.comet);
            if (this.comet && (comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout")) != null) {
                attach.setTimeout(comettimeout.longValue());
            }
        }
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Nio2Channel> socketWrapper) {
        this.openSocket = this.keepAlive;
        if (this.sendfileData != null && !this.error) {
            ((Nio2Endpoint.Nio2SocketWrapper)socketWrapper).setSendfileData(this.sendfileData);
            this.sendfileData.keepAlive = this.keepAlive;
            if (((Nio2Endpoint)this.endpoint).processSendfile((Nio2Endpoint.Nio2SocketWrapper)socketWrapper)) {
                this.sendfileInProgress = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.sendfile.error"));
                }
                this.error = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void recycleInternal() {
        this.socketWrapper = null;
        this.sendfileData = null;
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                this.request.remoteAddr().recycle();
            } else {
                if (this.socketWrapper.getRemoteAddr() == null) {
                    InetAddress inetAddr = null;
                    try {
                        inetAddr = ((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getRemoteAddress()).getAddress();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (inetAddr != null) {
                        this.socketWrapper.setRemoteAddr(inetAddr.getHostAddress());
                    }
                }
                this.request.remoteAddr().setString(this.socketWrapper.getRemoteAddr());
            }
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                this.request.localName().recycle();
            } else {
                if (this.socketWrapper.getLocalName() == null) {
                    InetAddress inetAddr = null;
                    try {
                        inetAddr = ((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getLocalAddress()).getAddress();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (inetAddr != null) {
                        this.socketWrapper.setLocalName(inetAddr.getHostName());
                    }
                }
                this.request.localName().setString(this.socketWrapper.getLocalName());
            }
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                this.request.remoteHost().recycle();
            } else {
                if (this.socketWrapper.getRemoteHost() == null) {
                    InetAddress inetAddr = null;
                    try {
                        inetAddr = ((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getRemoteAddress()).getAddress();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (inetAddr != null) {
                        this.socketWrapper.setRemoteHost(inetAddr.getHostName());
                    }
                    if (this.socketWrapper.getRemoteHost() == null) {
                        if (this.socketWrapper.getRemoteAddr() == null && inetAddr != null) {
                            this.socketWrapper.setRemoteAddr(inetAddr.getHostAddress());
                        }
                        if (this.socketWrapper.getRemoteAddr() != null) {
                            this.socketWrapper.setRemoteHost(this.socketWrapper.getRemoteAddr());
                        }
                    }
                }
                this.request.remoteHost().setString(this.socketWrapper.getRemoteHost());
            }
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                this.request.localAddr().recycle();
            } else {
                if (this.socketWrapper.getLocalAddr() == null) {
                    try {
                        this.socketWrapper.setLocalAddr(((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getLocalAddress()).getAddress().getHostAddress());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.request.localAddr().setString(this.socketWrapper.getLocalAddr());
            }
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                this.request.setRemotePort(0);
            } else {
                if (this.socketWrapper.getRemotePort() == -1) {
                    try {
                        this.socketWrapper.setRemotePort(((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getRemoteAddress()).getPort());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.request.setRemotePort(this.socketWrapper.getRemotePort());
            }
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                this.request.setLocalPort(0);
            } else {
                if (this.socketWrapper.getLocalPort() == -1) {
                    try {
                        this.socketWrapper.setLocalPort(((InetSocketAddress)((Nio2Channel)this.socketWrapper.getSocket()).getIOChannel().getLocalAddress()).getPort());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                this.request.setLocalPort(this.socketWrapper.getLocalPort());
            }
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            try {
                if (this.sslSupport != null) {
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
            }
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.sslSupport != null && this.socketWrapper.getSocket() != null) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                SecureNio2Channel sslChannel = (SecureNio2Channel)this.socketWrapper.getSocket();
                SSLEngine engine = sslChannel.getSslEngine();
                if (!engine.getNeedClientAuth()) {
                    engine.setNeedClientAuth(true);
                    try {
                        sslChannel.rehandshake();
                        this.sslSupport = ((Nio2Endpoint)this.endpoint).getHandler().getSslImplementation().getSSLSupport(engine.getSession());
                    }
                    catch (IOException ioe) {
                        log.warn((Object)sm.getString("http11processor.socket.sslreneg", new Object[]{ioe}));
                    }
                }
                try {
                    Object[] sslO = this.sslSupport.getPeerCertificateChain(false);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.COMET_BEGIN) {
            this.comet = true;
        } else if (actionCode == ActionCode.COMET_END) {
            this.comet = false;
        } else if (actionCode == ActionCode.COMET_CLOSE) {
            if (this.socketWrapper == null || this.socketWrapper.getSocket() == null) {
                return;
            }
            RequestInfo rp = this.request.getRequestProcessor();
            if (rp.getStage() != 3) {
                this.endpoint.processSocket(this.socketWrapper, SocketStatus.OPEN_READ, true);
            }
        } else if (actionCode == ActionCode.COMET_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            if (this.socketWrapper == null) {
                return;
            }
            long timeout = (Long)param;
            RequestInfo rp = this.request.getRequestProcessor();
            if (rp.getStage() != 3) {
                this.socketWrapper.setTimeout(timeout);
            }
        } else if (actionCode == ActionCode.ASYNC_COMPLETE) {
            this.socketWrapper.clearDispatches();
            if (this.asyncStateMachine.asyncComplete()) {
                this.endpoint.processSocket(this.socketWrapper, SocketStatus.OPEN_READ, true);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            if (this.socketWrapper == null) {
                return;
            }
            long timeout = (Long)param;
            this.socketWrapper.setTimeout(timeout);
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            this.endpoint.processSocket(this.socketWrapper, SocketStatus.OPEN_READ, true);
        }
    }

    @Override
    protected void prepareRequestInternal() {
        this.sendfileData = null;
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new Nio2Endpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.pos = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.length = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end") - this.sendfileData.pos;
            return true;
        }
        return false;
    }

    @Override
    protected AbstractInputBuffer<Nio2Channel> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Nio2Channel> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }
}

