/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadPendingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNio2InputBuffer
extends AbstractInputBuffer<Nio2Channel> {
    private static final Log log = LogFactory.getLog(InternalNio2InputBuffer.class);
    private boolean parsingRequestLine;
    private int parsingRequestLinePhase = 0;
    private boolean parsingRequestLineEol = false;
    private int parsingRequestLineStart = 0;
    private int parsingRequestLineQPos = -1;
    private HeaderParsePosition headerParsePos;
    private SocketWrapper<Nio2Channel> socket;
    private final int headerBufferSize;
    private int socketReadBufferSize;
    private CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler;
    protected AbstractEndpoint<Nio2Channel> endpoint = null;
    protected volatile boolean readPending = false;
    protected IOException e = null;
    protected volatile boolean flipped = false;
    private final HeaderParseData headerData = new HeaderParseData();

    public InternalNio2InputBuffer(Request request, int headerBufferSize) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.headerBufferSize = headerBufferSize;
        this.inputStreamInputBuffer = new SocketInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.headerData.recycle();
        this.swallowInput = true;
    }

    @Override
    protected final Log getLog() {
        return log;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.socket = null;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
        this.readPending = false;
        this.flipped = false;
        this.e = null;
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    @Override
    public boolean parseRequestLine(boolean useAvailableDataOnly) throws IOException {
        boolean space;
        if (!this.parsingRequestLine) {
            return true;
        }
        if (this.parsingRequestLinePhase < 2) {
            byte chr = 0;
            do {
                if (this.pos < this.lastValid) continue;
                if (useAvailableDataOnly) {
                    return false;
                }
                if (this.fill(false)) continue;
                this.parsingRequestLinePhase = 1;
                return false;
            } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
            --this.pos;
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 2;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received [" + new String(this.buf, this.pos, this.lastValid - this.pos, StandardCharsets.ISO_8859_1) + "]"));
            }
        }
        if (this.parsingRequestLinePhase == 2) {
            space = false;
            while (!space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                    throw new IllegalArgumentException(sm.getString("iib.invalidmethod"));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space = true;
                    this.request.method().setBytes(this.buf, this.parsingRequestLineStart, this.pos - this.parsingRequestLineStart);
                }
                ++this.pos;
            }
            this.parsingRequestLinePhase = 3;
        }
        if (this.parsingRequestLinePhase == 3) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 4;
        }
        if (this.parsingRequestLinePhase == 4) {
            int end = 0;
            boolean space2 = false;
            while (!space2) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space2 = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                    this.parsingRequestLineEol = true;
                    space2 = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 63 && this.parsingRequestLineQPos == -1) {
                    this.parsingRequestLineQPos = this.pos;
                }
                ++this.pos;
            }
            this.request.unparsedURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            if (this.parsingRequestLineQPos >= 0) {
                this.request.queryString().setBytes(this.buf, this.parsingRequestLineQPos + 1, end - this.parsingRequestLineQPos - 1);
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, this.parsingRequestLineQPos - this.parsingRequestLineStart);
            } else {
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            }
            this.parsingRequestLinePhase = 5;
        }
        if (this.parsingRequestLinePhase == 5) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 6;
            this.end = 0;
        }
        if (this.parsingRequestLinePhase == 6) {
            while (!this.parsingRequestLineEol) {
                if (this.pos >= this.lastValid && !this.fill(false)) {
                    return false;
                }
                if (this.buf[this.pos] == 13) {
                    this.end = this.pos;
                } else if (this.buf[this.pos] == 10) {
                    if (this.end == 0) {
                        this.end = this.pos;
                    }
                    this.parsingRequestLineEol = true;
                }
                ++this.pos;
            }
            if (this.end - this.parsingRequestLineStart > 0) {
                this.request.protocol().setBytes(this.buf, this.parsingRequestLineStart, this.end - this.parsingRequestLineStart);
            } else {
                this.request.protocol().setString("");
            }
            this.parsingRequestLine = false;
            this.parsingRequestLinePhase = 0;
            this.parsingRequestLineEol = false;
            this.parsingRequestLineStart = 0;
            return true;
        }
        throw new IllegalStateException("Invalid request line parse phase:" + this.parsingRequestLinePhase);
    }

    private void expand(int newsize) {
        if (newsize > this.buf.length) {
            if (this.parsingHeader) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            log.warn((Object)("Expanding buffer size. Old size: " + this.buf.length + ", new size: " + newsize), (Throwable)new Exception());
            byte[] tmp = new byte[newsize];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
        }
    }

    @Override
    public boolean parseHeaders() throws IOException {
        if (!this.parsingHeader) {
            throw new IllegalStateException(sm.getString("iib.parseheaders.ise.error"));
        }
        HeaderParseStatus status = HeaderParseStatus.HAVE_MORE_HEADERS;
        do {
            status = this.parseHeader();
            if (this.pos <= this.headerBufferSize && this.buf.length - this.pos >= this.socketReadBufferSize) continue;
            throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
        } while (status == HeaderParseStatus.HAVE_MORE_HEADERS);
        if (status == HeaderParseStatus.DONE) {
            this.parsingHeader = false;
            this.end = this.pos;
            return true;
        }
        return false;
    }

    private HeaderParseStatus parseHeader() throws IOException {
        byte chr = 0;
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (chr != 13) {
                if (chr != 10) break;
                ++this.pos;
                return HeaderParseStatus.DONE;
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.start = this.pos;
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (chr == 58) {
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
                this.headerData.headerValue = this.headers.addValue(this.buf, this.headerData.start, this.pos - this.headerData.start);
                ++this.pos;
                this.headerData.start = this.pos;
                this.headerData.realPos = this.pos;
                this.headerData.lastSignificantChar = this.pos;
                break;
            }
            if (!HTTP_TOKEN_CHAR[chr]) {
                this.headerData.lastSignificantChar = this.pos;
                return this.skipLine();
            }
            if (chr >= 65 && chr <= 90) {
                this.buf[this.pos] = (byte)(chr - -32);
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_SKIPLINE) {
            return this.skipLine();
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START || this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START) {
                while (true) {
                    if (this.pos >= this.lastValid && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    chr = this.buf[this.pos];
                    if (chr != 32 && chr != 9) break;
                    ++this.pos;
                }
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
            }
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                boolean eol = false;
                while (!eol) {
                    if (this.pos >= this.lastValid && !this.fill(false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    chr = this.buf[this.pos];
                    if (chr != 13) {
                        if (chr == 10) {
                            eol = true;
                        } else if (chr == 32 || chr == 9) {
                            this.buf[this.headerData.realPos] = chr;
                            ++this.headerData.realPos;
                        } else {
                            this.buf[this.headerData.realPos] = chr;
                            this.headerData.lastSignificantChar = ++this.headerData.realPos;
                        }
                    }
                    ++this.pos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (chr != 32 && chr != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                break;
            }
            this.buf[this.headerData.realPos] = chr;
            ++this.headerData.realPos;
            this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
        }
        this.headerData.headerValue.setBytes(this.buf, this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    public int getParsingRequestLinePhase() {
        return this.parsingRequestLinePhase;
    }

    private HeaderParseStatus skipLine() throws IOException {
        this.headerParsePos = HeaderParsePosition.HEADER_SKIPLINE;
        boolean eol = false;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill(false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    eol = true;
                } else {
                    this.headerData.lastSignificantChar = this.pos;
                }
            }
            ++this.pos;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("iib.invalidheader", new Object[]{new String(this.buf, this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start + 1, StandardCharsets.ISO_8859_1)}));
        }
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    @Override
    protected void init(SocketWrapper<Nio2Channel> socketWrapper, AbstractEndpoint<Nio2Channel> associatedEndpoint) throws IOException {
        this.endpoint = associatedEndpoint;
        this.socket = socketWrapper;
        if (this.socket == null) {
            throw new IOException(sm.getString("iib.socketClosed"));
        }
        this.socketReadBufferSize = this.socket.getSocket().getBufHandler().getReadBuffer().capacity();
        int bufLength = this.headerBufferSize + this.socketReadBufferSize;
        if (this.buf == null || this.buf.length < bufLength) {
            this.buf = new byte[bufLength];
        }
        this.completionHandler = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Integer nBytes, SocketWrapper<Nio2Channel> attachment) {
                boolean notify = false;
                CompletionHandler completionHandler = InternalNio2InputBuffer.this.completionHandler;
                synchronized (completionHandler) {
                    if (nBytes < 0) {
                        this.failed((Throwable)new EOFException(AbstractInputBuffer.sm.getString("iib.eof.error")), attachment);
                        return;
                    }
                    InternalNio2InputBuffer.this.readPending = false;
                    if (!Nio2Endpoint.isInline()) {
                        notify = true;
                    }
                }
                if (notify) {
                    InternalNio2InputBuffer.this.endpoint.processSocket(attachment, SocketStatus.OPEN_READ, false);
                }
            }

            @Override
            public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
                attachment.setError(true);
                InternalNio2InputBuffer.this.e = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                InternalNio2InputBuffer.this.request.setAttribute("javax.servlet.error.exception", InternalNio2InputBuffer.this.e);
                InternalNio2InputBuffer.this.readPending = false;
                InternalNio2InputBuffer.this.endpoint.processSocket(attachment, SocketStatus.OPEN_READ, true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean fill(boolean block) throws IOException, EOFException {
        if (this.e != null) {
            throw this.e;
        }
        if (this.parsingHeader) {
            if (this.lastValid > this.headerBufferSize) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
        } else {
            this.lastValid = this.pos = this.end;
        }
        int nRead = 0;
        ByteBuffer byteBuffer = this.socket.getSocket().getBufHandler().getReadBuffer();
        if (block) {
            int nBytes;
            if (!this.flipped) {
                byteBuffer.flip();
                this.flipped = true;
            }
            if ((nBytes = byteBuffer.remaining()) > 0) {
                this.expand(nBytes + this.pos);
                byteBuffer.get(this.buf, this.pos, nBytes);
                this.lastValid = this.pos + nBytes;
                byteBuffer.clear();
                this.flipped = false;
                return true;
            }
            byteBuffer.clear();
            this.flipped = false;
            try {
                nRead = this.socket.getSocket().read(byteBuffer).get(this.socket.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
            catch (TimeoutException e) {
                throw new SocketTimeoutException();
            }
            if (nRead > 0) {
                if (!this.flipped) {
                    byteBuffer.flip();
                    this.flipped = true;
                }
                this.expand(nRead + this.pos);
                byteBuffer.get(this.buf, this.pos, nRead);
                this.lastValid = this.pos + nRead;
                return true;
            }
            if (nRead == -1) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            return false;
        }
        CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            if (!this.readPending) {
                int nBytes;
                if (!this.flipped) {
                    byteBuffer.flip();
                    this.flipped = true;
                }
                if ((nBytes = byteBuffer.remaining()) > 0) {
                    this.expand(nBytes + this.pos);
                    byteBuffer.get(this.buf, this.pos, nBytes);
                    this.lastValid = this.pos + nBytes;
                    byteBuffer.clear();
                    this.flipped = false;
                } else {
                    byteBuffer.clear();
                    this.flipped = false;
                    this.readPending = true;
                    Nio2Endpoint.startInline();
                    try {
                        this.socket.getSocket().read(byteBuffer, this.socket.getTimeout(), TimeUnit.MILLISECONDS, this.socket, this.completionHandler);
                    }
                    catch (ReadPendingException e) {
                        // empty catch block
                    }
                    Nio2Endpoint.endInline();
                    if (!this.readPending) {
                        if (!this.flipped) {
                            byteBuffer.flip();
                            this.flipped = true;
                        }
                        if ((nBytes = byteBuffer.remaining()) > 0) {
                            this.expand(nBytes + this.pos);
                            byteBuffer.get(this.buf, this.pos, nBytes);
                            this.lastValid = this.pos + nBytes;
                        }
                        byteBuffer.clear();
                        this.flipped = false;
                    }
                }
                return this.lastValid - this.pos > 0;
            }
            return false;
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNio2InputBuffer.this.pos >= InternalNio2InputBuffer.this.lastValid && !InternalNio2InputBuffer.this.fill(true)) {
                return -1;
            }
            if (InternalNio2InputBuffer.this.isBlocking()) {
                int length = InternalNio2InputBuffer.this.lastValid - InternalNio2InputBuffer.this.pos;
                chunk.setBytes(InternalNio2InputBuffer.this.buf, InternalNio2InputBuffer.this.pos, length);
                InternalNio2InputBuffer.this.pos = InternalNio2InputBuffer.this.lastValid;
                return length;
            }
            CompletionHandler completionHandler = InternalNio2InputBuffer.this.completionHandler;
            synchronized (completionHandler) {
                int length = InternalNio2InputBuffer.this.lastValid - InternalNio2InputBuffer.this.pos;
                chunk.setBytes(InternalNio2InputBuffer.this.buf, InternalNio2InputBuffer.this.pos, length);
                InternalNio2InputBuffer.this.pos = InternalNio2InputBuffer.this.lastValid;
                return length;
            }
        }
    }

    public static class HeaderParseData {
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        public void recycle() {
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE_START,
        HEADER_VALUE,
        HEADER_MULTI_LINE,
        HEADER_SKIPLINE;

    }

    static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

