/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.Utility;

public final class Code
extends Attribute {
    private static final long serialVersionUID = 8936843273318969602L;
    private int code_length;
    private byte[] code;
    private int exception_table_length;
    private int attributes_count;
    private Attribute[] attributes;

    Code(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, null, null, constant_pool);
        int i;
        file.readUnsignedShort();
        file.readUnsignedShort();
        this.code_length = file.readInt();
        this.code = new byte[this.code_length];
        file.readFully(this.code);
        this.exception_table_length = file.readUnsignedShort();
        for (i = 0; i < this.exception_table_length; ++i) {
            Utility.swallowCodeException(file);
        }
        this.attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        for (i = 0; i < this.attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
        this.length = length;
    }

    public Code(int name_index, int length, byte[] code, Attribute[] attributes, ConstantPool constant_pool) {
        super(name_index, length, constant_pool);
        this.setCode(code);
        this.setAttributes(attributes);
    }

    private final int getInternalLength() {
        return 8 + this.code_length + 2 + 8 * this.exception_table_length + 2;
    }

    private final int calculateLength() {
        int len = 0;
        for (int i = 0; i < this.attributes_count; ++i) {
            len += this.attributes[i].length + 6;
        }
        return len + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
        this.attributes_count = attributes == null ? 0 : attributes.length;
        this.length = this.calculateLength();
    }

    public final void setCode(byte[] code) {
        this.code = code;
        this.code_length = code == null ? 0 : code.length;
        this.length = this.calculateLength();
    }
}

