/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;

final class Utility {
    private Utility() {
    }

    static String compactClassName(String str) {
        return str.replace('/', '.');
    }

    static void swallowCodeException(DataInput file) throws IOException {
        file.readUnsignedShort();
        file.readUnsignedShort();
        file.readUnsignedShort();
        file.readUnsignedShort();
    }

    static void swallowInnerClass(DataInput file) throws IOException {
        file.readUnsignedShort();
        file.readUnsignedShort();
        file.readUnsignedShort();
        file.readUnsignedShort();
    }

    static void swallowLineNumber(DataInput file) throws IOException {
        file.readUnsignedShort();
        file.readUnsignedShort();
    }

    static void swallowLocalVariable(DataInput file) throws IOException {
        file.readUnsignedShort();
        file.readUnsignedShort();
        file.readUnsignedShort();
        file.readUnsignedShort();
        file.readUnsignedShort();
    }

    static void swallowStackMap(DataInput file) throws IOException {
        int map_length = file.readUnsignedShort();
        for (int i = 0; i < map_length; ++i) {
            Utility.swallowStackMapEntry(file);
        }
    }

    static void swallowStackMapTable(DataInputStream file) throws IOException {
        int map_length = file.readUnsignedShort();
        for (int i = 0; i < map_length; ++i) {
            Utility.swallowStackMapTableEntry(file);
        }
    }

    static void swallowStackMapType(DataInput file) throws IOException {
        byte type = file.readByte();
        if (type < 0 || type > 8) {
            throw new ClassFormatException("Illegal type for StackMapType: " + type);
        }
        if (type == 7 || type == 8) {
            file.readShort();
        }
    }

    static void swallowStackMapEntry(DataInput file) throws IOException {
        file.readShort();
        int number_of_locals = file.readShort();
        for (int i = 0; i < number_of_locals; ++i) {
            Utility.swallowStackMapType(file);
        }
        int number_of_stack_items = file.readShort();
        for (int i = 0; i < number_of_stack_items; ++i) {
            Utility.swallowStackMapType(file);
        }
    }

    static void swallowStackMapTableEntry(DataInputStream file) throws IOException {
        int frame_type = file.read();
        if (frame_type < 0 || frame_type > 63) {
            if (frame_type >= 64 && frame_type <= 127) {
                Utility.swallowStackMapType(file);
            } else if (frame_type == 247) {
                file.readShort();
                Utility.swallowStackMapType(file);
            } else if (frame_type >= 248 && frame_type <= 250) {
                file.readShort();
            } else if (frame_type == 251) {
                file.readShort();
            } else if (frame_type >= 252 && frame_type <= 254) {
                file.readShort();
                int number_of_locals = frame_type - 251;
                for (int i = 0; i < number_of_locals; ++i) {
                    Utility.swallowStackMapType(file);
                }
            } else if (frame_type == 255) {
                file.readShort();
                int number_of_locals = file.readShort();
                for (int i = 0; i < number_of_locals; ++i) {
                    Utility.swallowStackMapType(file);
                }
                int number_of_stack_items = file.readShort();
                for (int i = 0; i < number_of_stack_items; ++i) {
                    Utility.swallowStackMapType(file);
                }
            } else {
                throw new ClassFormatException("Invalid frame type found while parsing stack map table: " + frame_type);
            }
        }
    }

    static void swallowUnknownAttribute(DataInput file, int length) throws IOException {
        if (length > 0) {
            byte[] bytes = new byte[length];
            file.readFully(bytes);
        }
    }

    static void swallowSignature(DataInput file) throws IOException {
        file.readUnsignedShort();
    }

    static void swallowSynthetic(DataInput file, int length) throws IOException {
        if (length > 0) {
            byte[] bytes = new byte[length];
            file.readFully(bytes);
            throw new ClassFormatException("Synthetic attribute with length > 0");
        }
    }
}

