/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadPendingException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.net.jsse.NioX509KeyManager;

public class Nio2Endpoint
extends AbstractEndpoint<Nio2Channel> {
    private static final Log log = LogFactory.getLog(Nio2Endpoint.class);
    public static final int OP_REGISTER = 256;
    public static final int OP_CALLBACK = 512;
    public static final int OP_READ = 1024;
    public static final int OP_WRITE = 2048;
    private AsynchronousServerSocketChannel serverSock = null;
    private boolean useSendfile = true;
    private int oomParachute = 0x100000;
    private static ThreadLocal<Boolean> inlineCompletion = new ThreadLocal();
    private AsynchronousChannelGroup threadGroup = null;
    private byte[] oomParachuteData = null;
    private static final String oomParachuteMsg = "SEVERE:Memory usage is low, parachute is non existent, your system may start failing.";
    private long lastParachuteCheck = System.currentTimeMillis();
    private final SynchronizedStack<SocketProcessor> processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
    private final SynchronizedStack<Nio2SocketWrapper> socketWrapperCache = new SynchronizedStack(128, this.socketProperties.getSocketWrapperCache());
    private final SynchronizedStack<Nio2Channel> nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPoolSize());
    private boolean useCaches = false;
    private int pollerThreadPriority = 5;
    private Handler handler = null;
    private boolean useComet = true;
    private SSLContext sslContext = null;
    private String[] enabledCiphers;
    private String[] enabledProtocols;
    protected ConcurrentHashMap<SocketWrapper<Nio2Channel>, SocketWrapper<Nio2Channel>> waitingRequests = new ConcurrentHashMap();
    private CompletionHandler<Integer, SocketWrapper<Nio2Channel>> awaitBytes = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

        @Override
        public synchronized void completed(Integer nBytes, SocketWrapper<Nio2Channel> attachment) {
            if (nBytes < 0) {
                this.failed((Throwable)new ClosedChannelException(), attachment);
                return;
            }
            Nio2Endpoint.this.processSocket0(attachment, SocketStatus.OPEN_READ, true);
        }

        @Override
        public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
            Nio2Endpoint.this.processSocket0(attachment, SocketStatus.DISCONNECT, true);
        }
    };

    public void setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setPollerThreadPriority(int pollerThreadPriority) {
        this.pollerThreadPriority = pollerThreadPriority;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setUseComet(boolean useComet) {
        this.useComet = useComet;
    }

    @Override
    public boolean getUseComet() {
        return this.useComet;
    }

    @Override
    public boolean getUseCometTimeout() {
        return this.getUseComet();
    }

    @Override
    public boolean getUsePolling() {
        return true;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties = socketProperties;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public void setOomParachute(int oomParachute) {
        this.oomParachute = oomParachute;
    }

    public void setOomParachuteData(byte[] oomParachuteData) {
        this.oomParachuteData = oomParachuteData;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext c) {
        this.sslContext = c;
    }

    @Override
    public int getLocalPort() {
        AsynchronousServerSocketChannel ssc = this.serverSock;
        if (ssc == null) {
            return -1;
        }
        try {
            SocketAddress sa = ssc.getLocalAddress();
            if (sa != null && sa instanceof InetSocketAddress) {
                return ((InetSocketAddress)sa).getPort();
            }
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public String[] getCiphersUsed() {
        return this.enabledCiphers;
    }

    protected void checkParachute() {
        boolean para = this.reclaimParachute(false);
        if (!para && System.currentTimeMillis() - this.lastParachuteCheck > 10000L) {
            try {
                log.fatal((Object)oomParachuteMsg);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                System.err.println(oomParachuteMsg);
            }
            this.lastParachuteCheck = System.currentTimeMillis();
        }
    }

    protected boolean reclaimParachute(boolean force) {
        if (this.oomParachuteData != null) {
            return true;
        }
        if (this.oomParachute > 0 && (force || Runtime.getRuntime().freeMemory() > (long)(this.oomParachute * 2))) {
            this.oomParachuteData = new byte[this.oomParachute];
        }
        return this.oomParachuteData != null;
    }

    protected void releaseCaches() {
        if (this.useCaches) {
            this.socketWrapperCache.clear();
            this.nioChannels.clear();
            this.processorCache.clear();
        }
        if (this.handler != null) {
            this.handler.recycle();
        }
    }

    public int getKeepAliveCount() {
        return -1;
    }

    @Override
    public void bind() throws Exception {
        if (this.getExecutor() == null) {
            this.createExecutor();
        }
        if (this.getExecutor() instanceof ExecutorService) {
            this.threadGroup = AsynchronousChannelGroup.withThreadPool((ExecutorService)this.getExecutor());
        }
        if (!this.internalExecutor) {
            log.warn((Object)sm.getString("endpoint.nio2.exclusiveExecutor"));
        }
        this.serverSock = AsynchronousServerSocketChannel.open(this.threadGroup);
        this.socketProperties.setProperties(this.serverSock);
        InetSocketAddress addr = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.serverSock.bind(addr, this.getBacklog());
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.isSSLEnabled()) {
            SSLUtil sslUtil = this.handler.getSslImplementation().getSSLUtil(this);
            this.sslContext = sslUtil.createSSLContext();
            this.sslContext.init(this.wrap(sslUtil.getKeyManagers()), sslUtil.getTrustManagers(), null);
            SSLSessionContext sessionContext = this.sslContext.getServerSessionContext();
            if (sessionContext != null) {
                sslUtil.configureSessionContext(sessionContext);
            }
            this.enabledCiphers = sslUtil.getEnableableCiphers(this.sslContext);
            this.enabledProtocols = sslUtil.getEnableableProtocols(this.sslContext);
        }
        if (this.oomParachute > 0) {
            this.reclaimParachute(true);
        }
    }

    public KeyManager[] wrap(KeyManager[] managers) {
        if (managers == null) {
            return null;
        }
        KeyManager[] result = new KeyManager[managers.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = managers[i] instanceof X509KeyManager && this.getKeyAlias() != null ? new NioX509KeyManager((X509KeyManager)managers[i], this.getKeyAlias()) : managers[i];
        }
        return result;
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            log.warn((Object)"The NIO2 connector is currently EXPERIMENTAL and should not be used in production");
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.startAcceptorThreads();
            Thread timeoutThread = new Thread((Runnable)new AsyncTimeout(), this.getName() + "-AsyncTimeout");
            timeoutThread.setPriority(this.threadPriority);
            timeoutThread.setDaemon(true);
            timeoutThread.start();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.unlockAccept();
        }
        try {
            this.handler.closeAll();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
        }
        if (this.useCaches) {
            this.socketWrapperCache.clear();
            this.nioChannels.clear();
            this.processorCache.clear();
        }
    }

    @Override
    public void unbind() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy initiated for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
        if (this.running) {
            this.stop();
        }
        this.serverSock.close();
        this.serverSock = null;
        this.sslContext = null;
        this.shutdownExecutor();
        this.releaseCaches();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy completed for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
    }

    @Override
    public void shutdownExecutor() {
        if (this.threadGroup != null && this.internalExecutor) {
            try {
                this.threadGroup.shutdownNow();
            }
            catch (IOException e) {
                this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}), (Throwable)e);
            }
            long timeout = this.getExecutorTerminationTimeoutMillis();
            if (timeout > 0L) {
                try {
                    this.threadGroup.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.threadGroup.isTerminated()) {
                    this.getLog().warn((Object)sm.getString("endpoint.warn.executorShutdown", new Object[]{this.getName()}));
                }
            }
            this.threadGroup = null;
        }
        super.shutdownExecutor();
    }

    public int getWriteBufSize() {
        return this.socketProperties.getTxBufSize();
    }

    public int getReadBufSize() {
        return this.socketProperties.getRxBufSize();
    }

    @Override
    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public int getOomParachute() {
        return this.oomParachute;
    }

    public byte[] getOomParachuteData() {
        return this.oomParachuteData;
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(AsynchronousSocketChannel socket) {
        try {
            Nio2SocketWrapper socketWrapper;
            SSLEngine engine;
            Nio2Channel channel;
            this.socketProperties.setProperties(socket);
            Nio2Channel nio2Channel = channel = this.useCaches ? this.nioChannels.pop() : null;
            if (channel == null) {
                if (this.sslContext != null) {
                    engine = this.createSSLEngine();
                    int appBufferSize = engine.getSession().getApplicationBufferSize();
                    NioBufferHandler bufhandler = new NioBufferHandler(Math.max(appBufferSize, this.socketProperties.getAppReadBufSize()), Math.max(appBufferSize, this.socketProperties.getAppWriteBufSize()), this.socketProperties.getDirectBuffer());
                    channel = new SecureNio2Channel(socket, engine, bufhandler, this);
                } else {
                    NioBufferHandler bufhandler = new NioBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                    channel = new Nio2Channel(socket, bufhandler);
                }
            } else {
                channel.setIOChannel(socket);
                if (channel instanceof SecureNio2Channel) {
                    engine = this.createSSLEngine();
                    ((SecureNio2Channel)channel).setSSLEngine(engine);
                }
                channel.reset();
            }
            Nio2SocketWrapper nio2SocketWrapper = socketWrapper = this.useCaches ? this.socketWrapperCache.pop() : null;
            if (socketWrapper == null) {
                socketWrapper = new Nio2SocketWrapper(channel);
            }
            socketWrapper.reset(channel, (long)this.getSocketProperties().getSoTimeout());
            socketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            socketWrapper.setSecure(this.isSSLEnabled());
            channel.setSocket(socketWrapper);
            if (this.sslContext != null) {
                this.processSocket(socketWrapper, SocketStatus.OPEN_READ, true);
            } else {
                this.awaitBytes(socketWrapper);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            try {
                log.error((Object)"", t);
            }
            catch (Throwable tt) {
                ExceptionUtils.handleThrowable((Throwable)t);
            }
            return false;
        }
        return true;
    }

    protected SSLEngine createSSLEngine() {
        SSLEngine engine = this.sslContext.createSSLEngine();
        if ("false".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(false);
            engine.setWantClientAuth(false);
        } else if ("true".equals(this.getClientAuth()) || "yes".equals(this.getClientAuth())) {
            engine.setNeedClientAuth(true);
        } else if ("want".equals(this.getClientAuth())) {
            engine.setWantClientAuth(true);
        }
        engine.setUseClientMode(false);
        engine.setEnabledCipherSuites(this.enabledCiphers);
        engine.setEnabledProtocols(this.enabledProtocols);
        this.handler.onCreateSSLEngine(engine);
        return engine;
    }

    protected boolean isWorkerAvailable() {
        return true;
    }

    @Override
    public void processSocket(SocketWrapper<Nio2Channel> socketWrapper, SocketStatus socketStatus, boolean dispatch) {
        this.processSocket0(socketWrapper, socketStatus, dispatch);
    }

    protected boolean processSocket0(SocketWrapper<Nio2Channel> socket, SocketStatus status, boolean dispatch) {
        try {
            SocketProcessor sc;
            ((Nio2SocketWrapper)socket).setCometNotify(false);
            SocketProcessor socketProcessor = sc = this.useCaches ? this.processorCache.pop() : null;
            if (sc == null) {
                sc = new SocketProcessor(socket, status);
            } else {
                sc.reset(socket, status);
            }
            Executor executor = this.getExecutor();
            if (dispatch && executor != null) {
                executor.execute(sc);
            } else {
                sc.run();
            }
        }
        catch (RejectedExecutionException ree) {
            log.debug((Object)sm.getString("endpoint.executor.fail", new Object[]{socket}), (Throwable)ree);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    public void closeSocket(SocketWrapper<Nio2Channel> socket, SocketStatus status) {
        block15: {
            try {
                Nio2SocketWrapper ka;
                block14: {
                    ka = (Nio2SocketWrapper)socket;
                    if (socket != null && socket.isComet() && status != null) {
                        socket.setComet(false);
                        if (status == SocketStatus.TIMEOUT) {
                            if (this.processSocket0(socket, status, true)) {
                                return;
                            }
                        } else {
                            this.processSocket0(socket, status, false);
                        }
                    }
                    if (socket != null) {
                        this.handler.release(socket);
                    }
                    try {
                        if (socket != null) {
                            socket.getSocket().close(true);
                        }
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug((Object)sm.getString("endpoint.debug.socketCloseFail"), (Throwable)e);
                    }
                }
                try {
                    if (ka != null && ka.getSendfileData() != null && ka.getSendfileData().fchannel != null && ka.getSendfileData().fchannel.isOpen()) {
                        ka.getSendfileData().fchannel.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (ka != null) {
                    ka.reset();
                    this.countDownConnection();
                }
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable((Throwable)e);
                if (!log.isDebugEnabled()) break block15;
                log.error((Object)"", e);
            }
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private void closeSocket(AsynchronousSocketChannel socket) {
        block2: {
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"", (Throwable)ioe);
            }
        }
    }

    public void addTimeout(SocketWrapper<Nio2Channel> socket) {
        this.waitingRequests.put(socket, socket);
    }

    public boolean removeTimeout(SocketWrapper<Nio2Channel> socket) {
        return this.waitingRequests.remove(socket) != null;
    }

    public static void startInline() {
        inlineCompletion.set(Boolean.TRUE);
    }

    public static void endInline() {
        inlineCompletion.set(Boolean.FALSE);
    }

    public static boolean isInline() {
        Boolean flag = inlineCompletion.get();
        if (flag == null) {
            return false;
        }
        return flag;
    }

    public void awaitBytes(SocketWrapper<Nio2Channel> socket) {
        if (socket == null || socket.getSocket() == null) {
            return;
        }
        ByteBuffer byteBuffer = socket.getSocket().getBufHandler().getReadBuffer();
        byteBuffer.clear();
        try {
            socket.getSocket().read(byteBuffer, socket.getTimeout(), TimeUnit.MILLISECONDS, socket, this.awaitBytes);
        }
        catch (ReadPendingException readPendingException) {
            // empty catch block
        }
    }

    public boolean processSendfile(final Nio2SocketWrapper socket) {
        ByteBuffer buffer;
        SendfileData data = socket.getSendfileData();
        if (data.fchannel == null || !data.fchannel.isOpen()) {
            Path path = new File(data.fileName).toPath();
            try {
                data.fchannel = FileChannel.open(path, StandardOpenOption.READ).position(data.pos);
            }
            catch (IOException e) {
                this.closeSocket(socket, SocketStatus.ERROR);
                return false;
            }
        }
        if (!this.socketProperties.getDirectBuffer() && this.sslContext == null) {
            int bufferSize;
            try {
                Integer bufferSizeInteger = ((Nio2Channel)socket.getSocket()).getIOChannel().getOption(StandardSocketOptions.SO_SNDBUF);
                bufferSize = bufferSizeInteger != null ? bufferSizeInteger : 8192;
            }
            catch (IOException e) {
                bufferSize = 8192;
            }
            buffer = ByteBuffer.allocateDirect(bufferSize);
        } else {
            buffer = ((Nio2Channel)socket.getSocket()).getBufHandler().getWriteBuffer();
        }
        int nr = -1;
        try {
            nr = data.fchannel.read(buffer);
        }
        catch (IOException e1) {
            this.closeSocket(socket, SocketStatus.ERROR);
            return false;
        }
        if (nr >= 0) {
            ((Nio2Channel)socket.getSocket()).setSendFile(true);
            buffer.flip();
            ((Nio2Channel)socket.getSocket()).write(buffer, data, new CompletionHandler<Integer, SendfileData>(){

                @Override
                public void completed(Integer nw, SendfileData attachment) {
                    if (nw < 0) {
                        Nio2Endpoint.this.closeSocket(socket, SocketStatus.DISCONNECT);
                        try {
                            attachment.fchannel.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                    attachment.pos += (long)nw.intValue();
                    attachment.length -= (long)nw.intValue();
                    if (attachment.length <= 0L) {
                        socket.setSendfileData(null);
                        try {
                            attachment.fchannel.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (attachment.keepAlive) {
                            ((Nio2Channel)socket.getSocket()).setSendFile(false);
                            Nio2Endpoint.this.awaitBytes(socket);
                        } else {
                            Nio2Endpoint.this.closeSocket(socket, SocketStatus.DISCONNECT);
                        }
                        return;
                    }
                    boolean ok = true;
                    if (!buffer.hasRemaining()) {
                        buffer.clear();
                        try {
                            if (attachment.fchannel.read(buffer) >= 0) {
                                buffer.flip();
                                if (attachment.length < (long)buffer.remaining()) {
                                    buffer.limit(buffer.limit() - buffer.remaining() + (int)attachment.length);
                                }
                            } else {
                                ok = false;
                            }
                        }
                        catch (Throwable th) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Unable to complete sendfile request:", th);
                            }
                            ok = false;
                        }
                    }
                    if (ok) {
                        ((Nio2Channel)socket.getSocket()).write(buffer, attachment, this);
                    } else {
                        try {
                            attachment.fchannel.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        Nio2Endpoint.this.closeSocket(socket, SocketStatus.ERROR);
                    }
                }

                @Override
                public void failed(Throwable exc, SendfileData attachment) {
                    Nio2Endpoint.this.closeSocket(socket, SocketStatus.ERROR);
                    try {
                        attachment.fchannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        return false;
    }

    static /* synthetic */ byte[] access$702(Nio2Endpoint x0, byte[] x1) {
        x0.oomParachuteData = x1;
        return x1;
    }

    public static class SendfileData {
        public String fileName;
        public FileChannel fchannel;
        public long pos;
        public long length;
        public boolean keepAlive;
    }

    protected class SocketProcessor
    implements Runnable {
        private SocketWrapper<Nio2Channel> socket = null;
        private SocketStatus status = null;

        public SocketProcessor(SocketWrapper<Nio2Channel> socket, SocketStatus status) {
            this.reset(socket, status);
        }

        public void reset(SocketWrapper<Nio2Channel> socket, SocketStatus status) {
            this.socket = socket;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.socket != null && this.socket.isUpgraded() && SocketStatus.OPEN_WRITE == this.status) {
                Object object = this.socket.getWriteThreadLock();
                synchronized (object) {
                    this.doRun();
                }
            }
            SocketWrapper<Nio2Channel> socketWrapper = this.socket;
            synchronized (socketWrapper) {
                this.doRun();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            block44: {
                boolean launch = false;
                try {
                    int handshake;
                    block43: {
                        handshake = -1;
                        try {
                            if (this.socket != null && this.socket.getSocket() != null) {
                                if (this.socket.getSocket().isHandshakeComplete() || this.status == SocketStatus.STOP) {
                                    handshake = 0;
                                } else {
                                    handshake = this.socket.getSocket().handshake();
                                    this.status = SocketStatus.OPEN_READ;
                                }
                            }
                        }
                        catch (IOException x) {
                            handshake = -1;
                            if (!log.isDebugEnabled()) break block43;
                            log.debug((Object)"Error during SSL handshake", (Throwable)x);
                        }
                    }
                    if (handshake == 0) {
                        AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                        state = this.status == null ? Nio2Endpoint.this.handler.process(this.socket, SocketStatus.OPEN_READ) : Nio2Endpoint.this.handler.process(this.socket, this.status);
                        if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                            try {
                                this.socket.setComet(false);
                                Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.ERROR);
                                if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                                    Nio2Endpoint.this.nioChannels.push(this.socket.getSocket());
                                }
                                if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused && this.socket != null) {
                                    Nio2Endpoint.this.socketWrapperCache.push((Nio2SocketWrapper)this.socket);
                                }
                                break block44;
                            }
                            catch (Exception x) {
                                log.error((Object)"", (Throwable)x);
                            }
                            break block44;
                        }
                        if (state == AbstractEndpoint.Handler.SocketState.UPGRADING) {
                            this.socket.setKeptAlive(true);
                            this.socket.access();
                            launch = true;
                        }
                        break block44;
                    }
                    if (handshake == -1) {
                        if (this.socket != null) {
                            Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.DISCONNECT);
                        }
                        if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                            Nio2Endpoint.this.nioChannels.push(this.socket.getSocket());
                        }
                        if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused && this.socket != null) {
                            Nio2Endpoint.this.socketWrapperCache.push((Nio2SocketWrapper)this.socket);
                        }
                    }
                }
                catch (OutOfMemoryError oom) {
                    try {
                        Nio2Endpoint.access$702(Nio2Endpoint.this, null);
                        log.error((Object)"", (Throwable)oom);
                        if (this.socket != null) {
                            Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.ERROR);
                        }
                        Nio2Endpoint.this.releaseCaches();
                    }
                    catch (Throwable oomt) {
                        try {
                            System.err.println(Nio2Endpoint.oomParachuteMsg);
                            oomt.printStackTrace();
                        }
                        catch (Throwable letsHopeWeDontGetHere) {
                            ExceptionUtils.handleThrowable((Throwable)letsHopeWeDontGetHere);
                        }
                    }
                }
                catch (VirtualMachineError vme) {
                    ExceptionUtils.handleThrowable((Throwable)vme);
                }
                catch (Throwable t) {
                    log.error((Object)"", t);
                    if (this.socket != null) {
                        Nio2Endpoint.this.closeSocket(this.socket, SocketStatus.ERROR);
                    }
                }
                finally {
                    block45: {
                        if (launch) {
                            try {
                                Nio2Endpoint.this.getExecutor().execute(new SocketProcessor(this.socket, SocketStatus.OPEN_READ));
                            }
                            catch (NullPointerException npe) {
                                if (!Nio2Endpoint.this.running) break block45;
                                log.error((Object)AbstractEndpoint.sm.getString("endpoint.launch.fail"), (Throwable)npe);
                            }
                        }
                    }
                    this.socket = null;
                    this.status = null;
                    if (Nio2Endpoint.this.useCaches && Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                        Nio2Endpoint.this.processorCache.push(this);
                    }
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Nio2Channel> var1, SocketStatus var2);

        public void release(SocketWrapper<Nio2Channel> var1);

        public void closeAll();

        public SSLImplementation getSslImplementation();

        public void onCreateSSLEngine(SSLEngine var1);
    }

    public static class NioBufferHandler
    implements SecureNio2Channel.ApplicationBufferHandler {
        private ByteBuffer readbuf = null;
        private ByteBuffer writebuf = null;

        public NioBufferHandler(int readsize, int writesize, boolean direct) {
            if (direct) {
                this.readbuf = ByteBuffer.allocateDirect(readsize);
                this.writebuf = ByteBuffer.allocateDirect(writesize);
            } else {
                this.readbuf = ByteBuffer.allocate(readsize);
                this.writebuf = ByteBuffer.allocate(writesize);
            }
        }

        @Override
        public ByteBuffer expand(ByteBuffer buffer, int remaining) {
            return buffer;
        }

        @Override
        public ByteBuffer getReadBuffer() {
            return this.readbuf;
        }

        @Override
        public ByteBuffer getWriteBuffer() {
            return this.writebuf;
        }
    }

    public static class Nio2SocketWrapper
    extends SocketWrapper<Nio2Channel> {
        private int interestOps = 0;
        private boolean cometNotify = false;
        private CountDownLatch readLatch = null;
        private CountDownLatch writeLatch = null;
        private SendfileData sendfileData = null;
        private long writeTimeout = -1L;
        private boolean upgradeInit = false;

        public Nio2SocketWrapper(Nio2Channel channel) {
            super(channel);
        }

        @Override
        public void reset(Nio2Channel channel, long soTimeout) {
            int i;
            super.reset(channel, soTimeout);
            this.upgradeInit = false;
            this.cometNotify = false;
            this.interestOps = 0;
            this.sendfileData = null;
            if (this.readLatch != null) {
                try {
                    for (i = 0; i < (int)this.readLatch.getCount(); ++i) {
                        this.readLatch.countDown();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.readLatch = null;
            this.sendfileData = null;
            if (this.writeLatch != null) {
                try {
                    for (i = 0; i < (int)this.writeLatch.getCount(); ++i) {
                        this.writeLatch.countDown();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.writeLatch = null;
            this.setWriteTimeout(soTimeout);
        }

        public void reset() {
            this.reset(null, -1L);
        }

        @Override
        public long getTimeout() {
            long timeout = super.getTimeout();
            return timeout > 0L ? timeout : Long.MAX_VALUE;
        }

        @Override
        public void setUpgraded(boolean upgraded) {
            if (upgraded && !this.isUpgraded()) {
                this.upgradeInit = true;
            }
            super.setUpgraded(upgraded);
        }

        public boolean isUpgradeInit() {
            boolean value = this.upgradeInit;
            this.upgradeInit = false;
            return value;
        }

        public void setCometNotify(boolean notify) {
            this.cometNotify = notify;
        }

        public boolean getCometNotify() {
            return this.cometNotify;
        }

        public Nio2Channel getChannel() {
            return (Nio2Channel)this.getSocket();
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int ops) {
            this.interestOps = ops;
            return ops;
        }

        public CountDownLatch getReadLatch() {
            return this.readLatch;
        }

        public CountDownLatch getWriteLatch() {
            return this.writeLatch;
        }

        protected CountDownLatch resetLatch(CountDownLatch latch) {
            if (latch == null || latch.getCount() == 0L) {
                return null;
            }
            throw new IllegalStateException("Latch must be at count 0");
        }

        public void resetReadLatch() {
            this.readLatch = this.resetLatch(this.readLatch);
        }

        public void resetWriteLatch() {
            this.writeLatch = this.resetLatch(this.writeLatch);
        }

        protected CountDownLatch startLatch(CountDownLatch latch, int cnt) {
            if (latch == null || latch.getCount() == 0L) {
                return new CountDownLatch(cnt);
            }
            throw new IllegalStateException("Latch must be at count 0 or null.");
        }

        public void startReadLatch(int cnt) {
            this.readLatch = this.startLatch(this.readLatch, cnt);
        }

        public void startWriteLatch(int cnt) {
            this.writeLatch = this.startLatch(this.writeLatch, cnt);
        }

        protected void awaitLatch(CountDownLatch latch, long timeout, TimeUnit unit) throws InterruptedException {
            if (latch == null) {
                throw new IllegalStateException("Latch cannot be null");
            }
            latch.await(timeout, unit);
        }

        public void awaitReadLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.readLatch, timeout, unit);
        }

        public void awaitWriteLatch(long timeout, TimeUnit unit) throws InterruptedException {
            this.awaitLatch(this.writeLatch, timeout, unit);
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void setWriteTimeout(long writeTimeout) {
            this.writeTimeout = writeTimeout <= 0L ? Long.MAX_VALUE : writeTimeout;
        }

        public long getWriteTimeout() {
            return this.writeTimeout;
        }
    }

    protected class AsyncTimeout
    implements Runnable {
        protected AsyncTimeout() {
        }

        @Override
        public void run() {
            while (Nio2Endpoint.this.running) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                for (SocketWrapper socket : Nio2Endpoint.this.waitingRequests.keySet()) {
                    long access = socket.getLastAccess();
                    if (socket.getTimeout() <= 0L || now - access <= socket.getTimeout()) continue;
                    Nio2Endpoint.this.processSocket(socket, SocketStatus.TIMEOUT, true);
                }
                while (Nio2Endpoint.this.paused && Nio2Endpoint.this.running) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int errorDelay = 0;
            while (Nio2Endpoint.this.running) {
                while (Nio2Endpoint.this.paused && Nio2Endpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!Nio2Endpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    Nio2Endpoint.this.countUpOrAwaitConnection();
                    AsynchronousSocketChannel socket = null;
                    try {
                        socket = Nio2Endpoint.this.serverSock.accept().get();
                    }
                    catch (Exception e) {
                        Nio2Endpoint.this.countDownConnection();
                        errorDelay = Nio2Endpoint.this.handleExceptionWithDelay(errorDelay);
                        throw e;
                    }
                    errorDelay = 0;
                    if (Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                        if (Nio2Endpoint.this.setSocketOptions(socket)) continue;
                        Nio2Endpoint.this.countDownConnection();
                        Nio2Endpoint.this.closeSocket(socket);
                        continue;
                    }
                    Nio2Endpoint.this.countDownConnection();
                    Nio2Endpoint.this.closeSocket(socket);
                }
                catch (NullPointerException npe) {
                    if (!Nio2Endpoint.this.running) continue;
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), (Throwable)npe);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), t);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

