/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class SecureNio2Channel
extends Nio2Channel {
    protected ByteBuffer netInBuffer;
    protected ByteBuffer netOutBuffer;
    protected SSLEngine sslEngine;
    protected final Nio2Endpoint endpoint;
    protected boolean handshakeComplete = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus;
    protected boolean closed = false;
    protected boolean closing = false;
    protected volatile boolean readPending = false;
    protected volatile boolean writePending = false;
    private CompletionHandler<Integer, SocketWrapper<Nio2Channel>> handshakeReadCompletionHandler;
    private CompletionHandler<Integer, SocketWrapper<Nio2Channel>> handshakeWriteCompletionHandler;

    public SecureNio2Channel(AsynchronousSocketChannel channel, SSLEngine engine, ApplicationBufferHandler bufHandler, Nio2Endpoint endpoint0) throws IOException {
        super(channel, bufHandler);
        this.sslEngine = engine;
        this.endpoint = endpoint0;
        int netBufSize = this.sslEngine.getSession().getPacketBufferSize();
        if (this.endpoint.getSocketProperties().getDirectSslBuffer()) {
            this.netInBuffer = ByteBuffer.allocateDirect(netBufSize);
            this.netOutBuffer = ByteBuffer.allocateDirect(netBufSize);
        } else {
            this.netInBuffer = ByteBuffer.allocate(netBufSize);
            this.netOutBuffer = ByteBuffer.allocate(netBufSize);
        }
        this.handshakeReadCompletionHandler = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

            @Override
            public void completed(Integer result, SocketWrapper<Nio2Channel> attachment) {
                if (result < 0) {
                    this.failed((Throwable)new EOFException(), attachment);
                    return;
                }
                SecureNio2Channel.this.endpoint.processSocket(attachment, SocketStatus.OPEN_READ, false);
            }

            @Override
            public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
                SecureNio2Channel.this.endpoint.closeSocket(attachment, SocketStatus.ERROR);
            }
        };
        this.handshakeWriteCompletionHandler = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

            @Override
            public void completed(Integer result, SocketWrapper<Nio2Channel> attachment) {
                if (result < 0) {
                    this.failed((Throwable)new EOFException(), attachment);
                    return;
                }
                SecureNio2Channel.this.endpoint.processSocket(attachment, SocketStatus.OPEN_WRITE, false);
            }

            @Override
            public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
                SecureNio2Channel.this.endpoint.closeSocket(attachment, SocketStatus.ERROR);
            }
        };
        this.reset();
    }

    public void setSSLEngine(SSLEngine engine) {
        this.sslEngine = engine;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.netOutBuffer.position(0);
        this.netOutBuffer.limit(0);
        this.netInBuffer.position(0);
        this.netInBuffer.limit(0);
        this.handshakeComplete = false;
        this.closed = false;
        this.closing = false;
        this.readPending = false;
        this.writePending = false;
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
    }

    @Override
    public int getBufferSize() {
        int size = super.getBufferSize();
        size += this.netInBuffer != null ? this.netInBuffer.capacity() : 0;
        return size += this.netOutBuffer != null ? this.netOutBuffer.capacity() : 0;
    }

    @Override
    public Future<Boolean> flush() throws IOException {
        if (this.writePending) {
            throw new WritePendingException();
        }
        this.writePending = true;
        return new FutureFlush(this.sc.write(this.netOutBuffer));
    }

    @Override
    public int handshake() throws IOException {
        return this.handshakeInternal(true);
    }

    protected int handshakeInternal(boolean async) throws IOException {
        if (this.handshakeComplete) {
            return 0;
        }
        SSLEngineResult handshake = null;
        block13: while (!this.handshakeComplete) {
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: {
                    throw new IOException("NOT_HANDSHAKING during handshake");
                }
                case FINISHED: {
                    boolean bl = this.handshakeComplete = !this.netOutBuffer.hasRemaining();
                    if (this.handshakeComplete) {
                        return 0;
                    }
                    if (async) {
                        this.sc.write(this.netOutBuffer, this.socket, this.handshakeWriteCompletionHandler);
                    } else {
                        try {
                            this.sc.write(this.netOutBuffer).get(this.endpoint.getSoTimeout(), TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            throw new IOException("Handshake error");
                        }
                    }
                    return 2048;
                }
                case NEED_WRAP: {
                    handshake = this.handshakeWrap();
                    if (handshake.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.handshakeStatus = this.tasks();
                        }
                    } else {
                        throw new IOException("Unexpected status:" + (Object)((Object)handshake.getStatus()) + " during handshake WRAP.");
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.netOutBuffer.remaining() > 0) {
                        if (async) {
                            this.sc.write(this.netOutBuffer, this.socket, this.handshakeWriteCompletionHandler);
                        } else {
                            try {
                                this.sc.write(this.netOutBuffer).get(this.endpoint.getSoTimeout(), TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException e) {
                                throw new IOException("Handshake error");
                            }
                        }
                        return 2048;
                    }
                }
                case NEED_UNWRAP: {
                    handshake = this.handshakeUnwrap();
                    if (handshake.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block13;
                        this.handshakeStatus = this.tasks();
                        continue block13;
                    }
                    if (handshake.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        if (async) {
                            this.sc.read(this.netInBuffer, this.socket, this.handshakeReadCompletionHandler);
                        } else {
                            try {
                                this.sc.read(this.netInBuffer).get(this.endpoint.getSoTimeout(), TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException | ExecutionException | TimeoutException e) {
                                throw new IOException("Handshake error");
                            }
                        }
                        return 1024;
                    }
                    throw new IOException("Invalid handshake status:" + (Object)((Object)this.handshakeStatus) + " during handshake UNWRAP.");
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.tasks();
                    continue block13;
                }
            }
            throw new IllegalStateException("Invalid handshake status:" + (Object)((Object)this.handshakeStatus));
        }
        return this.handshakeComplete ? 0 : this.handshakeInternal(async);
    }

    public void rehandshake() throws IOException {
        if (this.netInBuffer.position() > 0 && this.netInBuffer.position() < this.netInBuffer.limit()) {
            throw new IOException("Network input buffer still contains data. Handshake will fail.");
        }
        if (this.netOutBuffer.position() > 0 && this.netOutBuffer.position() < this.netOutBuffer.limit()) {
            throw new IOException("Network output buffer still contains data. Handshake will fail.");
        }
        if (this.getBufHandler().getReadBuffer().position() > 0 && this.getBufHandler().getReadBuffer().position() < this.getBufHandler().getReadBuffer().limit()) {
            throw new IOException("Application input buffer still contains data. Data would have been lost.");
        }
        if (this.getBufHandler().getWriteBuffer().position() > 0 && this.getBufHandler().getWriteBuffer().position() < this.getBufHandler().getWriteBuffer().limit()) {
            throw new IOException("Application output buffer still contains data. Data would have been lost.");
        }
        this.reset();
        boolean handshaking = true;
        try {
            while (handshaking) {
                int hsStatus = this.handshakeInternal(false);
                switch (hsStatus) {
                    case -1: {
                        throw new EOFException("EOF during handshake.");
                    }
                    case 0: {
                        handshaking = false;
                        break;
                    }
                }
            }
        }
        catch (IOException x) {
            throw x;
        }
        catch (Exception cx) {
            IOException x = new IOException(cx);
            throw x;
        }
    }

    protected SSLEngineResult.HandshakeStatus tasks() {
        Runnable r = null;
        while ((r = this.sslEngine.getDelegatedTask()) != null) {
            r.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    protected SSLEngineResult handshakeWrap() throws IOException {
        this.netOutBuffer.clear();
        SSLEngineResult result = this.sslEngine.wrap(this.bufHandler.getWriteBuffer(), this.netOutBuffer);
        this.netOutBuffer.flip();
        this.handshakeStatus = result.getHandshakeStatus();
        return result;
    }

    protected SSLEngineResult handshakeUnwrap() throws IOException {
        SSLEngineResult result;
        if (this.netInBuffer.position() == this.netInBuffer.limit()) {
            this.netInBuffer.clear();
        }
        boolean cont = false;
        do {
            this.netInBuffer.flip();
            result = this.sslEngine.unwrap(this.netInBuffer, this.bufHandler.getReadBuffer());
            this.netInBuffer.compact();
            this.handshakeStatus = result.getHandshakeStatus();
            if (result.getStatus() != SSLEngineResult.Status.OK || result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.handshakeStatus = this.tasks();
        } while (cont = result.getStatus() == SSLEngineResult.Status.OK && this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.sslEngine.closeOutbound();
        try {
            if (!this.flush().get(this.endpoint.getSoTimeout(), TimeUnit.MILLISECONDS).booleanValue()) {
                throw new IOException("Remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead");
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException("Remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead", e);
        }
        catch (WritePendingException e) {
            throw new IOException("Pending write, so remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead", e);
        }
        this.netOutBuffer.clear();
        SSLEngineResult handshake = this.sslEngine.wrap(this.getEmptyBuf(), this.netOutBuffer);
        if (handshake.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new IOException("Invalid close state, will not send network data.");
        }
        this.netOutBuffer.flip();
        try {
            if (!this.flush().get(this.endpoint.getSoTimeout(), TimeUnit.MILLISECONDS).booleanValue()) {
                throw new IOException("Remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead");
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException("Remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead", e);
        }
        catch (WritePendingException e) {
            throw new IOException("Pending write, so remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead", e);
        }
        this.closed = !this.netOutBuffer.hasRemaining() && handshake.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean force) throws IOException {
        try {
            this.close();
        }
        finally {
            if (force || this.closed) {
                this.closed = true;
                this.sc.close();
            }
        }
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        if (this.readPending) {
            throw new ReadPendingException();
        }
        this.readPending = true;
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake incomplete, you must complete handshake before reading data.");
        }
        if (this.netInBuffer.position() > 0) {
            return new FutureRead(dst);
        }
        return new FutureNetRead(dst);
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        if (this.writePending) {
            throw new WritePendingException();
        }
        this.writePending = true;
        return new FutureWrite(src);
    }

    @Override
    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        if (this.closing || this.closed) {
            handler.completed(-1, attachment);
            return;
        }
        if (this.readPending) {
            throw new ReadPendingException();
        }
        this.readPending = true;
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake incomplete, you must complete handshake before reading data.");
        }
        ReadCompletionHandler<A> readCompletionHandler = new ReadCompletionHandler<A>(dst, handler);
        if (this.netInBuffer.position() > 0) {
            readCompletionHandler.completed(this.netInBuffer.position(), attachment);
        } else {
            this.sc.read(this.netInBuffer, timeout, unit, attachment, readCompletionHandler);
        }
    }

    @Override
    public <A> void write(final ByteBuffer src, final long timeout, final TimeUnit unit, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (this.closing || this.closed) {
            handler.failed(new IOException("Channel is in closing state."), attachment);
            return;
        }
        if (this.writePending) {
            throw new WritePendingException();
        }
        this.writePending = true;
        try {
            this.netOutBuffer.clear();
            SSLEngineResult result = this.sslEngine.wrap(src, this.netOutBuffer);
            final int written = result.bytesConsumed();
            this.netOutBuffer.flip();
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
            } else {
                this.writePending = false;
                handler.failed(new IOException("Unable to wrap data, invalid engine state: " + (Object)((Object)result.getStatus())), attachment);
                return;
            }
            this.sc.write(this.netOutBuffer, timeout, unit, attachment, new CompletionHandler<Integer, A>(){

                @Override
                public void completed(Integer nBytes, A attach) {
                    if (nBytes < 0) {
                        SecureNio2Channel.this.writePending = false;
                        handler.failed(new EOFException(), attach);
                    } else if (written == 0) {
                        SecureNio2Channel.this.write(src, timeout, unit, attachment, handler);
                    } else {
                        SecureNio2Channel.this.writePending = false;
                        handler.completed(written, attach);
                    }
                }

                @Override
                public void failed(Throwable exc, A attach) {
                    SecureNio2Channel.this.writePending = false;
                    handler.failed(exc, attach);
                }
            });
        }
        catch (Throwable exp) {
            this.writePending = false;
            handler.failed(exp, attachment);
        }
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.closing || this.closed) {
            handler.failed(new IOException("Channel is in closing state."), attachment);
            return;
        }
        if (this.writePending) {
            throw new WritePendingException();
        }
        this.writePending = true;
        try {
            GatherState<? super A> state = new GatherState<A>(srcs, offset, length, timeout, unit, attachment, handler);
            this.netOutBuffer.clear();
            SSLEngineResult result = this.sslEngine.wrap(srcs[offset], this.netOutBuffer);
            state.writeCount += (long)result.bytesConsumed();
            this.netOutBuffer.flip();
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
            } else {
                this.writePending = false;
                handler.failed(new IOException("Unable to wrap data, invalid engine state: " + (Object)((Object)result.getStatus())), attachment);
                return;
            }
            this.sc.write(this.netOutBuffer, timeout, unit, state, new GatherCompletionHandler<A>(state));
        }
        catch (Throwable exp) {
            this.writePending = false;
            handler.failed(exp, attachment);
        }
    }

    @Override
    public ApplicationBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    @Override
    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public ByteBuffer getEmptyBuf() {
        return emptyBuf;
    }

    public void setBufHandler(ApplicationBufferHandler bufHandler) {
        this.bufHandler = bufHandler;
    }

    @Override
    public AsynchronousSocketChannel getIOChannel() {
        return this.sc;
    }

    public static interface ApplicationBufferHandler {
        public ByteBuffer expand(ByteBuffer var1, int var2);

        public ByteBuffer getReadBuffer();

        public ByteBuffer getWriteBuffer();
    }

    private class GatherCompletionHandler<A>
    implements CompletionHandler<Integer, GatherState<A>> {
        protected GatherState<A> state;

        protected GatherCompletionHandler(GatherState<A> state) {
            this.state = state;
        }

        @Override
        public void completed(Integer nBytes, GatherState<A> attachment) {
            if (nBytes < 0) {
                SecureNio2Channel.this.writePending = false;
                this.state.handler.failed(new EOFException(), this.state.attachment);
            } else {
                if (this.state.pos == this.state.offset + this.state.length) {
                    SecureNio2Channel.this.writePending = false;
                    this.state.handler.completed(this.state.writeCount, this.state.attachment);
                    return;
                }
                try {
                    SecureNio2Channel.this.netOutBuffer.clear();
                    SSLEngineResult result = SecureNio2Channel.this.sslEngine.wrap(this.state.srcs[this.state.offset], SecureNio2Channel.this.netOutBuffer);
                    int written = result.bytesConsumed();
                    this.state.writeCount += (long)written;
                    SecureNio2Channel.this.netOutBuffer.flip();
                    if (result.getStatus() == SSLEngineResult.Status.OK) {
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            SecureNio2Channel.this.tasks();
                        }
                    } else {
                        this.failed((Throwable)new IOException("Unable to wrap data, invalid engine state: " + (Object)((Object)result.getStatus())), attachment);
                        return;
                    }
                    if (written > 0) {
                        ++this.state.offset;
                    }
                    SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer, this.state.timeout, this.state.unit, this.state, this);
                }
                catch (Throwable exp) {
                    this.failed(exp, attachment);
                }
            }
        }

        @Override
        public void failed(Throwable exc, GatherState<A> attachment) {
            SecureNio2Channel.this.writePending = false;
            this.state.handler.failed(exc, this.state.attachment);
        }
    }

    private class GatherState<A> {
        public ByteBuffer[] srcs;
        public int offset;
        public int length;
        public A attachment;
        public long timeout;
        public TimeUnit unit;
        public CompletionHandler<Long, ? super A> handler;
        public long writeCount = 0L;
        public int pos;

        protected GatherState(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
            this.srcs = srcs;
            this.offset = offset;
            this.length = length;
            this.timeout = timeout;
            this.unit = unit;
            this.attachment = attachment;
            this.handler = handler;
            this.pos = offset + 1;
        }
    }

    private class ReadCompletionHandler<A>
    implements CompletionHandler<Integer, A> {
        protected ByteBuffer dst;
        protected CompletionHandler<Integer, ? super A> handler;

        protected ReadCompletionHandler(ByteBuffer dst, CompletionHandler<Integer, ? super A> handler) {
            this.dst = dst;
            this.handler = handler;
        }

        @Override
        public void completed(Integer nBytes, A attach) {
            if (nBytes < 0) {
                SecureNio2Channel.this.readPending = false;
                this.handler.failed(new EOFException(), attach);
                return;
            }
            try {
                int read = 0;
                do {
                    SecureNio2Channel.this.netInBuffer.flip();
                    SSLEngineResult unwrap = SecureNio2Channel.this.sslEngine.unwrap(SecureNio2Channel.this.netInBuffer, this.dst);
                    SecureNio2Channel.this.netInBuffer.compact();
                    if (unwrap.getStatus() == SSLEngineResult.Status.OK || unwrap.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        read += unwrap.bytesProduced();
                        if (unwrap.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            SecureNio2Channel.this.tasks();
                        }
                        if (unwrap.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                        break;
                    }
                    if (unwrap.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && read > 0) break;
                    throw new IOException("Unable to unwrap data, invalid status: " + (Object)((Object)unwrap.getStatus()));
                } while (SecureNio2Channel.this.netInBuffer.position() != 0);
                SecureNio2Channel.this.readPending = false;
                this.handler.completed(read, attach);
            }
            catch (Exception e) {
                SecureNio2Channel.this.readPending = false;
                this.handler.failed(e, attach);
            }
        }

        @Override
        public void failed(Throwable exc, A attach) {
            SecureNio2Channel.this.readPending = false;
            this.handler.failed(exc, attach);
        }
    }

    private class FutureWrite
    implements Future<Integer> {
        private ByteBuffer src;
        private Future<Integer> integer = null;
        private int written = 0;
        private Throwable t = null;

        protected FutureWrite(ByteBuffer src) {
            if (SecureNio2Channel.this.closing || SecureNio2Channel.this.closed) {
                this.t = new IOException("Channel is in closing state.");
                return;
            }
            this.src = src;
            this.wrap();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.integer.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.integer.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.integer.isDone();
        }

        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            if (this.t != null) {
                SecureNio2Channel.this.writePending = false;
                throw new ExecutionException(this.t);
            }
            this.integer.get();
            if (this.written == 0) {
                this.wrap();
                return this.get();
            }
            SecureNio2Channel.this.writePending = false;
            return this.written;
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.t != null) {
                SecureNio2Channel.this.writePending = false;
                throw new ExecutionException(this.t);
            }
            this.integer.get(timeout, unit);
            if (this.written == 0) {
                this.wrap();
                return this.get(timeout, unit);
            }
            SecureNio2Channel.this.writePending = false;
            return this.written;
        }

        protected void wrap() {
            SecureNio2Channel.this.netOutBuffer.clear();
            try {
                SSLEngineResult result = SecureNio2Channel.this.sslEngine.wrap(this.src, SecureNio2Channel.this.netOutBuffer);
                this.written = result.bytesConsumed();
                SecureNio2Channel.this.netOutBuffer.flip();
                if (result.getStatus() == SSLEngineResult.Status.OK) {
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        SecureNio2Channel.this.tasks();
                    }
                } else {
                    this.t = new IOException("Unable to wrap data, invalid engine state: " + (Object)((Object)result.getStatus()));
                }
                this.integer = SecureNio2Channel.this.sc.write(SecureNio2Channel.this.netOutBuffer);
            }
            catch (SSLException e) {
                this.t = e;
            }
        }
    }

    private class FutureNetRead
    extends FutureRead {
        private Future<Integer> integer;

        protected FutureNetRead(ByteBuffer dst) {
            super(dst);
            this.integer = SecureNio2Channel.this.sc.read(SecureNio2Channel.this.netInBuffer);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.integer.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.integer.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.integer.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            try {
                int netread = this.integer.get();
                Integer n = this.unwrap(netread);
                return n;
            }
            finally {
                SecureNio2Channel.this.readPending = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                int netread = this.integer.get(timeout, unit);
                Integer n = this.unwrap(netread);
                return n;
            }
            finally {
                SecureNio2Channel.this.readPending = false;
            }
        }
    }

    private class FutureRead
    implements Future<Integer> {
        private ByteBuffer dst;

        public FutureRead(ByteBuffer dst) {
            this.dst = dst;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer get() throws InterruptedException, ExecutionException {
            try {
                Integer n = this.unwrap(SecureNio2Channel.this.netInBuffer.position());
                return n;
            }
            finally {
                SecureNio2Channel.this.readPending = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                Integer n = this.unwrap(SecureNio2Channel.this.netInBuffer.position());
                return n;
            }
            finally {
                SecureNio2Channel.this.readPending = false;
            }
        }

        protected Integer unwrap(int netread) throws ExecutionException {
            if (SecureNio2Channel.this.closing || SecureNio2Channel.this.closed) {
                return -1;
            }
            if (netread == -1) {
                return -1;
            }
            int read = 0;
            do {
                SSLEngineResult unwrap;
                SecureNio2Channel.this.netInBuffer.flip();
                try {
                    unwrap = SecureNio2Channel.this.sslEngine.unwrap(SecureNio2Channel.this.netInBuffer, this.dst);
                }
                catch (SSLException e) {
                    throw new ExecutionException(e);
                }
                SecureNio2Channel.this.netInBuffer.compact();
                if (unwrap.getStatus() == SSLEngineResult.Status.OK || unwrap.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    read += unwrap.bytesProduced();
                    if (unwrap.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        SecureNio2Channel.this.tasks();
                    }
                    if (unwrap.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                    break;
                }
                if (unwrap.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && read > 0) break;
                throw new ExecutionException(new IOException("Unable to unwrap data, invalid status: " + (Object)((Object)unwrap.getStatus())));
            } while (SecureNio2Channel.this.netInBuffer.position() != 0);
            return read;
        }
    }

    private class FutureFlush
    implements Future<Boolean> {
        private Future<Integer> integer;

        protected FutureFlush(Future<Integer> integer) {
            this.integer = integer;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.integer.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.integer.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.integer.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean get() throws InterruptedException, ExecutionException {
            try {
                int result = this.integer.get();
                Boolean bl = result >= 0;
                return bl;
            }
            finally {
                SecureNio2Channel.this.writePending = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                int result = this.integer.get(timeout, unit);
                Boolean bl = result >= 0;
                return bl;
            }
            finally {
                SecureNio2Channel.this.writePending = false;
            }
        }
    }
}

