/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;

public class HttpParser {
    private static final boolean[] isToken = new boolean[128];
    private static final boolean[] isHex = new boolean[128];

    public static String unquote(String input) {
        if (input == null || input.length() < 2 || input.charAt(0) != '\"') {
            return input;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < input.length() - 1; ++i) {
            char c = input.charAt(i);
            if (input.charAt(i) == '\\') {
                result.append(input.charAt(++i));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    static boolean isToken(int c) {
        try {
            return isToken[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    static boolean isHex(int c) {
        try {
            return isHex[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    static int skipLws(StringReader input, boolean withReset) throws IOException {
        if (withReset) {
            input.mark(1);
        }
        int c = input.read();
        while (c == 32 || c == 9 || c == 10 || c == 13) {
            if (withReset) {
                input.mark(1);
            }
            c = input.read();
        }
        if (withReset) {
            input.reset();
        }
        return c;
    }

    static SkipConstantResult skipConstant(StringReader input, String constant) throws IOException {
        int len = constant.length();
        int c = HttpParser.skipLws(input, false);
        for (int i = 0; i < len; ++i) {
            if (i == 0 && c == -1) {
                return SkipConstantResult.EOF;
            }
            if (c != constant.charAt(i)) {
                input.skip(-(i + 1));
                return SkipConstantResult.NOT_FOUND;
            }
            if (i == len - 1) continue;
            c = input.read();
        }
        return SkipConstantResult.FOUND;
    }

    static String readToken(StringReader input) throws IOException {
        StringBuilder result = new StringBuilder();
        int c = HttpParser.skipLws(input, false);
        while (c != -1 && HttpParser.isToken(c)) {
            result.append((char)c);
            c = input.read();
        }
        input.skip(-1L);
        if (c != -1 && result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    static String readQuotedString(StringReader input, boolean returnQuoted) throws IOException {
        int c = HttpParser.skipLws(input, false);
        if (c != 34) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (returnQuoted) {
            result.append('\"');
        }
        c = input.read();
        while (c != 34) {
            if (c == -1) {
                return null;
            }
            if (c == 92) {
                c = input.read();
                if (returnQuoted) {
                    result.append('\\');
                }
                result.append(c);
            } else {
                result.append((char)c);
            }
            c = input.read();
        }
        if (returnQuoted) {
            result.append('\"');
        }
        return result.toString();
    }

    static String readTokenOrQuotedString(StringReader input, boolean returnQuoted) throws IOException {
        int c = HttpParser.skipLws(input, true);
        if (c == 34) {
            return HttpParser.readQuotedString(input, returnQuoted);
        }
        return HttpParser.readToken(input);
    }

    static String readQuotedToken(StringReader input) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        int c = HttpParser.skipLws(input, false);
        if (c == 34) {
            quoted = true;
        } else {
            if (c == -1 || !HttpParser.isToken(c)) {
                return null;
            }
            result.append((char)c);
        }
        c = input.read();
        while (c != -1 && HttpParser.isToken(c)) {
            result.append((char)c);
            c = input.read();
        }
        if (quoted) {
            if (c != 34) {
                return null;
            }
        } else {
            input.skip(-1L);
        }
        if (c != -1 && result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    static String readLhex(StringReader input) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        int c = HttpParser.skipLws(input, false);
        if (c == 34) {
            quoted = true;
        } else {
            if (c == -1 || !HttpParser.isHex(c)) {
                return null;
            }
            if (65 <= c && c <= 70) {
                c += 32;
            }
            result.append((char)c);
        }
        c = input.read();
        while (c != -1 && HttpParser.isHex(c)) {
            if (65 <= c && c <= 70) {
                c += 32;
            }
            result.append((char)c);
            c = input.read();
        }
        if (quoted) {
            if (c != 34) {
                return null;
            }
        } else {
            input.skip(-1L);
        }
        if (c != -1 && result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    static {
        for (int i = 0; i < 128; ++i) {
            HttpParser.isToken[i] = i < 32 ? false : i != 40 && i != 41 && i != 60 && i != 62 && i != 64 && i != 44 && i != 59 && i != 58 && i != 92 && i != 34 && i != 47 && i != 91 && i != 93 && i != 63 && i != 61 && i != 123 && i != 125 && i != 32 && i != 9;
            HttpParser.isHex[i] = i >= 48 && i <= 57 || i >= 65 && i <= 70 || i >= 97 && i <= 102;
        }
    }

    static enum SkipConstantResult {
        FOUND,
        NOT_FOUND,
        EOF;

    }
}

