/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.extension.impl;

import org.apache.uima.annotator.regex.extension.Validation;

public class CreditCardNumberValidator
implements Validation {
    public boolean validate(String coveredText, String ruleID) throws Exception {
        coveredText = coveredText.replaceAll("-", "");
        coveredText = coveredText.replaceAll(" ", "");
        if (ruleID != null && ruleID.equals("unknown")) {
            if ((coveredText.startsWith("34") || coveredText.startsWith("37")) && coveredText.length() == 15) {
                return false;
            }
            if (coveredText.length() == 16) {
                String[] masterCardStarts = new String[]{"51", "52", "53", "54", "55"};
                for (int i = 0; i < masterCardStarts.length; ++i) {
                    if (!coveredText.startsWith(masterCardStarts[i])) continue;
                    return false;
                }
            }
            if (coveredText.startsWith("4") && coveredText.length() == 16) {
                return false;
            }
        }
        char[] creditCardCharArray = coveredText.toCharArray();
        int creditCardLength = creditCardCharArray.length;
        boolean isSecond = false;
        int sum = 0;
        for (int i = creditCardLength - 1; i >= 0; --i) {
            int digit = Character.digit(creditCardCharArray[i], 10);
            if (isSecond) {
                int doubledDigit = digit * 2;
                if (doubledDigit > 9) {
                    int crossFoot = doubledDigit % 10 + 1;
                    sum += crossFoot;
                } else {
                    sum += doubledDigit;
                }
            } else {
                sum += digit;
            }
            isSecond = !isSecond;
        }
        int result = sum % 10;
        return result == 0;
    }
}

