/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.annotator.regex.Annotation;
import org.apache.uima.annotator.regex.Concept;
import org.apache.uima.annotator.regex.Feature;
import org.apache.uima.annotator.regex.FilterFeature;
import org.apache.uima.annotator.regex.Rule;
import org.apache.uima.annotator.regex.RuleException;
import org.apache.uima.annotator.regex.impl.ConceptFileParser_impl;
import org.apache.uima.annotator.regex.impl.Concept_impl;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExAnnotator
extends CasAnnotator_ImplBase {
    public static final String MESSAGE_DIGEST = "org.apache.uima.annotator.regex.regexMessages";
    public static final String REGEX_CONCEPTS_FILES = "ConceptFiles";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private Logger logger;
    private Concept[] regexConcepts;
    private boolean lastRuleExceptionMatch = false;
    private AnnotationFS lastRuleExceptionAnnotation = null;
    private NumberFormat floatNumberFormat = null;
    private NumberFormat integerNumberFormat = null;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        int i;
        super.initialize(aContext);
        this.logger = this.getContext().getLogger();
        this.floatNumberFormat = NumberFormat.getNumberInstance();
        this.integerNumberFormat = NumberFormat.getIntegerInstance();
        ConceptFileParser_impl parser = new ConceptFileParser_impl();
        String[] conceptFileNames = RegExAnnotator.safeGetConfigParameterStringArrayValue(this.getContext(), REGEX_CONCEPTS_FILES, new String[0]);
        StringTokenizer tokenizer = new StringTokenizer(this.getContext().getDataPath(), PATH_SEPARATOR);
        ArrayList<File> datapathElements = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            datapathElements.add(new File(tokenizer.nextToken()));
        }
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (int i2 = 0; i2 < conceptFileNames.length; ++i2) {
            String filename = conceptFileNames[i2];
            ArrayList<ConceptFile> cfList = new ArrayList<ConceptFile>();
            if (RegExAnnotator.containsWildcardChar(filename)) {
                this.resolveRelativeWildcardFilePath(filename, datapathElements, cfList);
            } else {
                ConceptFile file = this.resolveRelativeFilePath(filename, datapathElements);
                if (file == null) {
                    throw new RegexAnnotatorConfigException("regex_annotator_resource_not_found", new Object[]{conceptFileNames[i2]});
                }
                cfList.add(file);
                this.logger.logrb(Level.CONFIG, "RegExAnnotator", "initialize", MESSAGE_DIGEST, "regex_annotator_rule_set_file", new Object[]{file.getFilePath()});
            }
            for (ConceptFile file : cfList) {
                Concept[] currentConcepts = parser.parseConceptFile(file.getFilePath(), file.getStream());
                try {
                    file.getStream().close();
                }
                catch (IOException e) {
                    this.logger.logrb(Level.WARNING, "RegExAnnotator", "initialize", MESSAGE_DIGEST, "regex_annotator_error_closing_input_stream", new Object[]{file.getFilePath(), e.getMessage()});
                }
                for (int c = 0; c < currentConcepts.length; ++c) {
                    concepts.add(currentConcepts[c]);
                }
            }
        }
        this.regexConcepts = concepts.toArray(new Concept[0]);
        HashSet<String> conceptNames = new HashSet<String>(this.regexConcepts.length);
        for (i = 0; i < this.regexConcepts.length; ++i) {
            String name = this.regexConcepts[i].getName();
            if (name == null) continue;
            if (conceptNames.contains(name)) {
                this.logger.logrb(Level.WARNING, "RegExAnnotator", "initialize", MESSAGE_DIGEST, "regex_annotator_warning_duplicate_concept_name", new Object[]{name});
                continue;
            }
            conceptNames.add(name);
        }
        for (i = 0; i < this.regexConcepts.length; ++i) {
            ((Concept_impl)this.regexConcepts[i]).initialize(this.logger);
        }
    }

    private static String[] safeGetConfigParameterStringArrayValue(UimaContext context, String param, String[] defaultValue) {
        String[] array = (String[])context.getConfigParameterValue(param);
        if (array != null && array.length > 0) {
            return array;
        }
        return defaultValue;
    }

    private static final boolean containsWildcardChar(String filename) {
        int pos = filename.lastIndexOf(47);
        if (pos >= 0) {
            filename = filename.substring(pos);
        }
        return filename.indexOf(42) >= 0;
    }

    private static final Pattern wildcardExpr2Regex(String wildcardExpr) {
        String[] specialChars;
        for (String escape : specialChars = new String[]{"\\", ".", "+", "(", ")", "?", "[", "]", "{", "}", "$", "^", "|"}) {
            wildcardExpr = wildcardExpr.replace(escape, "\\" + escape);
        }
        wildcardExpr = wildcardExpr.replace("*", ".*");
        return Pattern.compile(wildcardExpr);
    }

    private ConceptFile resolveRelativeFilePath(String fileName, ArrayList<File> datapathElements) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(fileName);
        if (url != null) {
            InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fileName);
            ConceptFile conceptFile = new ConceptFile(url.getFile(), stream);
            return conceptFile;
        }
        if (datapathElements == null || datapathElements.size() == 0) {
            return null;
        }
        for (int i = 0; i < datapathElements.size(); ++i) {
            BufferedInputStream stream;
            File testFile = new File(datapathElements.get(i), fileName);
            if (!testFile.exists()) continue;
            try {
                stream = new BufferedInputStream(new FileInputStream(testFile));
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            ConceptFile conceptFile = new ConceptFile(testFile.getAbsolutePath(), stream);
            return conceptFile;
        }
        return null;
    }

    private void resolveRelativeWildcardFilePath(String wildcardExpr, List<File> datapathElements, List<ConceptFile> cfList) {
        if (datapathElements == null || datapathElements.size() == 0) {
            return;
        }
        Pattern pattern = RegExAnnotator.wildcardExpr2Regex(new File(wildcardExpr).getName());
        RegexFileFilter regexFileFilter = new RegexFileFilter(pattern);
        for (File dpDir : datapathElements) {
            File[] files;
            if (!dpDir.isDirectory() || !dpDir.canRead() || (files = (dpDir = new File(dpDir, wildcardExpr).getParentFile()).listFiles(regexFileFilter)).length == 0) continue;
            for (File file : files) {
                BufferedInputStream stream;
                try {
                    stream = new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException ex) {
                    continue;
                }
                ConceptFile conceptFile = new ConceptFile(file.getAbsolutePath(), stream);
                cfList.add(conceptFile);
            }
        }
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        if (this.regexConcepts != null) {
            try {
                for (int i = 0; i < this.regexConcepts.length; ++i) {
                    ((Concept_impl)this.regexConcepts[i]).typeInit(aTypeSystem);
                }
            }
            catch (ResourceInitializationException ex) {
                throw new RegexAnnotatorProcessException(ex);
            }
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        for (int i = 0; i < this.regexConcepts.length; ++i) {
            ArrayList<FeatureStructure> annotsToAdd = new ArrayList<FeatureStructure>();
            Rule[] conceptRules = this.regexConcepts[i].getRules();
            boolean foundMatch = false;
            for (int ruleCount = 0; ruleCount < conceptRules.length; ++ruleCount) {
                Pattern pattern = conceptRules[ruleCount].getRegexPattern();
                Type matchType = conceptRules[ruleCount].getMatchType();
                FSIterator mtIterator = aCAS.getAnnotationIndex(matchType).iterator();
                String matchValue = null;
                AnnotationFS currentAnnot = null;
                block2: while (mtIterator.hasNext()) {
                    currentAnnot = (AnnotationFS)mtIterator.next();
                    FilterFeature[] filterFeatures = conceptRules[ruleCount].getMatchTypeFilterFeatures();
                    boolean passed = true;
                    for (int ff = 0; ff < filterFeatures.length; ++ff) {
                        String featureValue = filterFeatures[ff].getFeaturePath().getValue(currentAnnot);
                        if (featureValue != null) {
                            Matcher matcher = filterFeatures[ff].getPattern().matcher(featureValue);
                            if (matcher.matches()) continue;
                            passed = false;
                            break;
                        }
                        passed = false;
                        break;
                    }
                    if (!passed || (matchValue = conceptRules[ruleCount].getMatchTypeFeaturePath().getValue(currentAnnot)) == null) continue;
                    Matcher matcher = pattern.matcher(matchValue);
                    if (conceptRules[ruleCount].getMatchStrategy() == 2) {
                        int pos = 0;
                        while (matcher.find(pos)) {
                            if (!this.matchRuleExceptions(conceptRules[ruleCount].getExceptions(), aCAS, currentAnnot)) {
                                this.processConceptInstructions(matcher, currentAnnot, matchValue, aCAS, this.regexConcepts[i], ruleCount, annotsToAdd);
                                foundMatch = true;
                            }
                            if (matcher.end() == pos) {
                                if (pos == matchValue.length()) continue block2;
                                ++pos;
                                continue;
                            }
                            pos = matcher.end();
                        }
                        continue;
                    }
                    if (conceptRules[ruleCount].getMatchStrategy() == 3) {
                        if (!matcher.matches() || this.matchRuleExceptions(conceptRules[ruleCount].getExceptions(), aCAS, currentAnnot)) continue;
                        this.processConceptInstructions(matcher, currentAnnot, matchValue, aCAS, this.regexConcepts[i], ruleCount, annotsToAdd);
                        foundMatch = true;
                        continue;
                    }
                    if (conceptRules[ruleCount].getMatchStrategy() != 1 || !matcher.find() || this.matchRuleExceptions(conceptRules[ruleCount].getExceptions(), aCAS, currentAnnot)) continue;
                    this.processConceptInstructions(matcher, currentAnnot, matchValue, aCAS, this.regexConcepts[i], ruleCount, annotsToAdd);
                    foundMatch = true;
                }
                if (foundMatch && !this.regexConcepts[i].processAllConceptRules()) break;
            }
            for (int x = 0; x < annotsToAdd.size(); ++x) {
                aCAS.getIndexRepository().addFS((FeatureStructure)annotsToAdd.get(x));
            }
            this.lastRuleExceptionAnnotation = null;
        }
    }

    private boolean matchRuleExceptions(RuleException[] exceptions, CAS aCAS, AnnotationFS annot) {
        if (this.lastRuleExceptionAnnotation == annot) {
            return this.lastRuleExceptionMatch;
        }
        for (int i = 0; i < exceptions.length; ++i) {
            this.lastRuleExceptionAnnotation = annot;
            AnnotationFS coverFs = this.findCoverFS(aCAS, annot, exceptions[i].getType());
            if (coverFs == null || !exceptions[i].matchPattern(coverFs)) continue;
            this.lastRuleExceptionMatch = true;
            return this.lastRuleExceptionMatch;
        }
        this.lastRuleExceptionMatch = false;
        return false;
    }

    private AnnotationFS findCoverFS(CAS aCAS, AnnotationFS annot, Type coverFsType) {
        AnnotationFS coverFs = null;
        AnnotationFS searchFs = aCAS.createAnnotation(coverFsType, annot.getBegin(), aCAS.getDocumentText().length());
        FSIterator iterator = aCAS.getAnnotationIndex(coverFsType).iterator();
        iterator.moveTo((FeatureStructure)searchFs);
        if (iterator.isValid()) {
            coverFs = (AnnotationFS)iterator.get();
            if (coverFs.getBegin() <= annot.getBegin() && coverFs.getEnd() >= annot.getEnd()) {
                return coverFs;
            }
            iterator.moveToPrevious();
            if (iterator.isValid() && (coverFs = (AnnotationFS)iterator.get()).getBegin() <= annot.getBegin() && coverFs.getEnd() >= annot.getEnd()) {
                return coverFs;
            }
        }
        iterator.moveToLast();
        if (iterator.isValid() && (coverFs = (AnnotationFS)iterator.get()).getBegin() <= annot.getBegin() && coverFs.getEnd() >= annot.getEnd()) {
            return coverFs;
        }
        return null;
    }

    private void processConceptInstructions(Matcher matcher, AnnotationFS annot, String matchingText, CAS aCAS, Concept concept, int ruleIndex, ArrayList<FeatureStructure> annotsToAdd) throws RegexAnnotatorProcessException {
        int a;
        HashMap<String, AnnotationFS> annotMap = new HashMap<String, AnnotationFS>();
        boolean hasReferenceFeatures = false;
        Annotation[] annotations = concept.getAnnotations();
        for (a = 0; a < annotations.length; ++a) {
            Type annotType = annotations[a].getAnnotationType();
            int localStart = annotations[a].getBegin().getMatchPosition(matcher);
            int localEnd = annotations[a].getEnd().getMatchPosition(matcher);
            if (localStart == -1 || localEnd == -1) continue;
            boolean validation = true;
            if (annotations[a].hasValidator()) {
                String matchText = matchingText.substring(localStart, localEnd);
                try {
                    validation = annotations[a].validate(matchText, concept.getRules()[ruleIndex].getId());
                }
                catch (Exception ex) {
                    throw new RegexAnnotatorProcessException("regex_annotator_error_validating_annotation", new Object[]{annotations[a].getId(), matchText, localStart, localEnd}, ex);
                }
            }
            if (!validation) continue;
            if (concept.getRules()[ruleIndex].isFeaturePathMatch()) {
                localStart = annot.getBegin();
                localEnd = annot.getEnd();
            } else {
                localStart = annot.getBegin() + localStart;
                localEnd = annot.getBegin() + localEnd;
            }
            AnnotationFS fs = aCAS.createAnnotation(annotType, localStart, localEnd);
            Feature[] features = annotations[a].getFeatures();
            for (int f = 0; f < features.length; ++f) {
                int type = features[f].getType();
                if (type == 3 || type == 2 || type == 1) {
                    Number number;
                    String featureValue = this.replaceMatchGroupValues(features[f].getValue(), matcher, concept.getRules()[ruleIndex]);
                    try {
                        if (featureValue != null) {
                            featureValue = features[f].normalize(featureValue, concept.getRules()[ruleIndex].getId());
                        }
                    }
                    catch (Exception ex) {
                        throw new RegexAnnotatorProcessException("regex_annotator_error_normalizing_feature_value", new Object[]{featureValue, features[f].getName()}, ex);
                    }
                    if (type == 3) {
                        try {
                            if (featureValue == null) continue;
                            number = this.floatNumberFormat.parse(featureValue);
                            fs.setFloatValue(features[f].getFeature(), number.floatValue());
                        }
                        catch (ParseException ex) {
                            this.logger.logrb(Level.WARNING, "RegExAnnotator", "processConceptInstructions", MESSAGE_DIGEST, "regex_annotator_warning_number_format_conversion", new Object[]{featureValue, features[f].getFeature().getName(), "float"});
                        }
                        continue;
                    }
                    if (type == 2) {
                        try {
                            if (featureValue == null) continue;
                            number = this.integerNumberFormat.parse(featureValue);
                            fs.setIntValue(features[f].getFeature(), number.intValue());
                        }
                        catch (ParseException ex) {
                            this.logger.logrb(Level.WARNING, "RegExAnnotator", "processConceptInstructions", MESSAGE_DIGEST, "regex_annotator_warning_number_format_conversion", new Object[]{featureValue, features[f].getFeature().getName(), "integer"});
                        }
                        continue;
                    }
                    if (type != 1) continue;
                    fs.setStringValue(features[f].getFeature(), featureValue);
                    continue;
                }
                if (type == 4) {
                    hasReferenceFeatures = true;
                    continue;
                }
                if (type == 6) {
                    String ruleId = concept.getRules()[ruleIndex].getId();
                    fs.setStringValue(features[f].getFeature(), ruleId);
                    continue;
                }
                if (type != 5) continue;
                float confidence = concept.getRules()[ruleIndex].getConfidence();
                fs.setFloatValue(features[f].getFeature(), confidence);
            }
            if (annotations[a].getId() != null) {
                annotMap.put(annotations[a].getId(), fs);
            }
            annotsToAdd.add((FeatureStructure)fs);
        }
        if (hasReferenceFeatures) {
            for (a = 0; a < annotations.length; ++a) {
                Feature[] features = annotations[a].getFeatures();
                for (int f = 0; f < features.length; ++f) {
                    int type = features[f].getType();
                    if (type != 4) continue;
                    FeatureStructure fs = (FeatureStructure)annotMap.get(annotations[a].getId());
                    FeatureStructure refFs = (FeatureStructure)annotMap.get(features[f].getValue());
                    fs.setFeatureValue(features[f].getFeature(), refFs);
                }
            }
        }
        Feature[] updateFeatures = concept.getRules()[ruleIndex].getMatchTypeUpdateFeatures();
        for (int f = 0; f < updateFeatures.length; ++f) {
            int type = updateFeatures[f].getType();
            if (type == 3 || type == 2 || type == 1) {
                String featureValue = this.replaceMatchGroupValues(updateFeatures[f].getValue(), matcher, concept.getRules()[ruleIndex]);
                try {
                    featureValue = updateFeatures[f].normalize(featureValue, concept.getRules()[ruleIndex].getId());
                }
                catch (Exception ex) {
                    throw new RegexAnnotatorProcessException("regex_annotator_error_normalizing_feature_value", new Object[]{featureValue, updateFeatures[f].getName()}, ex);
                }
                if (type == 3) {
                    annot.setFloatValue(updateFeatures[f].getFeature(), Float.parseFloat(featureValue));
                    continue;
                }
                if (type == 2) {
                    annot.setIntValue(updateFeatures[f].getFeature(), Integer.parseInt(featureValue));
                    continue;
                }
                if (type != 1) continue;
                annot.setStringValue(updateFeatures[f].getFeature(), featureValue);
                continue;
            }
            if (type == 4) {
                FeatureStructure refFs = (FeatureStructure)annotMap.get(updateFeatures[f].getValue());
                annot.setFeatureValue(updateFeatures[f].getFeature(), refFs);
                continue;
            }
            if (type == 6) {
                String ruleId = concept.getRules()[ruleIndex].getId();
                annot.setStringValue(updateFeatures[f].getFeature(), ruleId);
                continue;
            }
            if (type != 5) continue;
            float confidence = concept.getRules()[ruleIndex].getConfidence();
            annot.setFloatValue(updateFeatures[f].getFeature(), confidence);
        }
    }

    private String replaceMatchGroupValues(String featureValue, Matcher matcher, Rule rule) throws RegexAnnotatorProcessException {
        StringBuffer replaced = new StringBuffer();
        int pos = 0;
        int end = featureValue.length();
        while (pos < end) {
            char c = featureValue.charAt(pos);
            if (c == '\\') {
                if (++pos >= end) continue;
                replaced.append(featureValue.charAt(pos));
                ++pos;
                continue;
            }
            if (c == '$') {
                String groupMatch;
                if (++pos >= end) continue;
                c = featureValue.charAt(pos);
                int groupNumber = -1;
                if (c == '{') {
                    int matchNameEnd;
                    if ((matchNameEnd = featureValue.indexOf("}", ++pos)) > -1) {
                        String matchGroupName = featureValue.substring(pos, matchNameEnd);
                        groupNumber = rule.getMatchGroupNumber(matchGroupName);
                        if (groupNumber == -1) {
                            throw new RegexAnnotatorProcessException("regex_annotator_error_match_group_name_not_found", new Object[]{matchGroupName, rule.getId()});
                        }
                        pos = matchNameEnd + 1;
                    }
                } else {
                    groupNumber = c - 48;
                    ++pos;
                }
                if ((groupMatch = matcher.group(groupNumber)) == null) continue;
                replaced.append(groupMatch);
                continue;
            }
            replaced.append(c);
            ++pos;
        }
        return replaced.toString();
    }

    private static class ConceptFile {
        private String filePath;
        private InputStream stream;

        public ConceptFile(String filePath, InputStream stream) {
            this.filePath = filePath;
            this.stream = stream;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public InputStream getStream() {
            return this.stream;
        }
    }

    private static final class RegexFileFilter
    implements FileFilter {
        private Pattern pattern;

        private RegexFileFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }
}

