/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.annotator.regex.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.annotator.regex.RuleException;
import org.apache.uima.annotator.regex.impl.RegexAnnotatorConfigException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

public class RuleException_impl
implements RuleException {
    private final String matchTypeStr;
    private final String patternStr;
    private Type matchType;
    private Pattern pattern;
    private AnnotationFS lastAnnot = null;
    private boolean lastMatchResult = false;

    public RuleException_impl(String matchType, String patternStr) {
        this.matchTypeStr = matchType;
        this.patternStr = patternStr;
        this.matchType = null;
        this.pattern = null;
    }

    public boolean matchPattern(AnnotationFS annot) {
        Matcher matcher;
        if (this.lastAnnot == annot) {
            return this.lastMatchResult;
        }
        this.lastAnnot = annot;
        if (this.pattern != null && (matcher = this.pattern.matcher(annot.getCoveredText())).find()) {
            this.lastMatchResult = true;
            return true;
        }
        this.lastMatchResult = false;
        return false;
    }

    public Type getType() {
        return this.matchType;
    }

    public void typeInit(TypeSystem ts) throws ResourceInitializationException {
        if (this.matchTypeStr != null) {
            this.matchType = ts.getType(this.matchTypeStr);
            if (this.matchType == null) {
                throw new RegexAnnotatorConfigException("regex_annotator_error_resolving_types", new Object[]{this.matchTypeStr});
            }
        }
    }

    public void initialize() {
        this.pattern = Pattern.compile(this.patternStr);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Exception: ");
        buffer.append("\n  matchType: ");
        buffer.append(this.matchTypeStr);
        buffer.append("\n  Pattern: ");
        buffer.append(this.patternStr);
        buffer.append("\n");
        return buffer.toString();
    }
}

