/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree;

import javax.swing.tree.TreeModel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.tree.LinkType;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

@Deprecated
public abstract class BaseTree
extends AbstractTree {
    private static final ResourceReference CSS = new CssResourceReference(BaseTree.class, "res/base-tree.css");
    private static final long serialVersionUID = 1L;
    private static final String JUNCTION_LINK_ID = "junctionLink";
    private static final String NODE_COMPONENT_ID = "nodeComponent";
    private LinkType linkType = LinkType.AJAX;

    public BaseTree(String id) {
        this(id, null);
    }

    public BaseTree(String id, IModel<? extends TreeModel> model) {
        super(id, model);
    }

    protected ResourceReference getCSS() {
        return CSS;
    }

    @Override
    protected void populateTreeItem(WebMarkupContainer item, int level) {
        Object node = item.getDefaultModelObject();
        Component junctionLink = this.newJunctionLink((MarkupContainer)item, JUNCTION_LINK_ID, node);
        junctionLink.add(new Behavior[]{new JunctionBorder(node, level)});
        item.add(new Component[]{junctionLink});
        Component nodeComponent = this.newNodeComponent(NODE_COMPONENT_ID, (IModel<Object>)item.getDefaultModel());
        item.add(new Component[]{nodeComponent});
        item.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                Object node = component.getDefaultModelObject();
                String klass = BaseTree.this.getItemClass(node);
                if (!Strings.isEmpty((CharSequence)klass)) {
                    String oldClass = tag.getAttribute("class");
                    if (Strings.isEmpty((CharSequence)oldClass)) {
                        tag.put("class", (CharSequence)klass);
                    } else {
                        tag.put("class", (CharSequence)(oldClass + " " + klass));
                    }
                }
            }
        }});
    }

    protected String getItemClass(Object node) {
        if (this.getTreeState().isNodeSelected(node)) {
            return this.getSelectedClass();
        }
        return null;
    }

    protected String getSelectedClass() {
        return "selected";
    }

    protected abstract Component newNodeComponent(String var1, IModel<Object> var2);

    private boolean isNodeLast(Object node) {
        Object parent = this.getParentNode(node);
        if (parent == null) {
            return true;
        }
        return this.getChildAt(parent, this.getChildCount(parent) - 1).equals(node);
    }

    protected Component newJunctionLink(MarkupContainer parent, String id, final Object node) {
        WebMarkupContainer junctionLink;
        if (!this.isLeaf(node)) {
            junctionLink = this.newLink(id, new ILinkCallback(){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    if (BaseTree.this.isNodeExpanded(node)) {
                        BaseTree.this.getTreeState().collapseNode(node);
                    } else {
                        BaseTree.this.getTreeState().expandNode(node);
                    }
                    BaseTree.this.onJunctionLinkClicked(target, node);
                    if (target != null) {
                        BaseTree.this.updateTree(target);
                    }
                }
            });
            junctionLink.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 1L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    if (BaseTree.this.isNodeExpanded(node)) {
                        tag.put("class", (CharSequence)"junction-open");
                    } else {
                        tag.put("class", (CharSequence)"junction-closed");
                    }
                }
            }});
        } else {
            junctionLink = new WebMarkupContainer(id){
                private static final long serialVersionUID = 1L;

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.setName("span");
                    tag.put("class", (CharSequence)"junction-corner");
                }
            };
        }
        return junctionLink;
    }

    protected void onJunctionLinkClicked(AjaxRequestTarget target, Object node) {
    }

    public MarkupContainer newLink(String id, final ILinkCallback callback) {
        if (this.getLinkType() == LinkType.REGULAR) {
            return new Link<Void>(id){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    callback.onClick(null);
                }
            };
        }
        if (this.getLinkType() == LinkType.AJAX) {
            return new AjaxLink<Void>(id){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    callback.onClick(target);
                }
            };
        }
        return new AjaxFallbackLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                callback.onClick(target);
            }
        };
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(LinkType linkType) {
        if (this.linkType != linkType) {
            this.linkType = linkType;
        }
    }

    @Override
    protected boolean isForceRebuildOnSelectionChange() {
        return false;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        ResourceReference css = this.getCSS();
        if (css != null) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)css));
        }
    }

    public static interface ILinkCallback
    extends IAjaxLink,
    IClusterable {
    }

    private class JunctionBorder
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final Object node;
        private final int level;

        public JunctionBorder(Object node, int level) {
            this.node = node;
            this.level = level;
        }

        public void afterRender(Component component) {
            component.getResponse().write((CharSequence)"</td>");
        }

        public void beforeRender(Component component) {
            int i;
            Response response = component.getResponse();
            Object parent = BaseTree.this.getParentNode(this.node);
            CharSequence[] classes = new CharSequence[this.level];
            for (i = 0; i < this.level; ++i) {
                classes[i] = parent == null || BaseTree.this.isNodeLast(parent) ? "spacer" : "line";
                parent = BaseTree.this.getParentNode(parent);
            }
            for (i = this.level - 1; i >= 0; --i) {
                response.write((CharSequence)("<td class=\"" + classes[i] + "\"><span></span></td>"));
            }
            if (BaseTree.this.isNodeLast(this.node)) {
                response.write((CharSequence)"<td class=\"half-line\">");
            } else {
                response.write((CharSequence)"<td class=\"line\">");
            }
        }
    }
}

